/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import com.ibm.icu.text.Collator;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.ecommons.runtime.core.util.PathUtils;
import org.eclipse.statet.internal.ltk.ui.LTKUIPlugin;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.CompletionProposalWithOverwrite;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IContentAssistComputer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class PathCompletionComputor
implements IContentAssistComputer {
    private char fileSeparator;
    private char fileSeparatorBackup;
    private boolean isWindows;
    private ISourceEditor editor;

    public abstract String getPluginId();

    protected ISourceEditor getEditor() {
        return this.editor;
    }

    @Override
    public void sessionStarted(ISourceEditor editor, ContentAssist assist) {
        this.editor = editor;
        this.isWindows = this.getIsWindows();
        this.fileSeparator = this.getDefaultFileSeparator();
    }

    @Override
    public void sessionEnded() {
        this.editor = null;
    }

    protected boolean getIsWindows() {
        return SystemUtils.getLocalOs() == 1;
    }

    protected final boolean isWindows() {
        return this.isWindows;
    }

    protected char getDefaultFileSeparator() {
        return this.isWindows() ? (char)'\\' : '/';
    }

    protected char getSegmentSeparator() {
        return this.fileSeparator;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'/', '\\', ':'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    @Override
    public IStatus computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        String completionPrefix;
        IFileStore baseStore;
        String segmentPrefix;
        int offset;
        block22: {
            IPath basePath;
            IPath path;
            boolean needSeparatorBeforeStart;
            String prefix;
            block21: {
                block20: {
                    TextRegion contentRange;
                    block19: {
                        offset = context.getInvocationOffset();
                        contentRange = this.getContentRange(context, mode);
                        if (contentRange != null) break block19;
                        return null;
                    }
                    prefix = this.checkPrefix(context.getSourceViewer().getDocument().get(contentRange.getStartOffset(), offset - contentRange.getStartOffset()));
                    if (prefix != null) break block20;
                    return null;
                }
                needSeparatorBeforeStart = false;
                segmentPrefix = "";
                baseStore = null;
                if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) == '.') {
                    if (prefix.equals(".") || prefix.endsWith("/.") || this.isWindows() && prefix.endsWith("\\.")) {
                        prefix = prefix.substring(0, prefix.length() - 1);
                        segmentPrefix = ".";
                    } else if (prefix.equals("..") || prefix.endsWith("/..") || this.isWindows() && prefix.endsWith("\\..")) {
                        prefix = prefix.substring(0, prefix.length() - 2);
                        segmentPrefix = "..";
                    }
                }
                if ((path = this.createPath(prefix)) != null) break block21;
                return null;
            }
            if (path.segmentCount() == 0) {
                if (this.isWindows() && path.getDevice() != null && !path.isRoot()) {
                    path = path.addTrailingSeparator();
                    needSeparatorBeforeStart = true;
                }
            } else if (segmentPrefix.isEmpty() && !path.hasTrailingSeparator()) {
                segmentPrefix = path.lastSegment();
                path = path.removeLastSegments(1);
            }
            if (path.isAbsolute() && this.isWindows() && path.getDevice() == null && !path.isUNC() && (basePath = this.getRelativeBasePath()) != null) {
                path = path.setDevice(basePath.getDevice());
            }
            baseStore = this.resolveStore(path);
            this.updatePathSeparator(prefix);
            String string = completionPrefix = needSeparatorBeforeStart ? Character.toString(this.fileSeparator) : null;
            if (baseStore != null && baseStore.fetchInfo().exists()) break block22;
            if (path != null) {
                return this.tryAlternative(context, path, offset - segmentPrefix.length(), segmentPrefix, completionPrefix, proposals);
            }
            return null;
        }
        try {
            this.doAddChildren(context, baseStore, offset - segmentPrefix.length(), segmentPrefix, completionPrefix, proposals);
            if (!segmentPrefix.isEmpty() && !segmentPrefix.equals(".") && (baseStore = baseStore.getChild(segmentPrefix)).fetchInfo().exists()) {
                StringBuilder prefixBuilder = new StringBuilder();
                if (completionPrefix != null) {
                    prefixBuilder.append(completionPrefix);
                }
                prefixBuilder.append(baseStore.getName());
                prefixBuilder.append(this.fileSeparator);
                completionPrefix = prefixBuilder.toString();
                this.doAddChildren(context, baseStore, offset - segmentPrefix.length(), "", completionPrefix, proposals);
            }
            return Status.OK_STATUS;
        }
        catch (BadLocationException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", -1, "An error occurred while preparing path completions.", (Throwable)e), 1);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", -1, "An error occurred while preparing path completions.", (Throwable)e), 1);
        }
        this.restorePathSeparator();
        return null;
    }

    @Override
    public IStatus computeInformationProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        return null;
    }

    protected String checkPrefix(String prefix) {
        char[] breakingChars = "\n\r+<>|?*\"".toCharArray();
        int i = 0;
        while (i < breakingChars.length) {
            if (prefix.indexOf(breakingChars[i]) >= 0) {
                return null;
            }
            ++i;
        }
        return prefix;
    }

    private IPath createPath(String s) {
        if (this.isWindows() && File.separatorChar == '/') {
            s = s.replace('\\', '/');
        }
        return PathUtils.check((IPath)new Path(s));
    }

    private void updatePathSeparator(String prefix) {
        int lastForw;
        int lastBack = prefix.lastIndexOf(92);
        if (lastBack > (lastForw = prefix.lastIndexOf(47))) {
            this.fileSeparatorBackup = this.fileSeparator;
            this.fileSeparator = (char)92;
        } else if (lastForw > lastBack) {
            this.fileSeparatorBackup = this.fileSeparator;
            this.fileSeparator = (char)47;
        }
    }

    private void restorePathSeparator() {
        if (this.fileSeparatorBackup != '\u0000') {
            this.fileSeparator = this.fileSeparatorBackup;
            this.fileSeparatorBackup = '\u0000';
        }
    }

    protected void doAddChildren(AssistInvocationContext context, IFileStore baseStore, int startOffset, String segmentPrefix, String completionPrefix, AssistProposalCollector proposals) throws CoreException {
        IContainer[] workspaceRefs = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(baseStore.toURI());
        IContainer workspaceRef = workspaceRefs.length > 0 ? workspaceRefs[0] : null;
        String[] names = baseStore.childNames(0, (IProgressMonitor)new NullProgressMonitor());
        Arrays.sort(names, Collator.getInstance());
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (segmentPrefix.isEmpty() || name.regionMatches(true, 0, segmentPrefix, 0, segmentPrefix.length())) {
                proposals.add(new ResourceProposal(context, startOffset, baseStore.getChild(name), null, completionPrefix, workspaceRef));
            }
            ++n2;
        }
    }

    protected abstract TextRegion getContentRange(AssistInvocationContext var1, int var2) throws BadLocationException;

    protected IPath getRelativeBasePath() {
        return null;
    }

    protected IFileStore getRelativeBaseStore() {
        return null;
    }

    protected IFileStore resolveStore(IPath path) throws CoreException {
        if (!path.isAbsolute()) {
            if (!this.isWindows() && path.getDevice() == null && "~".equals(path.segment(0))) {
                Path homePath = new Path(System.getProperty("user.home"));
                path = PathUtils.check((IPath)homePath.append(path.removeFirstSegments(1)));
            } else {
                IFileStore base = this.getRelativeBaseStore();
                if (base != null) {
                    return base.getFileStore(path);
                }
                return null;
            }
        }
        return EFS.getStore((URI)URIUtil.toURI((IPath)path));
    }

    protected IStatus tryAlternative(AssistInvocationContext context, IPath path, int startOffset, String segmentPrefix, String completionPrefix, AssistProposalCollector proposals) throws CoreException {
        return null;
    }

    protected String checkPathCompletion(IDocument document, int completionOffset, String completion) throws BadLocationException {
        return completion;
    }

    protected class ResourceProposal
    extends CompletionProposalWithOverwrite
    implements ICompletionProposalExtension3 {
        private final IFileStore fileStore;
        private final boolean isDirectory;
        private final IContainer workspaceRef;
        private final String name;
        private String completion;
        private IRegion selectionToSet;

        public ResourceProposal(AssistInvocationContext context, int offset, IFileStore fileStore, String explicitName, String prefix, IContainer workspaceRef) {
            super(context, offset);
            this.fileStore = fileStore;
            this.isDirectory = this.fileStore.fetchInfo().isDirectory();
            this.workspaceRef = workspaceRef;
            StringBuilder name = new StringBuilder(explicitName != null ? explicitName : this.fileStore.getName());
            if (prefix != null) {
                name.insert(0, prefix);
            }
            if (this.isDirectory) {
                name.append(PathCompletionComputor.this.fileSeparator);
            }
            this.name = name.toString();
        }

        @Override
        protected String getPluginId() {
            return PathCompletionComputor.this.getPluginId();
        }

        @Override
        public int getRelevance() {
            return 20;
        }

        @Override
        public String getSortingString() {
            return this.name;
        }

        public boolean isAutoInsertable() {
            return false;
        }

        private void createCompletion(IDocument document) {
            if (this.completion == null) {
                try {
                    this.completion = PathCompletionComputor.this.checkPathCompletion(document, this.getReplacementOffset(), this.name);
                }
                catch (BadLocationException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", -1, "An error occurred while creating the final path completion.", (Throwable)e), 1);
                }
            }
        }

        @Override
        protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
            int end = Math.max(caretOffset, selection.x + selection.y);
            if (overwrite) {
                IDocument document = this.getInvocationContext().getSourceViewer().getDocument();
                int length = document.getLength();
                while (end < length) {
                    char c = document.getChar(end);
                    if (!Character.isLetterOrDigit(c) && c != '_' && c != '.') break;
                    ++end;
                }
                if (end >= length) {
                    end = length;
                }
            }
            return end - replacementOffset;
        }

        public Image getImage() {
            IResource member;
            Image image = null;
            if (this.workspaceRef != null && (member = this.workspaceRef.findMember(this.fileStore.getName(), true)) != null) {
                image = LTKUIPlugin.getInstance().getWorkbenchLabelProvider().getImage((Object)member);
            }
            if (image == null) {
                image = PlatformUI.getWorkbench().getSharedImages().getImage(this.isDirectory ? "IMG_OBJ_FOLDER" : "IMG_OBJ_FILE");
            }
            return image;
        }

        public String getDisplayString() {
            return this.name;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public IInformationControlCreator getInformationControlCreator() {
            return null;
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            int replacementOffset = this.getReplacementOffset();
            if (offset < replacementOffset) {
                return false;
            }
            try {
                String startsWith = document.get(replacementOffset, offset - replacementOffset);
                return this.name.regionMatches(true, 0, startsWith, 0, startsWith.length());
            }
            catch (BadLocationException e) {
                return false;
            }
        }

        @Override
        protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
            AssistInvocationContext context = this.getInvocationContext();
            SourceViewer viewer = context.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.createCompletion(document);
            Position newSelectionOffset = new Position(replacementOffset + replacementLength, 0);
            try {
                try {
                    document.addPosition(newSelectionOffset);
                    document.replace(replacementOffset, newSelectionOffset.getOffset() - replacementOffset, this.completion);
                    this.selectionToSet = new Region(newSelectionOffset.getOffset(), 0);
                }
                catch (BadLocationException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", -1, "An error occurred while inserting the path completion.", (Throwable)e), 3);
                    document.removePosition(newSelectionOffset);
                    return;
                }
            }
            finally {
                document.removePosition(newSelectionOffset);
            }
            if (this.isDirectory) {
                this.reinvokeAssist((ITextViewer)viewer);
            }
        }

        public Point getSelection(IDocument document) {
            if (this.selectionToSet != null) {
                return new Point(this.selectionToSet.getOffset(), this.selectionToSet.getLength());
            }
            return null;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return this.getReplacementOffset();
        }

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            this.createCompletion(document);
            return this.completion;
        }
    }
}

