/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.StdBinary;

public abstract class Arithmetic
extends StdBinary {
    protected Arithmetic() {
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    static final class Div
    extends Arithmetic {
        @Override
        public final NodeType getNodeType() {
            return NodeType.MULT;
        }

        @Override
        public RTerminal getOperator(int index) {
            return RTerminal.DIV;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return element.getNodeType() == NodeType.MULT;
        }
    }

    static final class Minus
    extends Arithmetic {
        @Override
        public final NodeType getNodeType() {
            return NodeType.ADD;
        }

        @Override
        public RTerminal getOperator(int index) {
            return RTerminal.MINUS;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return element.getNodeType() == NodeType.ADD;
        }
    }

    static final class Mult
    extends Arithmetic {
        @Override
        public final NodeType getNodeType() {
            return NodeType.MULT;
        }

        @Override
        public RTerminal getOperator(int index) {
            return RTerminal.MULT;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return element.getNodeType() == NodeType.MULT;
        }
    }

    static final class Plus
    extends Arithmetic {
        @Override
        public final NodeType getNodeType() {
            return NodeType.ADD;
        }

        @Override
        public RTerminal getOperator(int index) {
            return RTerminal.PLUS;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return element.getNodeType() == NodeType.ADD;
        }
    }
}

