/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.intable;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.config.AbstractUiBindingConfiguration;
import org.eclipse.statet.ecommons.waltable.coordinate.Direction;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.resize.ColumnResizeEventMatcher;
import org.eclipse.statet.ecommons.waltable.resize.InitializeAutoResizeCommand;
import org.eclipse.statet.ecommons.waltable.resize.PositionResizeDragMode;
import org.eclipse.statet.ecommons.waltable.resize.action.AutoResizeColumnAction;
import org.eclipse.statet.ecommons.waltable.resize.action.ColumnResizeCursorAction;
import org.eclipse.statet.ecommons.waltable.selection.SelectRelativeCellCommand;
import org.eclipse.statet.ecommons.waltable.selection.action.CellSelectionDragMode;
import org.eclipse.statet.ecommons.waltable.selection.action.RowSelectionDragMode;
import org.eclipse.statet.ecommons.waltable.selection.action.SelectCellAction;
import org.eclipse.statet.ecommons.waltable.sort.ClearSortCommand;
import org.eclipse.statet.ecommons.waltable.sort.SortDimPositionCommand;
import org.eclipse.statet.ecommons.waltable.sort.SortDirection;
import org.eclipse.statet.ecommons.waltable.sort.action.SortColumnAction;
import org.eclipse.statet.ecommons.waltable.ui.NatEventData;
import org.eclipse.statet.ecommons.waltable.ui.action.AbstractNavigationAction;
import org.eclipse.statet.ecommons.waltable.ui.action.ClearCursorAction;
import org.eclipse.statet.ecommons.waltable.ui.action.IDragMode;
import org.eclipse.statet.ecommons.waltable.ui.action.IKeyAction;
import org.eclipse.statet.ecommons.waltable.ui.action.IMouseAction;
import org.eclipse.statet.ecommons.waltable.ui.action.NoOpMouseAction;
import org.eclipse.statet.ecommons.waltable.ui.binding.UiBindingRegistry;
import org.eclipse.statet.ecommons.waltable.ui.matcher.IKeyEventMatcher;
import org.eclipse.statet.ecommons.waltable.ui.matcher.IMouseEventMatcher;
import org.eclipse.statet.ecommons.waltable.ui.matcher.KeyEventMatcher;
import org.eclipse.statet.ecommons.waltable.ui.matcher.MouseEventMatcher;
import org.eclipse.statet.ecommons.waltable.ui.menu.PopupMenuAction;
import org.eclipse.statet.ecommons.waltable.viewport.ScrollStepCommand;
import org.eclipse.statet.ecommons.waltable.viewport.SelectRelativePageCommand;
import org.eclipse.statet.ecommons.waltable.viewport.action.ViewportSelectDimPositionsAction;
import org.eclipse.statet.internal.r.ui.intable.NatTableContributionItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class UIBindings {
    private static final int CELL = 1;
    private static final int PAGE = 2;
    private static final int TABLE = 3;

    public static class BodyContextMenuConfiguration
    extends AbstractUiBindingConfiguration {
        private final MenuManager menuManager = new MenuManager();

        public BodyContextMenuConfiguration(NatTable natTable, IServiceLocator serviceLocator) {
            this.menuManager.createContextMenu((Control)natTable);
            natTable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    menuManager.dispose();
                }
            });
            this.menuManager.add((IContributionItem)new Separator("edit"));
            this.menuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.edit.copy", null, null, null, null, SharedMessages.CopyAction_name, null, null, 8, null, false)));
        }

        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerSingleClickBinding((IMouseEventMatcher)new MouseEventMatcher(0, "BODY", 3), (IMouseAction)new PopupMenuAction(this.menuManager.getMenu()));
        }

        public IMenuManager getMenuManager() {
            return this.menuManager;
        }
    }

    public static class ColumnHeaderConfiguration
    extends AbstractUiBindingConfiguration {
        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(0, true), (IMouseAction)new ColumnResizeCursorAction());
            uiBindingRegistry.registerMouseMoveBinding((IMouseEventMatcher)new MouseEventMatcher(), (IMouseAction)new ClearCursorAction());
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new ColumnResizeEventMatcher(1, true), (IDragMode)new PositionResizeDragMode(Orientation.HORIZONTAL));
            uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(1, true), (IMouseAction)new AutoResizeColumnAction());
            uiBindingRegistry.registerSingleClickBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(1, true), (IMouseAction)new NoOpMouseAction());
        }
    }

    public static class HeaderContextMenuConfiguration
    extends AbstractUiBindingConfiguration {
        private final MenuManager menuManager = new MenuManager();

        public HeaderContextMenuConfiguration(NatTable natTable) {
            this.menuManager.createContextMenu((Control)natTable);
            natTable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    menuManager.dispose();
                }
            });
            this.menuManager.add((IContributionItem)new Separator("sorting"));
            this.menuManager.add((IContributionItem)new NatTableContributionItem(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/sort.alpha"), null, "Sort Increasing by Column", "I"){

                @Override
                protected void execute(NatEventData eventData) throws ExecutionException {
                    eventData.getNatTable().doCommand((ILayerCommand)new SortDimPositionCommand((ILayerDim)eventData.getNatTable().getDim(Orientation.HORIZONTAL), eventData.getColumnPosition(), SortDirection.ASC, false));
                }
            });
            this.menuManager.add((IContributionItem)new NatTableContributionItem("Sort Decreasing by Column", "D"){

                @Override
                protected void execute(NatEventData eventData) throws ExecutionException {
                    eventData.getNatTable().doCommand((ILayerCommand)new SortDimPositionCommand((ILayerDim)eventData.getNatTable().getDim(Orientation.HORIZONTAL), eventData.getColumnPosition(), SortDirection.DESC, false));
                }
            });
            this.menuManager.add((IContributionItem)new NatTableContributionItem("Clear All Sorting", "O"){

                @Override
                protected void execute(NatEventData eventData) throws ExecutionException {
                    eventData.getNatTable().doCommand((ILayerCommand)new ClearSortCommand());
                }
            });
            this.menuManager.add((IContributionItem)new Separator());
            this.menuManager.add((IContributionItem)new NatTableContributionItem("Auto Resize Column", "R"){

                @Override
                protected void execute(NatEventData eventData) throws ExecutionException {
                    eventData.getNatTable().doCommand((ILayerCommand)new InitializeAutoResizeCommand((ILayerDim)eventData.getNatTable().getDim(Orientation.HORIZONTAL), eventData.getColumnPosition()));
                }
            });
        }

        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerSingleClickBinding((IMouseEventMatcher)new MouseEventMatcher(0, "COLUMN_HEADER", 3), (IMouseAction)new PopupMenuAction(this.menuManager.getMenu()));
        }

        public IMenuManager getMenuManager() {
            return this.menuManager;
        }
    }

    public static class ScrollAction
    extends AbstractNavigationAction {
        private final int type;

        public ScrollAction(Direction direction, int type) {
            super(direction);
            this.type = type;
        }

        public void run(NatTable natTable, KeyEvent event) {
            switch (this.type) {
                case 1: {
                    natTable.doCommand((ILayerCommand)new ScrollStepCommand(this.getDirection()));
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    natTable.doCommand((ILayerCommand)new ScrollStepCommand(this.getDirection()));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static class SelectRelativeAction
    extends AbstractNavigationAction {
        private final int type;

        public SelectRelativeAction(Direction direction, int type) {
            super(direction);
            this.type = type;
        }

        public void run(NatTable natTable, KeyEvent event) {
            int selectionFlags = event.stateMask & 0x20000;
            switch (this.type) {
                case 1: {
                    natTable.doCommand((ILayerCommand)new SelectRelativeCellCommand(this.getDirection(), 1L, selectionFlags));
                    break;
                }
                case 2: {
                    natTable.doCommand((ILayerCommand)new SelectRelativePageCommand(this.getDirection(), selectionFlags));
                    break;
                }
                case 3: {
                    natTable.doCommand((ILayerCommand)new SelectRelativeCellCommand(this.getDirection(), -1L, selectionFlags));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static class SelectionConfiguration
    extends AbstractUiBindingConfiguration {
        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(262144, 0x1000001), (IKeyAction)new ScrollAction(Direction.UP, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(262144, 0x1000002), (IKeyAction)new ScrollAction(Direction.DOWN, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(262144, 0x1000003), (IKeyAction)new ScrollAction(Direction.LEFT, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(262144, 0x1000004), (IKeyAction)new ScrollAction(Direction.RIGHT, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(0, 0x1000001), (IKeyAction)new SelectRelativeAction(Direction.UP, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(0, 0x1000002), (IKeyAction)new SelectRelativeAction(Direction.DOWN, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(0, 0x1000003), (IKeyAction)new SelectRelativeAction(Direction.LEFT, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(0, 0x1000004), (IKeyAction)new SelectRelativeAction(Direction.RIGHT, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(0, 0x1000005), (IKeyAction)new SelectRelativeAction(Direction.UP, 2));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(0, 0x1000006), (IKeyAction)new SelectRelativeAction(Direction.DOWN, 2));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(0, 0x1000007), (IKeyAction)new SelectRelativeAction(Direction.LEFT, 3));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(0, 0x1000008), (IKeyAction)new SelectRelativeAction(Direction.RIGHT, 3));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(262144, 0x1000007), (IKeyAction)new SelectRelativeAction(Direction.UP, 3));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(262144, 0x1000008), (IKeyAction)new SelectRelativeAction(Direction.DOWN, 3));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(131072, 0x1000001), (IKeyAction)new SelectRelativeAction(Direction.UP, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(131072, 0x1000002), (IKeyAction)new SelectRelativeAction(Direction.DOWN, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(131072, 0x1000003), (IKeyAction)new SelectRelativeAction(Direction.LEFT, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(131072, 0x1000004), (IKeyAction)new SelectRelativeAction(Direction.RIGHT, 1));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(131072, 0x1000005), (IKeyAction)new SelectRelativeAction(Direction.UP, 2));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(131072, 0x1000006), (IKeyAction)new SelectRelativeAction(Direction.DOWN, 2));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(131072, 0x1000007), (IKeyAction)new SelectRelativeAction(Direction.LEFT, 3));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(131072, 0x1000008), (IKeyAction)new SelectRelativeAction(Direction.RIGHT, 3));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(393216, 0x1000007), (IKeyAction)new SelectRelativeAction(Direction.UP, 3));
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(393216, 0x1000008), (IKeyAction)new SelectRelativeAction(Direction.DOWN, 3));
            uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(393217, "BODY", 1), (IMouseAction)new SelectCellAction());
            uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(393217, "COLUMN_HEADER", 1), (IMouseAction)new ViewportSelectDimPositionsAction(Orientation.HORIZONTAL));
            uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(393217, "ROW_HEADER", 1), (IMouseAction)new ViewportSelectDimPositionsAction(Orientation.VERTICAL));
            uiBindingRegistry.registerMouseDragMode((IMouseEventMatcher)new MouseEventMatcher(393217, "BODY", 1), (IDragMode)new CellSelectionDragMode());
            uiBindingRegistry.registerMouseDragMode((IMouseEventMatcher)new MouseEventMatcher(393217, "ROW_HEADER", 1), (IDragMode)new RowSelectionDragMode());
        }
    }

    public static class SortConfiguration
    extends AbstractUiBindingConfiguration {
        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerSingleClickBinding((IMouseEventMatcher)new MouseEventMatcher(65536, "COLUMN_HEADER", 1), (IMouseAction)new SortColumnAction(false));
        }
    }
}

