/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.buildpaths.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathsUIResources;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.statushandlers.StatusManager;

public class BuildpathElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static final int DEPRECATED = 16;
    public static final int IGNORE_OPTIONAL_PROBLEMS = 256;
    private final ImageDescriptor baseImage;
    private final int flags;
    private final Point size;

    private static ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.statet.ltk.buildpaths.ui", "Image data not available: " + descriptor.toString()));
        }
        return data;
    }

    public BuildpathElementImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        if (baseImage == null) {
            throw new NullPointerException("baseImage");
        }
        this.baseImage = baseImage;
        this.flags = flags;
        if (size != null) {
            this.size = size;
        } else {
            ImageData data = BuildpathElementImageDescriptor.getImageData(baseImage);
            this.size = new Point(data.width, data.height);
        }
    }

    protected final ImageDescriptor getBaseImage() {
        return this.baseImage;
    }

    protected final int getFlags() {
        return this.flags;
    }

    protected final Point getSize() {
        return this.size;
    }

    protected void drawCompositeImage(int width, int height) {
        if ((this.flags & 0x10) != 0) {
            Point size = this.getSize();
            ImageData data = BuildpathElementImageDescriptor.getImageData(SharedUIResources.INSTANCE.getImageDescriptor("org.eclipse.statet.ecommons.uimisc/image/ovr/deprecated"));
            this.drawImage(data, 0, size.y - data.height);
        }
        ImageData data = BuildpathElementImageDescriptor.getImageData(this.getBaseImage());
        this.drawImage(data, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private void addTopRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = BuildpathElementImageDescriptor.getImageData(desc);
        int x = pos.x - data.width;
        if (x >= 0) {
            this.drawImage(data, x, pos.y);
            pos.x = x;
        }
    }

    private void addBottomRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = BuildpathElementImageDescriptor.getImageData(desc);
        int x = pos.x - data.width;
        int y = pos.y - data.height;
        if (x >= 0 && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x;
        }
    }

    private void addBottomLeftImage(ImageDescriptor desc, Point pos) {
        ImageData data = BuildpathElementImageDescriptor.getImageData(desc);
        int x = pos.x;
        int y = pos.y - data.height;
        if (x + data.width < this.getSize().x && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x + data.width;
        }
    }

    private void drawTopRight() {
    }

    private void drawBottomRight() {
    }

    private void drawBottomLeft() {
        Point pos = new Point(0, this.getSize().y);
        if ((this.flags & 1) != 0) {
            this.addBottomLeftImage(SharedUIResources.INSTANCE.getImageDescriptor("org.eclipse.statet.ecommons.uimisc/image/ovr/info"), pos);
        }
        if ((this.flags & 2) != 0) {
            this.addBottomLeftImage(SharedUIResources.INSTANCE.getImageDescriptor("org.eclipse.statet.ecommons.uimisc/image/ovr/warning"), pos);
        }
        if ((this.flags & 4) != 0) {
            this.addBottomLeftImage(SharedUIResources.INSTANCE.getImageDescriptor("org.eclipse.statet.ecommons.uimisc/image/ovr/warning"), pos);
        }
        if ((this.flags & 0x100) != 0) {
            this.addBottomLeftImage(BuildpathsUIResources.INSTANCE.getImageDescriptor("org.eclipse.statet.ltk.buildpaths.ui/image/ovr/ignore_optional_problems"), pos);
        }
    }

    public int hashCode() {
        return (this.baseImage.hashCode() ^ this.flags) + this.size.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass())) {
            BuildpathElementImageDescriptor other = (BuildpathElementImageDescriptor)((Object)obj);
            return this.baseImage.equals(other.baseImage) && this.flags == other.flags && this.size.equals((Object)other.size);
        }
        return false;
    }
}

