/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.r.core.source;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionUtils;

public class RweaveDocSectionTreePartImpl {
    private final IDocContentSections sections;

    public RweaveDocSectionTreePartImpl(IDocContentSections sections) {
        this.sections = sections;
    }

    public IDocContentSections getSections() {
        return this.sections;
    }

    public ITreePartitionNode getRChunkRegion(IDocument document, int offset) throws BadLocationException {
        return TreePartitionUtils.searchNode((IDocument)document, (String)this.sections.getPartitioning(), (int)offset, (boolean)false, (String)"RweaveChunk.Base");
    }

    public List<ITreePartitionNode> getRChunkRegions(IDocument document, int offset, int length) throws BadLocationException {
        ArrayList<ITreePartitionNode> nodes = new ArrayList<ITreePartitionNode>();
        ITreePartitionNode root = TreePartitionUtils.getRootNode((IDocument)document, (String)this.sections.getPartitioning());
        this.addRChunkRegions(root, offset, offset + length, nodes);
        return nodes;
    }

    private void addRChunkRegions(ITreePartitionNode node, int startOffset, int endOffset, List<ITreePartitionNode> nodes) {
        ITreePartitionNode child;
        int childCount = node.getChildCount();
        int childIdx = 0;
        while (childIdx < childCount) {
            child = node.getChild(childIdx);
            if (child.getEndOffset() > startOffset) break;
            ++childIdx;
        }
        while (childIdx < childCount) {
            child = node.getChild(childIdx);
            if (child.getStartOffset() >= endOffset) break;
            if (child.getType().getPartitionType() == "RweaveChunk.Base") {
                nodes.add(child);
            } else {
                this.addRChunkRegions(child, startOffset, endOffset, nodes);
            }
            ++childIdx;
        }
    }

    public IRegion getRChunkContentRegion(IDocument document, int offset) throws BadLocationException {
        ITreePartitionNode rChunk = this.getRChunkRegion(document, offset);
        if (rChunk == null || rChunk.getLength() <= 2) {
            return null;
        }
        int beginLine = document.getLineOfOffset(rChunk.getStartOffset()) + 1;
        int beginLineOffset = document.getLineOffset(beginLine);
        int endLine = document.getLineOfOffset(rChunk.getEndOffset());
        if (beginLine >= endLine) {
            return null;
        }
        int endLineOffset = document.getLineOffset(endLine);
        if (endLineOffset == rChunk.getEndOffset()) {
            if (beginLine >= --endLine) {
                return null;
            }
            endLineOffset = document.getLineOffset(endLine);
        }
        if (document.getChar(endLineOffset) == '@') {
            return new Region(beginLineOffset, endLineOffset - beginLineOffset);
        }
        return new Region(beginLineOffset, rChunk.getEndOffset() - beginLineOffset);
    }

    public List<ITreePartitionNode> getRChunkCodeRegions(IDocument document, int offset, int length) throws BadLocationException {
        List<ITreePartitionNode> rChunks = this.getRChunkRegions(document, offset, length);
        ArrayList<ITreePartitionNode> nodes = new ArrayList<ITreePartitionNode>(rChunks.size());
        int endOffset = offset + length;
        int i = 0;
        while (i < rChunks.size()) {
            ITreePartitionNode child;
            ITreePartitionNode node = rChunks.get(i);
            int childCount = node.getChildCount();
            int childIdx = 0;
            while (childIdx < childCount) {
                child = node.getChild(childIdx);
                if (child.getEndOffset() > offset) break;
                ++childIdx;
            }
            while (childIdx < childCount) {
                child = node.getChild(childIdx);
                if (child.getStartOffset() >= endOffset) break;
                if (child.getType().getPartitionType() == "R.Default") {
                    nodes.add(child);
                }
                ++childIdx;
            }
            ++i;
        }
        return nodes;
    }

    public ITreePartitionNode getRCodeRegion(IDocument document, int offset) throws BadLocationException {
        return TreePartitionUtils.searchNode((IDocument)document, (String)this.sections.getPartitioning(), (int)offset, (boolean)true, (String)"R.Default");
    }
}

