/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.breakpoints;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.debug.ui.breakpoints.RLineBreakpointDetailEditor;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.r.debug.core.breakpoints.IRMethodBreakpoint;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPropertyListener;

public class RMethodBreakpointDetailEditor
extends RLineBreakpointDetailEditor {
    private IRMethodBreakpoint breakpoint;
    private Button entryControl;
    private Button exitControl;
    private IObservableValue<Boolean> entryValue;
    private IObservableValue<Boolean> exitValue;

    public RMethodBreakpointDetailEditor(boolean mnemonics, boolean autosave, IdentitySet<IPropertyListener> listeners) {
        super(mnemonics, autosave, listeners);
    }

    @Override
    protected void addContent(Composite composite) {
        Composite methodOptions = this.createMethodOptions(composite);
        methodOptions.setLayoutData((Object)new GridData(4, 4, true, false));
        super.addContent(composite);
    }

    protected Composite createMethodOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)3));
        this.entryControl = new Button(composite, 32);
        this.entryControl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.entryControl.setText(this.checkLabel("&Entry"));
        this.exitControl = new Button(composite, 32);
        this.exitControl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.exitControl.setText(this.checkLabel("&Exit"));
        return composite;
    }

    @Override
    protected void addBindings(DataBindingContext dbc, Realm realm) {
        super.addBindings(dbc, realm);
        this.entryValue = new WritableValue(realm, (Object)Boolean.FALSE, Boolean.class);
        this.exitValue = new WritableValue(realm, (Object)Boolean.FALSE, Boolean.class);
        this.enableAutosave(dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.entryControl), this.entryValue));
        this.enableAutosave(dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.exitControl), this.exitValue));
    }

    @Override
    public void doSetInput(Object input) {
        super.doSetInput(input);
        this.breakpoint = null;
        boolean control = false;
        boolean entry = false;
        boolean exit = false;
        if (input instanceof IRMethodBreakpoint) {
            this.breakpoint = (IRMethodBreakpoint)input;
            try {
                entry = this.breakpoint.isEntry();
                exit = this.breakpoint.isExit();
            }
            catch (CoreException e) {
                this.logLoadError(e);
            }
            control = true;
        }
        this.entryControl.setEnabled(control);
        this.exitControl.setEnabled(control);
        this.entryValue.setValue((Object)entry);
        this.exitValue.setValue((Object)exit);
    }

    @Override
    public void doSave() {
        super.doSave();
        if (this.breakpoint != null) {
            try {
                this.breakpoint.setEntry(((Boolean)this.entryValue.getValue()).booleanValue());
                this.breakpoint.setExit(((Boolean)this.exitValue.getValue()).booleanValue());
            }
            catch (CoreException e) {
                this.logSaveError(e);
            }
        }
    }
}

