/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.r.debug.core.IRStackFrame;
import org.eclipse.statet.r.nico.AbstractRDbgController;
import org.eclipse.ui.IWorkbenchPart;

public class RDebugUIUtils {
    public static AbstractRDbgController getRDbgController(ISourceEditor editor) {
        IWorkbenchPart workbenchPart = editor.getWorkbenchPart();
        if (editor == null || workbenchPart == null) {
            return null;
        }
        ToolProcess tool = NicoUITools.getTool((IWorkbenchPart)workbenchPart);
        if (tool.getMainType() != "R" || !(tool.getController() instanceof AbstractRDbgController)) {
            return null;
        }
        AbstractRDbgController controller = (AbstractRDbgController)tool.getController();
        return controller != null && controller.getStatus() == ToolStatus.STARTED_SUSPENDED ? controller : null;
    }

    public static IRStackFrame getFrame(final IWorkbenchPart part, ToolProcess process) {
        final AtomicReference ref = new AtomicReference();
        UIAccess.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Object firstElement;
                IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow());
                ISelection selection = contextService.getActiveContext();
                if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
                    ref.set((IRStackFrame)((IAdaptable)firstElement).getAdapter(IRStackFrame.class));
                }
            }
        });
        return (IRStackFrame)ref.get();
    }
}

