/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class EditableTextList
implements ButtonGroup.IActions<String> {
    private TableViewer fViewer;
    private ViewerUtils.TableComposite fComposite;
    private TableViewerColumn fColumn;
    private ButtonGroup<String> fButtonGroup;

    public Control create(Composite parent, ViewerComparator comparator) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid(2));
        this.fComposite = new ViewerUtils.TableComposite(composite, 68098);
        this.fComposite.setLayoutData(new GridData(4, 4, true, true));
        this.fViewer = this.fComposite.viewer;
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setComparator(comparator);
        this.fComposite.table.setFont(JFaceResources.getTextFont());
        this.fComposite.table.setLinesVisible(true);
        this.fColumn = new TableViewerColumn(this.fViewer, 0);
        this.fColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        this.fComposite.layout.setColumnData((Widget)this.fColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        this.fButtonGroup = new ButtonGroup<String>(composite, this, true);
        this.fButtonGroup.setLayoutData(new GridData(4, 128, false, true));
        this.fButtonGroup.addAddButton(null);
        this.fButtonGroup.addEditButton(null);
        this.fButtonGroup.addDeleteButton(null);
        return composite;
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }

    public TableViewerColumn getColumn() {
        return this.fColumn;
    }

    public void setInput(IObservableCollection input) {
        this.fButtonGroup.connectTo((StructuredViewer)this.fViewer, (IObservableCollection<String>)input, null);
        this.fViewer.setInput((Object)input);
        this.fComposite.layout(false);
    }

    public void applyChange(Object oldWord, Object newWord) {
        if (oldWord.equals(newWord)) {
            return;
        }
        this.fButtonGroup.apply((String)oldWord, (String)newWord);
    }

    public void refresh() {
        this.fViewer.refresh(false);
        this.fComposite.layout(false);
    }

    @Override
    public String edit(int command, String item, Object parent) {
        if (command == 1) {
            return "";
        }
        if (command == 4) {
            return item;
        }
        return null;
    }

    @Override
    public void updateState(IStructuredSelection selection) {
        this.fComposite.layout(false);
    }
}

