/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.docmlet.tex.core.ast.TexAst;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.TexLinkedNamesAssistProposal;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IAssistCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IQuickAssistComputer;

public class TexQuickRenameComputer
implements IQuickAssistComputer {
    public IStatus computeAssistProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (!(context.getAstSelection().getCovering() instanceof TexAstNode)) {
            return Status.OK_STATUS;
        }
        TexAstNode node = (TexAstNode)context.getAstSelection().getCovering();
        if (node.getNodeType() == TexAst.NodeType.LABEL) {
            TexAstNode candidate = node;
            block0: while (candidate != null) {
                ImList attachments = candidate.getAttachments();
                block1: for (Object attachment : attachments) {
                    if (!(attachment instanceof TexNameAccess)) continue;
                    TexNameAccess access = (TexNameAccess)attachment;
                    while (access != null) {
                        if (access.getSegmentName() == null) continue block1;
                        if (access.getNameNode() == node) {
                            this.addAccessAssistProposals(context, access, proposals);
                            break block0;
                        }
                        access = null;
                    }
                }
                candidate = candidate.getTexParent();
            }
        }
        return Status.OK_STATUS;
    }

    protected void addAccessAssistProposals(AssistInvocationContext context, TexNameAccess access, AssistProposalCollector proposals) {
        ImList accessList = access.getAllInUnit();
        proposals.add((IAssistCompletionProposal)new TexLinkedNamesAssistProposal(1, context, access));
    }
}

