/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.jdt.loaders;

import com.google.common.base.Objects;
import java.security.SecureClassLoader;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

@SuppressWarnings("all")
public class DelegatingCompositeBundleClassLoader extends SecureClassLoader {
  private List<Bundle> bundles;
  
  private List<ClassLoader> bundleClassLoaders = null;
  
  public DelegatingCompositeBundleClassLoader(final ClassLoader parent, final List<Bundle> bundles) {
    super(parent);
    Assert.isNotNull(bundles);
    this.bundles = bundles;
  }
  
  public List<ClassLoader> getBundleClassLoaders() {
    List<ClassLoader> _xblockexpression = null;
    {
      boolean _equals = Objects.equal(this.bundleClassLoaders, null);
      if (_equals) {
        final Function1<Bundle, BundleWiring> _function = new Function1<Bundle, BundleWiring>() {
          @Override
          public BundleWiring apply(final Bundle it) {
            return it.<BundleWiring>adapt(BundleWiring.class);
          }
        };
        final Function1<BundleWiring, ClassLoader> _function_1 = new Function1<BundleWiring, ClassLoader>() {
          @Override
          public ClassLoader apply(final BundleWiring it) {
            return it.getClassLoader();
          }
        };
        this.bundleClassLoaders = IterableExtensions.<ClassLoader>toList(IterableExtensions.<BundleWiring, ClassLoader>map(IterableExtensions.<BundleWiring>filterNull(ListExtensions.<Bundle, BundleWiring>map(this.bundles, _function)), _function_1));
      }
      _xblockexpression = this.bundleClassLoaders;
    }
    return _xblockexpression;
  }
  
  @Override
  protected Class<?> findClass(final String name) throws ClassNotFoundException {
    List<ClassLoader> _bundleClassLoaders = this.getBundleClassLoaders();
    for (final ClassLoader bundleClassLoader : _bundleClassLoaders) {
      try {
        final Class<?> clazz = bundleClassLoader.loadClass(name);
        return clazz;
      } catch (final Throwable _t) {
        if (_t instanceof Throwable) {
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    throw new ClassNotFoundException(name);
  }
  
  @Override
  public String toString() {
    String _name = this.getClass().getName();
    String _plus = (_name + " [bundles=");
    String _string = Arrays.toString(this.bundles.toArray());
    String _plus_1 = (_plus + _string);
    return (_plus_1 + "]");
  }
}
