/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.layout;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ArrangeConstraint;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramDescriptionProvider;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.model.business.internal.query.DDiagramElementContainerExperimentalQuery;

public final class PinHelper {
    public static final Collection<ArrangeConstraint> PINNED_CONSTRAINTS = new ArrayList<ArrangeConstraint>();
    private static final NotificationFilter PIN_FILTER;

    static {
        PINNED_CONSTRAINTS.add(ArrangeConstraint.KEEP_LOCATION);
        PINNED_CONSTRAINTS.add(ArrangeConstraint.KEEP_SIZE);
        PINNED_CONSTRAINTS.add(ArrangeConstraint.KEEP_RATIO);
        PIN_FILTER = NotificationFilter.createFeatureFilter(AbstractDNode.class, (int)12).or(NotificationFilter.createFeatureFilter(DEdge.class, (int)23));
    }

    public boolean isPinned(DDiagramElement dDiagramElement) {
        boolean isPinned = false;
        List<ArrangeConstraint> constraints = this.getArrangeConstraints((EObject)dDiagramElement);
        isPinned = constraints != null && constraints.containsAll(PINNED_CONSTRAINTS);
        return isPinned;
    }

    public ResourceSetListener createPinListener(DDiagramElement target, final Runnable onChange) {
        return new ResourceSetListenerImpl(NotificationFilter.createNotifierFilter((Object)target).and(PIN_FILTER)){

            public boolean isPostcommitOnly() {
                return true;
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                onChange.run();
            }
        };
    }

    public boolean markAsPinned(DDiagramElement dDiagramElement) {
        boolean pinned = false;
        List<ArrangeConstraint> constraints = this.getArrangeConstraints((EObject)dDiagramElement);
        if (constraints != null) {
            constraints.addAll(PINNED_CONSTRAINTS);
            pinned = true;
        }
        return pinned;
    }

    public boolean markAsUnpinned(DDiagramElement dDiagramElement) {
        boolean pinned = false;
        List<ArrangeConstraint> constraints = this.getArrangeConstraints((EObject)dDiagramElement);
        if (constraints != null) {
            constraints.removeAll(PINNED_CONSTRAINTS);
            pinned = true;
        }
        return pinned;
    }

    private List<ArrangeConstraint> getArrangeConstraints(EObject diagramElement) {
        EList constraints = null;
        if (diagramElement instanceof AbstractDNode) {
            AbstractDNode node = (AbstractDNode)diagramElement;
            constraints = node.getArrangeConstraints();
        } else if (diagramElement instanceof DEdge) {
            DEdge edge = (DEdge)diagramElement;
            constraints = edge.getArrangeConstraints();
        }
        return constraints;
    }

    public static boolean allowsPinUnpin(DDiagramElement element) {
        return element != null && PinHelper.allowsPinUnpin(element.getParentDiagram()).apply((Object)element);
    }

    private static Predicate<DDiagramElement> allowsPinUnpin(DDiagram diagram) {
        Object result = new Predicate<DDiagramElement>(){

            public boolean apply(DDiagramElement dde) {
                if (dde instanceof DDiagramElementContainer) {
                    DDiagramElementContainerExperimentalQuery query = new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)dde);
                    return !query.isRegion();
                }
                return true;
            }
        };
        if (diagram == null || diagram.getDescription() == null) {
            return Predicates.alwaysFalse();
        }
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(diagram.getDescription().eClass().getEPackage())) continue;
            final IDiagramDescriptionProvider provider = diagramTypeDescriptor.getDiagramDescriptionProvider();
            result = new Predicate<DDiagramElement>(){

                public boolean apply(DDiagramElement input) {
                    return provider.allowsPinUnpin(input);
                }
            };
            break;
        }
        return result;
    }
}

