/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing.internal.algorithm;

import org.eclipse.elk.alg.common.nodespacing.cellsystem.AtomicCell;
import org.eclipse.elk.alg.common.nodespacing.internal.NodeContext;
import org.eclipse.elk.alg.common.nodespacing.internal.PortContext;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortAlignment;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public final class PortPlacementCalculator {
    public static final IProperty<Double> PORT_RATIO_OR_POSITION = new Property("portRatioOrPosition", (Object)0.0);

    private PortPlacementCalculator() {
    }

    public static void placeHorizontalPorts(NodeContext nodeContext) {
        switch (nodeContext.portConstraints) {
            case FIXED_POS: {
                PortPlacementCalculator.placeHorizontalFixedPosPorts(nodeContext, PortSide.NORTH);
                PortPlacementCalculator.placeHorizontalFixedPosPorts(nodeContext, PortSide.SOUTH);
                break;
            }
            case FIXED_RATIO: {
                PortPlacementCalculator.placeHorizontalFixedRatioPorts(nodeContext, PortSide.NORTH);
                PortPlacementCalculator.placeHorizontalFixedRatioPorts(nodeContext, PortSide.SOUTH);
                break;
            }
            default: {
                PortPlacementCalculator.placeHorizontalFreePorts(nodeContext, PortSide.NORTH);
                PortPlacementCalculator.placeHorizontalFreePorts(nodeContext, PortSide.SOUTH);
            }
        }
    }

    private static void placeHorizontalFixedPosPorts(NodeContext nodeContext, PortSide portSide) {
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            portContext.portPosition.y = PortPlacementCalculator.calculateHorizontalPortYCoordinate(portContext);
        }
    }

    private static void placeHorizontalFixedRatioPorts(NodeContext nodeContext, PortSide portSide) {
        double nodeWidth = nodeContext.nodeSize.x;
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            portContext.portPosition.x = nodeWidth * (Double)portContext.port.getProperty(PORT_RATIO_OR_POSITION);
            portContext.portPosition.y = PortPlacementCalculator.calculateHorizontalPortYCoordinate(portContext);
        }
    }

    private static void placeHorizontalFreePorts(NodeContext nodeContext, PortSide portSide) {
        if (nodeContext.portContexts.get((Object)portSide).isEmpty()) {
            return;
        }
        AtomicCell insidePortLabelCell = nodeContext.insidePortLabelCells.get(portSide);
        ElkRectangle insidePortLabelCellRectangle = insidePortLabelCell.getCellRectangle();
        ElkPadding insidePortLabelCellPadding = insidePortLabelCell.getPadding();
        PortAlignment portAlignment = nodeContext.getPortAlignment(portSide);
        double availableSpace = insidePortLabelCellRectangle.width - insidePortLabelCellPadding.left - insidePortLabelCellPadding.right;
        double calculatedPortPlacementWidth = insidePortLabelCell.getMinimumContentAreaSize().x;
        double currentXPos = insidePortLabelCellRectangle.x + insidePortLabelCellPadding.left;
        double spaceBetweenPorts = nodeContext.portPortSpacing;
        if ((portAlignment == PortAlignment.DISTRIBUTED || portAlignment == PortAlignment.JUSTIFIED) && nodeContext.portContexts.get((Object)portSide).size() == 1) {
            calculatedPortPlacementWidth = PortPlacementCalculator.modifiedPortPlacementSize(nodeContext, portAlignment, calculatedPortPlacementWidth);
            portAlignment = PortAlignment.CENTER;
        }
        if (availableSpace < calculatedPortPlacementWidth && !nodeContext.sizeOptions.contains(SizeOptions.PORTS_OVERHANG)) {
            if (portAlignment == PortAlignment.DISTRIBUTED) {
                currentXPos += (spaceBetweenPorts += (availableSpace - calculatedPortPlacementWidth) / (double)(nodeContext.portContexts.get((Object)portSide).size() + 1));
            } else {
                spaceBetweenPorts += (availableSpace - calculatedPortPlacementWidth) / (double)(nodeContext.portContexts.get((Object)portSide).size() - 1);
            }
        } else {
            if (availableSpace < calculatedPortPlacementWidth) {
                calculatedPortPlacementWidth = PortPlacementCalculator.modifiedPortPlacementSize(nodeContext, portAlignment, calculatedPortPlacementWidth);
                portAlignment = PortAlignment.CENTER;
            }
            switch (portAlignment) {
                case BEGIN: {
                    break;
                }
                case CENTER: {
                    currentXPos += (availableSpace - calculatedPortPlacementWidth) / 2.0;
                    break;
                }
                case END: {
                    currentXPos += availableSpace - calculatedPortPlacementWidth;
                    break;
                }
                case DISTRIBUTED: {
                    double additionalSpaceBetweenPorts = (availableSpace - calculatedPortPlacementWidth) / (double)(nodeContext.portContexts.get((Object)portSide).size() + 1);
                    currentXPos += (spaceBetweenPorts += Math.max(0.0, additionalSpaceBetweenPorts));
                    break;
                }
                case JUSTIFIED: {
                    double additionalSpaceBetweenPorts = (availableSpace - calculatedPortPlacementWidth) / (double)(nodeContext.portContexts.get((Object)portSide).size() - 1);
                    spaceBetweenPorts += Math.max(0.0, additionalSpaceBetweenPorts);
                }
            }
        }
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            portContext.portPosition.x = currentXPos + portContext.portMargin.left;
            portContext.portPosition.y = PortPlacementCalculator.calculateHorizontalPortYCoordinate(portContext);
            currentXPos += portContext.portMargin.left + portContext.port.getSize().x + portContext.portMargin.right + spaceBetweenPorts;
        }
    }

    private static double calculateHorizontalPortYCoordinate(PortContext portContext) {
        GraphAdapters.PortAdapter<?> port = portContext.port;
        if (port.hasProperty(CoreOptions.PORT_BORDER_OFFSET)) {
            return port.getSide() == PortSide.NORTH ? -port.getSize().y - (Double)port.getProperty(CoreOptions.PORT_BORDER_OFFSET) : (Double)port.getProperty(CoreOptions.PORT_BORDER_OFFSET);
        }
        return port.getSide() == PortSide.NORTH ? -port.getSize().y : 0.0;
    }

    public static void placeVerticalPorts(NodeContext nodeContext) {
        switch (nodeContext.portConstraints) {
            case FIXED_POS: {
                PortPlacementCalculator.placeVerticalFixedPosPorts(nodeContext, PortSide.EAST);
                PortPlacementCalculator.placeVerticalFixedPosPorts(nodeContext, PortSide.WEST);
                break;
            }
            case FIXED_RATIO: {
                PortPlacementCalculator.placeVerticalFixedRatioPorts(nodeContext, PortSide.EAST);
                PortPlacementCalculator.placeVerticalFixedRatioPorts(nodeContext, PortSide.WEST);
                break;
            }
            default: {
                PortPlacementCalculator.placeVerticalFreePorts(nodeContext, PortSide.EAST);
                PortPlacementCalculator.placeVerticalFreePorts(nodeContext, PortSide.WEST);
            }
        }
    }

    private static void placeVerticalFixedPosPorts(NodeContext nodeContext, PortSide portSide) {
        double nodeWidth = nodeContext.nodeSize.x;
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            portContext.portPosition.x = PortPlacementCalculator.calculateVerticalPortXCoordinate(portContext, nodeWidth);
        }
    }

    private static void placeVerticalFixedRatioPorts(NodeContext nodeContext, PortSide portSide) {
        KVector nodeSize = nodeContext.nodeSize;
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            portContext.portPosition.x = PortPlacementCalculator.calculateVerticalPortXCoordinate(portContext, nodeSize.x);
            portContext.portPosition.y = nodeSize.y * (Double)portContext.port.getProperty(PORT_RATIO_OR_POSITION);
        }
    }

    private static void placeVerticalFreePorts(NodeContext nodeContext, PortSide portSide) {
        if (nodeContext.portContexts.get((Object)portSide).isEmpty()) {
            return;
        }
        AtomicCell insidePortLabelCell = nodeContext.insidePortLabelCells.get(portSide);
        ElkRectangle insidePortLabelCellRectangle = insidePortLabelCell.getCellRectangle();
        ElkPadding insidePortLabelCellPadding = insidePortLabelCell.getPadding();
        PortAlignment portAlignment = nodeContext.getPortAlignment(portSide);
        double availableSpace = insidePortLabelCellRectangle.height - insidePortLabelCellPadding.top - insidePortLabelCellPadding.bottom;
        double calculatedPortPlacementHeight = insidePortLabelCell.getMinimumContentAreaSize().y;
        double currentYPos = insidePortLabelCellRectangle.y + insidePortLabelCellPadding.top;
        double spaceBetweenPorts = nodeContext.portPortSpacing;
        double nodeWidth = nodeContext.nodeSize.x;
        if ((portAlignment == PortAlignment.DISTRIBUTED || portAlignment == PortAlignment.JUSTIFIED) && nodeContext.portContexts.get((Object)portSide).size() == 1) {
            calculatedPortPlacementHeight = PortPlacementCalculator.modifiedPortPlacementSize(nodeContext, portAlignment, calculatedPortPlacementHeight);
            portAlignment = PortAlignment.CENTER;
        }
        if (availableSpace < calculatedPortPlacementHeight && !nodeContext.sizeOptions.contains(SizeOptions.PORTS_OVERHANG)) {
            if (portAlignment == PortAlignment.DISTRIBUTED) {
                currentYPos += (spaceBetweenPorts += (availableSpace - calculatedPortPlacementHeight) / (double)(nodeContext.portContexts.get((Object)portSide).size() + 1));
            } else {
                spaceBetweenPorts += (availableSpace - calculatedPortPlacementHeight) / (double)(nodeContext.portContexts.get((Object)portSide).size() - 1);
            }
        } else {
            if (availableSpace < calculatedPortPlacementHeight) {
                calculatedPortPlacementHeight = PortPlacementCalculator.modifiedPortPlacementSize(nodeContext, portAlignment, calculatedPortPlacementHeight);
                portAlignment = PortAlignment.CENTER;
            }
            switch (portAlignment) {
                case BEGIN: {
                    break;
                }
                case CENTER: {
                    currentYPos += (availableSpace - calculatedPortPlacementHeight) / 2.0;
                    break;
                }
                case END: {
                    currentYPos += availableSpace - calculatedPortPlacementHeight;
                    break;
                }
                case DISTRIBUTED: {
                    double additionalSpaceBetweenPorts = (availableSpace - calculatedPortPlacementHeight) / (double)(nodeContext.portContexts.get((Object)portSide).size() + 1);
                    currentYPos += (spaceBetweenPorts += Math.max(0.0, additionalSpaceBetweenPorts));
                    break;
                }
                case JUSTIFIED: {
                    double additionalSpaceBetweenPorts = (availableSpace - calculatedPortPlacementHeight) / (double)(nodeContext.portContexts.get((Object)portSide).size() - 1);
                    spaceBetweenPorts += Math.max(0.0, additionalSpaceBetweenPorts);
                }
            }
        }
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            portContext.portPosition.x = PortPlacementCalculator.calculateVerticalPortXCoordinate(portContext, nodeWidth);
            portContext.portPosition.y = currentYPos + portContext.portMargin.top;
            currentYPos += portContext.portMargin.top + portContext.port.getSize().y + portContext.portMargin.bottom + spaceBetweenPorts;
        }
    }

    private static double calculateVerticalPortXCoordinate(PortContext portContext, double nodeWidth) {
        GraphAdapters.PortAdapter<?> port = portContext.port;
        if (port.hasProperty(CoreOptions.PORT_BORDER_OFFSET)) {
            return port.getSide() == PortSide.WEST ? -port.getSize().x - (Double)port.getProperty(CoreOptions.PORT_BORDER_OFFSET) : nodeWidth + (Double)port.getProperty(CoreOptions.PORT_BORDER_OFFSET);
        }
        return port.getSide() == PortSide.WEST ? -port.getSize().x : nodeWidth;
    }

    private static double modifiedPortPlacementSize(NodeContext nodeContext, PortAlignment oldPortAlignment, double currentPortPlacementSize) {
        if (oldPortAlignment == PortAlignment.DISTRIBUTED) {
            return currentPortPlacementSize - 2.0 * nodeContext.portPortSpacing;
        }
        return currentPortPlacementSize;
    }
}

