/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.rectpacking.util.Block;

public class BlockStack {
    private List<Block> blocks = new ArrayList<Block>();
    private double x;
    private double y;
    private double width;
    private double height;
    private double nodeNodeSpacing;

    public BlockStack(double x, double y, double nodeNodeSpacing) {
        this.x = x;
        this.y = y;
        this.nodeNodeSpacing = nodeNodeSpacing;
    }

    public void addBlock(Block block) {
        block.setStack(this);
        this.width = Math.max(this.width, block.getWidth());
        this.height += block.getHeight() + (this.blocks.isEmpty() ? 0.0 : this.nodeNodeSpacing);
        this.blocks.add(block);
    }

    public void updateDimension() {
        double height = 0.0;
        double width = 0.0;
        int index = 0;
        for (Block block : this.blocks) {
            width = Math.max(width, block.getWidth());
            height += block.getHeight() + (index > 0 ? this.nodeNodeSpacing : 0.0);
            ++index;
        }
        this.height = height;
        this.width = width;
    }

    public void setLocation(double x, double y) {
        double xDiff = x - this.x;
        double yDiff = y - this.y;
        for (Block block : this.blocks) {
            block.setLocation(block.getX() + xDiff, block.getY() + yDiff);
        }
        this.x = x;
        this.y = y;
    }

    public double getWidthForFixedHeight(double height) {
        if (this.blocks.size() == 1) {
            return this.blocks.get(0).getWidthForTargetHeight(height);
        }
        double minWidth = this.getMinimumWidth();
        double totalHeight = 0.0;
        double upperBound = this.width;
        double lowerBound = minWidth;
        double viableWidth = this.width;
        double newWidth = (upperBound - lowerBound) / 2.0 + lowerBound;
        while (lowerBound + 1.0 < upperBound) {
            totalHeight = 0.0;
            for (Block block : this.blocks) {
                totalHeight += block.getHeightForTargetWidth(newWidth);
            }
            if (totalHeight < height) {
                viableWidth = newWidth;
                upperBound = newWidth;
            } else {
                lowerBound = newWidth;
            }
            newWidth = (upperBound - lowerBound) / 2.0 + lowerBound;
        }
        return viableWidth;
    }

    public void placeRectsIn(double targetWidth) {
        double currentY = this.getY();
        double currentHeight = 0.0;
        double currentWidth = 0.0;
        for (Block block : this.blocks) {
            block.setLocation(this.x, currentY);
            block.placeRectsIn(targetWidth);
            currentWidth = Math.max(currentWidth, block.getWidth());
            currentHeight = currentY += block.getHeight() + this.nodeNodeSpacing;
        }
        this.width = currentWidth;
        this.height = currentHeight;
    }

    public void expand(double additionalWidth, double additionalHeight) {
        int index = 0;
        double additionalHeightPerBlock = additionalHeight / (double)this.blocks.size();
        for (Block block : this.blocks) {
            block.setLocation(block.getX(), block.getY() + (double)index * additionalHeightPerBlock);
            block.expand(this.getWidth() - block.getWidth() + additionalWidth, additionalHeightPerBlock);
            ++index;
        }
    }

    private double getMinimumWidth() {
        double minWidth = 0.0;
        for (Block block : this.blocks) {
            minWidth = Math.max(minWidth, block.getMinWidth());
        }
        return minWidth;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }
}

