/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.sync;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.util.CartesianProduct;
import org.eclipse.sirius.common.tools.api.util.EObjectCouple;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.EdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.sync.AbstractSynchronizerHelper;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DEdgeCandidate;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.collect.MultipleCollection;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class DEdgeSynchronizerHelper
extends AbstractSynchronizerHelper {
    public DEdgeSynchronizerHelper(DDiagramSynchronizer sync, DSemanticDiagram diagram, ModelAccessor accessor) {
        super(sync, diagram, accessor);
    }

    public Collection<DEdgeCandidate> computeNowEdgeCandidates(EdgeMapping mapping, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.GET_EDGE_CANDIDATES_KEY);
        Collection<DEdgeCandidate> edgeCandidates = null;
        if (!mapping.isUseDomainElement()) {
            Predicate isValidTarget = input -> {
                if (input instanceof DSemanticDecorator) {
                    EObject target = ((DSemanticDecorator)input).getTarget();
                    return target != null && target.eResource() != null;
                }
                return true;
            };
            Iterable sourceViews = Iterables.filter(this.computeTargetElements(this.diagram, (List<DiagramElementMapping>)mapping.getSourceMapping(), mappingsToEdgeTargets), (Predicate)isValidTarget);
            HashMap<EObject, Collection<EdgeTarget>> targetViewsSemantics = new HashMap<EObject, Collection<EdgeTarget>>();
            Iterable targetViews = Iterables.filter(this.computeTargetElements(this.diagram, (List<DiagramElementMapping>)mapping.getTargetMapping(), mappingsToEdgeTargets, targetViewsSemantics), (Predicate)isValidTarget);
            edgeCandidates = this.computeEdgeCandidatesWithoutDomain(sourceViews, targetViews, targetViewsSemantics, mapping);
        } else {
            HashMap<EObject, Collection<EdgeTarget>> sourceViewsSemantics = new HashMap<EObject, Collection<EdgeTarget>>();
            HashMap<EObject, Collection<EdgeTarget>> targetViewsSemantics = new HashMap<EObject, Collection<EdgeTarget>>();
            this.computeTargetElements(this.diagram, (List<DiagramElementMapping>)mapping.getSourceMapping(), mappingsToEdgeTargets, sourceViewsSemantics);
            this.computeTargetElements(this.diagram, (List<DiagramElementMapping>)mapping.getTargetMapping(), mappingsToEdgeTargets, targetViewsSemantics);
            edgeCandidates = this.computeEdgeCandidatesWithDomain(sourceViewsSemantics, targetViewsSemantics, mapping);
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.GET_EDGE_CANDIDATES_KEY);
        return edgeCandidates;
    }

    private Collection<DEdgeCandidate> computeEdgeCandidatesWithDomain(Map<EObject, Collection<EdgeTarget>> sourceViewsSemantics, Map<EObject, Collection<EdgeTarget>> targetViewsSemantics, EdgeMapping mapping) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.GET_EDGE_CANDIDATES_KEY);
        ArrayList<DEdgeCandidate> result = new ArrayList<DEdgeCandidate>();
        final LinkedHashSet targetCandidates = Sets.newLinkedHashSet(this.getSemanticCandidates((DragAndDropTarget)this.diagram, (DiagramElementMapping)mapping));
        if (this.tool || new DiagramElementMappingQuery((DiagramElementMapping)mapping).isSynchronizedAndCreateElement((DDiagram)this.diagram)) {
            for (EObject target : targetCandidates) {
                this.handleCandidatesFromSemanticTargets(result, target, mapping, sourceViewsSemantics, targetViewsSemantics);
            }
        } else {
            this.sync.forceRetrieve();
            Set<DDiagramElement> previousDiagramElements = this.sync.getPreviousDiagramElements((DragAndDropTarget)this.diagram, (DiagramElementMapping)mapping);
            this.sync.resetforceRetrieve();
            Predicate<DDiagramElement> stillCandidate = new Predicate<DDiagramElement>(){

                public boolean apply(DDiagramElement input) {
                    return input != null && input.getTarget() != null && targetCandidates.contains(input.getTarget());
                }
            };
            this.handlePreviousCandidates(result, Iterables.filter(previousDiagramElements, (Predicate)stillCandidate), mapping, sourceViewsSemantics, targetViewsSemantics);
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.GET_EDGE_CANDIDATES_KEY);
        return result;
    }

    private void handlePreviousCandidates(Collection<DEdgeCandidate> result, Iterable<DDiagramElement> previousDiagramElements, final EdgeMapping mapping, final Map<EObject, Collection<EdgeTarget>> sourceViewsSemantics, final Map<EObject, Collection<EdgeTarget>> targetViewsSemantics) {
        final EdgeMappingQuery edgeMappingQuery = new EdgeMappingQuery(mapping);
        Predicate<DEdge> stillCandidate = new Predicate<DEdge>(){

            public boolean apply(DEdge input) {
                boolean stillCandidate = DEdgeSynchronizerHelper.this.validateNode(input.getSourceNode(), sourceViewsSemantics);
                boolean bl = stillCandidate = stillCandidate && DEdgeSynchronizerHelper.this.validateNode(input.getTargetNode(), targetViewsSemantics);
                if (stillCandidate) {
                    EObject target = input.getTarget();
                    if (mapping.isUseDomainElement()) {
                        Collection<EObject> edgeSourceSemantics = edgeMappingQuery.evaluateSourceFinderExpression(DEdgeSynchronizerHelper.this.diagram, DEdgeSynchronizerHelper.this.interpreter, target);
                        stillCandidate = edgeSourceSemantics.contains(((DSemanticDecorator)input.getSourceNode()).getTarget());
                    }
                    if (stillCandidate) {
                        Collection<EObject> edgeTargetSemantics = edgeMappingQuery.evaluateTargetFinderExpression(DEdgeSynchronizerHelper.this.diagram, DEdgeSynchronizerHelper.this.interpreter, target);
                        stillCandidate = edgeTargetSemantics.contains(((DSemanticDecorator)input.getTargetNode()).getTarget());
                    }
                }
                return stillCandidate;
            }
        };
        for (DEdge prevDEdge : Iterables.filter((Iterable)Iterables.filter(previousDiagramElements, DEdge.class), (Predicate)stillCandidate)) {
            EdgeTarget sourceView = prevDEdge.getSourceNode();
            EdgeTarget targetView = prevDEdge.getTargetNode();
            EObject target = prevDEdge.getTarget();
            if (!edgeMappingQuery.evaluatePrecondition(this.diagram, (DragAndDropTarget)this.diagram, this.interpreter, target, (DSemanticDecorator)sourceView, (DSemanticDecorator)targetView)) continue;
            result.add(new DEdgeCandidate(mapping, target, sourceView, targetView, this.sync.getFactory()));
        }
    }

    private boolean validateNode(EdgeTarget edgeTarget, Map<EObject, Collection<EdgeTarget>> viewsSemantics) {
        boolean valid;
        EObject semanticEdgeTarget = edgeTarget == null ? null : ((DSemanticDecorator)edgeTarget).getTarget();
        boolean bl = valid = semanticEdgeTarget != null;
        if (viewsSemantics != null) {
            valid = valid && viewsSemantics.containsKey(semanticEdgeTarget) && viewsSemantics.get(semanticEdgeTarget).contains(edgeTarget);
        }
        return valid;
    }

    private void handleCandidatesFromSemanticTargets(Collection<DEdgeCandidate> result, EObject target, EdgeMapping mapping, Map<EObject, Collection<EdgeTarget>> sourceViewsSemantics, Map<EObject, Collection<EdgeTarget>> targetViewsSemantics) {
        EdgeMappingQuery edgeMappingQuery = new EdgeMappingQuery(mapping);
        Collection<EObject> edgeSourceSemantics = edgeMappingQuery.evaluateSourceFinderExpression(this.diagram, this.interpreter, target);
        Collection<EObject> edgeTargetSemantics = edgeMappingQuery.evaluateTargetFinderExpression(this.diagram, this.interpreter, target);
        for (EObjectCouple couple : new CartesianProduct(edgeSourceSemantics, edgeTargetSemantics, this.sync.getFactory())) {
            Collection<EdgeTarget> targetViews;
            Collection<EdgeTarget> sourceViews = sourceViewsSemantics.get(couple.getObj1());
            if (sourceViews == null || (targetViews = targetViewsSemantics.get(couple.getObj2())) == null) continue;
            for (EObjectCouple viewsCouple : new CartesianProduct(sourceViews, targetViews, this.sync.getFactory())) {
                EdgeTarget targetView;
                EdgeTarget sourceView = (EdgeTarget)viewsCouple.getObj1();
                if (!edgeMappingQuery.evaluatePrecondition(this.diagram, (DragAndDropTarget)this.diagram, this.interpreter, target, (DSemanticDecorator)sourceView, (DSemanticDecorator)(targetView = (EdgeTarget)viewsCouple.getObj2()))) continue;
                result.add(new DEdgeCandidate(mapping, target, sourceView, targetView, this.sync.getFactory()));
            }
        }
    }

    private Collection<DEdgeCandidate> computeEdgeCandidatesWithoutDomain(Iterable<EdgeTarget> sourceViews, Iterable<EdgeTarget> targetViews, Map<EObject, Collection<EdgeTarget>> targetViewsSemantics, EdgeMapping mapping) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.GET_EDGE_CANDIDATES_KEY);
        ArrayList<DEdgeCandidate> result = new ArrayList<DEdgeCandidate>();
        if (this.tool || new DiagramElementMappingQuery((DiagramElementMapping)mapping).isSynchronizedAndCreateElement((DDiagram)this.diagram)) {
            for (EdgeTarget sourceView : sourceViews) {
                this.handleCandidatesFromSourceView(result, sourceView, mapping, targetViews, targetViewsSemantics);
            }
        } else {
            Set<DDiagramElement> previousDiagramElements = this.sync.getPreviousDiagramElements((DragAndDropTarget)this.diagram, (DiagramElementMapping)mapping);
            this.handlePreviousCandidates(result, previousDiagramElements, mapping, null, targetViewsSemantics);
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.GET_EDGE_CANDIDATES_KEY);
        return result;
    }

    private void handleCandidatesFromSourceView(Collection<DEdgeCandidate> result, EdgeTarget sourceView, EdgeMapping mapping, Iterable<EdgeTarget> targetViews, Map<EObject, Collection<EdgeTarget>> targetViewsSemantics) {
        EObject sourceSemantic = ((DSemanticDecorator)sourceView).getTarget();
        Collection potentialTargetSemantics = new ArrayList();
        this.interpreter.setVariable("diagram", (Object)this.diagram);
        this.interpreter.setVariable("viewpoint", (Object)this.diagram);
        this.interpreter.setVariable("viewPoint", (Object)this.diagram);
        if (!StringUtil.isEmpty((String)mapping.getTargetExpression())) {
            try {
                sourceSemantic = this.interpreter.evaluateEObject(sourceSemantic, mapping.getTargetExpression());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)mapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getEdgeMapping_TargetExpression(), (Throwable)e);
            }
        }
        try {
            potentialTargetSemantics = this.interpreter.evaluateCollection(sourceSemantic, mapping.getTargetFinderExpression());
        }
        catch (EvaluationException evaluationException) {}
        this.interpreter.unSetVariable("diagram");
        this.interpreter.unSetVariable("viewpoint");
        this.interpreter.unSetVariable("viewPoint");
        EdgeMappingQuery edgeMappingQuery = new EdgeMappingQuery(mapping);
        HashSet<EObject> minimize = new HashSet<EObject>();
        for (EObject potentialTargetSemantic : potentialTargetSemantics) {
            Collection<EdgeTarget> targetEdgeTarget = targetViewsSemantics.get(potentialTargetSemantic);
            if (targetEdgeTarget == null || minimize.contains(potentialTargetSemantic)) continue;
            minimize.add(potentialTargetSemantic);
            for (EdgeTarget targetView : targetEdgeTarget) {
                if (!edgeMappingQuery.evaluatePrecondition(this.diagram, (DragAndDropTarget)this.diagram, this.interpreter, sourceSemantic, (DSemanticDecorator)sourceView, (DSemanticDecorator)targetView)) continue;
                result.add(new DEdgeCandidate(mapping, sourceSemantic, sourceView, targetView, this.sync.getFactory()));
            }
        }
    }

    private Collection<EdgeTarget> computeTargetElements(DSemanticDiagram diagram2, List<DiagramElementMapping> sourceMappings, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets) {
        return this.computeTargetElements(diagram2, sourceMappings, mappingsToEdgeTargets, null);
    }

    private Collection<EdgeTarget> computeTargetElements(DSemanticDiagram diagram2, List<DiagramElementMapping> targetMappings, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, Map<EObject, Collection<EdgeTarget>> viewsSemantics) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.COMPUTE_TARGET_ELEMENTS_KEY);
        MultipleCollection result = new MultipleCollection();
        for (DiagramElementMapping mapping : targetMappings) {
            Collection<EdgeTarget> elements = this.getElementsFromMapping(mappingsToEdgeTargets, mapping);
            if (elements == null) continue;
            if (viewsSemantics == null) {
                result.addAll(elements);
                continue;
            }
            for (EdgeTarget edgeTarget : Iterables.filter(elements, EdgeTarget.class)) {
                result.add(edgeTarget);
                if (!(edgeTarget instanceof DSemanticDecorator)) continue;
                EObject semanticElement = ((DSemanticDecorator)edgeTarget).getTarget();
                Collection<EdgeTarget> existingTargets = viewsSemantics.get(semanticElement);
                if (existingTargets != null) {
                    existingTargets.add(edgeTarget);
                    continue;
                }
                existingTargets = new ArrayList<EdgeTarget>();
                existingTargets.add(edgeTarget);
                viewsSemantics.put(semanticElement, existingTargets);
            }
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.COMPUTE_TARGET_ELEMENTS_KEY);
        return result;
    }

    private Collection<EdgeTarget> getElementsFromMapping(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, DiagramElementMapping mapping) {
        Iterator<Map.Entry<DiagramElementMapping, Collection<EdgeTarget>>> iterator = mappingsToEdgeTargets.entrySet().iterator();
        BasicEList elements = new BasicEList();
        Collection<EdgeTarget> tempList = mappingsToEdgeTargets.get(mapping);
        if (tempList != null) {
            elements.addAll(tempList);
        }
        while (iterator.hasNext()) {
            boolean isSubType;
            Map.Entry<DiagramElementMapping, Collection<EdgeTarget>> entry = iterator.next();
            if (entry.getKey().equals(mapping) || !(isSubType = new DiagramElementMappingQuery(entry.getKey()).isSubTypeOf(mapping)) || entry.getValue() == null) continue;
            elements.addAll(entry.getValue());
        }
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)elements, EdgeTarget.class));
    }
}

