/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.util.StringUtil;

public final class EclipseUtil {
    private EclipseUtil() {
    }

    private static IExtension[] getExtensions(String extensionId) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(extensionId);
        return ep.getExtensions();
    }

    public static <T> List<T> getExtensionPlugins(Class<T> clazz, String extensionId, String attribute) {
        return EclipseUtil.getExtensionPlugins(clazz, extensionId, attribute, null, (Predicate<String>)Predicates.alwaysTrue());
    }

    public static <T> List<T> getExtensionPlugins(Class<T> clazz, String extensionId, String executableAttribute, String attributeName, String exceptedAttributeValue) {
        return EclipseUtil.getExtensionPlugins(clazz, extensionId, executableAttribute, attributeName, (Predicate<String>)Predicates.equalTo((Object)exceptedAttributeValue));
    }

    private static <T> List<T> getExtensionPlugins(Class<T> clazz, String extensionId, String executableAttribute, String attributeName, Predicate<String> attributeValuePredicate) {
        ArrayList<T> contributors = new ArrayList<T>();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = EclipseUtil.getExtensions(extensionId);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] ce;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ce = ext.getConfigurationElements();
                int n3 = ce.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (EclipseUtil.checkAttribute(element, attributeName, attributeValuePredicate)) {
                        try {
                            Object obj = element.createExecutableExtension(executableAttribute);
                            if (clazz.isInstance(obj)) {
                                contributors.add(clazz.cast(obj));
                            }
                        }
                        catch (CoreException e) {
                            DslCommonPlugin.getDefault().error(MessageFormat.format(Messages.EclipseUtil_extensionLoadError, ext.getLabel()), e);
                            DslCommonPlugin.getDefault().getLog().log(e.getStatus());
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return contributors;
    }

    public static <T> Map<String, Collection<T>> getExtensionPluginsByKey(Class<T> clazz, String extensionId, String executableAttribute, String keyAttributeName) {
        LinkedHashMap<String, Collection<T>> contributors = new LinkedHashMap<String, Collection<T>>();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = EclipseUtil.getExtensions(extensionId);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] ce;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ce = ext.getConfigurationElements();
                int n3 = ce.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (EclipseUtil.checkAttribute(element, keyAttributeName, (Predicate<String>)Predicates.alwaysTrue())) {
                        try {
                            Object obj = element.createExecutableExtension(executableAttribute);
                            if (clazz.isInstance(obj)) {
                                ArrayList<T> val;
                                String key = null;
                                if (keyAttributeName != null) {
                                    key = element.getAttribute(keyAttributeName);
                                }
                                if ((val = (ArrayList<T>)contributors.get(key = (String)Optional.ofNullable(key).orElse(""))) == null) {
                                    val = new ArrayList<T>();
                                    contributors.put(key, val);
                                }
                                val.add(clazz.cast(obj));
                            }
                        }
                        catch (CoreException e) {
                            DslCommonPlugin.getDefault().error(MessageFormat.format(Messages.EclipseUtil_extensionLoadError, ext.getLabel()), e);
                            DslCommonPlugin.getDefault().getLog().log(e.getStatus());
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return contributors;
    }

    private static boolean checkAttribute(IConfigurationElement element, String attributeName, Predicate<String> exceptedAttributeValue) {
        if (attributeName != null) {
            String namedAttribute = element.getAttribute(attributeName);
            return namedAttribute != null && (exceptedAttributeValue == null || exceptedAttributeValue.apply((Object)namedAttribute));
        }
        return true;
    }

    public static List<IFile> getFilesFromWorkspace(final String prefix, final String suffix) {
        final ArrayList<IFile> matches = new ArrayList<IFile>();
        try {
            IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
            if (root != null) {
                root.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource.isAccessible() && resource instanceof IFile) {
                            boolean okForSuffix;
                            IFile file = (IFile)resource;
                            boolean okForPrefix = StringUtil.isEmpty(prefix) || file.getName().startsWith(prefix);
                            boolean bl = okForSuffix = StringUtil.isEmpty(suffix) || file.getName().endsWith(suffix);
                            if (okForPrefix && okForSuffix) {
                                matches.add(file);
                            }
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException coreException) {}
        return matches;
    }

    public static IConfigurationElement[] getConfigurationElementsFor(String extensionPointId) {
        IConfigurationElement[] result = new IConfigurationElement[]{};
        if (Platform.isRunning()) {
            result = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
        }
        return result;
    }
}

