/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ocl.business.internal.interpreter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.sirius.common.ocl.DslOclPlugin;
import org.eclipse.sirius.common.ocl.business.internal.interpreter.OclCompletionEntry;
import org.eclipse.sirius.common.ocl.tools.Messages;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IConverter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.VariableManager;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public class OclInterpreter
implements IInterpreter,
IInterpreterProvider,
IProposalProvider {
    public static final String OCL_DISCRIMINANT = "ocl:";
    private OCL<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> ocl;
    private OCLHelper<EClassifier, ?, ?, Constraint> helper;
    private final VariableManager variables = new VariableManager();
    private final IConverter converter = new OclConverter();

    public IConverter getConverter() {
        return this.converter;
    }

    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
    }

    public void addImport(String dependency) {
    }

    public void clearImports() {
    }

    public void setVariable(String name, Object value) {
        this.variables.setVariable(name, value);
    }

    public void unSetVariable(String name) {
        this.variables.unSetVariable(name);
    }

    public void clearVariables() {
        this.variables.clearVariables();
    }

    public Object getVariable(String name) {
        return this.variables.getVariable(name);
    }

    public Map<String, Object> getVariables() {
        return this.variables.getVariables();
    }

    public boolean provides(String expression) {
        return expression != null && expression.startsWith(OCL_DISCRIMINANT);
    }

    public void setProperty(Object key, Object value) {
    }

    public Object evaluate(EObject target, String expression) throws EvaluationException {
        return this.internalEvaluate(target, expression);
    }

    private Object internalEvaluate(EObject context, String expression) throws EvaluationException {
        String exp;
        block7: {
            exp = expression.substring(OCL_DISCRIMINANT.length());
            if (!"".equals(exp)) break block7;
            return null;
        }
        try {
            this.getOCLHelper().setContext((Object)context.eClass());
            for (Map.Entry<String, Object> variable : this.getVariables().entrySet()) {
                Object value = variable.getValue();
                Variable oclVar = EcoreFactory.eINSTANCE.createVariable();
                if (value instanceof Collection) {
                    SequenceType sequence = EcoreFactory.eINSTANCE.createSequenceType();
                    sequence.setElementType((Object)EcorePackage.eINSTANCE.getEObject());
                    oclVar.setType((Object)sequence);
                } else {
                    oclVar.setType((Object)EcorePackage.eINSTANCE.getEObject());
                }
                oclVar.setName(variable.getKey());
                this.getOCLHelper().getOCL().getEnvironment().addElement(oclVar.getName(), (org.eclipse.ocl.expressions.Variable)oclVar, false);
            }
            OCLExpression query = this.getOCLHelper().createQuery(exp);
            Query eval = this.getOCL().createQuery(query);
            for (Map.Entry<String, Object> variable : this.getVariables().entrySet()) {
                eval.getEvaluationEnvironment().add(variable.getKey(), variable.getValue());
            }
            return eval.evaluate((Object)context);
        }
        catch (ParserException pe) {
            throw new EvaluationException((Throwable)pe);
        }
    }

    public OCLHelper<EClassifier, ?, ?, Constraint> getOCLHelper() {
        if (this.helper == null) {
            this.helper = this.getOCL().createOCLHelper();
        }
        return this.helper;
    }

    private OCL<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> getOCL() {
        if (this.ocl == null) {
            this.ocl = this.safeCreateOCL((EnvironmentFactory<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?>)EcoreEnvironmentFactory.INSTANCE);
        }
        return this.ocl;
    }

    private OCL<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> safeCreateOCL(EnvironmentFactory<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> environmentFactory) {
        Method newInstanceMethod = null;
        try {
            newInstanceMethod = OCL.class.getDeclaredMethod("newInstance", EnvironmentFactory.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                newInstanceMethod = OCL.class.getDeclaredMethod("newInstanceAbstract", EnvironmentFactory.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {}
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new RuntimeException("No valid static factory method found for OCL", e);
        }
        if (newInstanceMethod != null && Modifier.isStatic(newInstanceMethod.getModifiers())) {
            try {
                Object oclInstance = newInstanceMethod.invoke(null, environmentFactory);
                if (oclInstance instanceof OCL) {
                    return (OCL)oclInstance;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {}
        }
        throw new RuntimeException("No valid static factory method found for OCL");
    }

    public IInterpreter createInterpreter() {
        return new OclInterpreter();
    }

    public void dispose() {
        this.variables.clearVariables();
    }

    public void setModelAccessor(ModelAccessor modelAccessor) {
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentContext context) {
        return OclCompletionEntry.computeCompletionEntry(context);
    }

    public String getPrefix() {
        return OCL_DISCRIMINANT;
    }

    public ContentProposal getNewEmtpyExpression() {
        return new ContentProposal(OCL_DISCRIMINANT, OCL_DISCRIMINANT, Messages.OclInterpreter_NewOclExpression);
    }

    public String getVariablePrefix() {
        return null;
    }

    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentInstanceContext context) {
        String textSoFar;
        String evaluationString;
        if (context != null && context.getTextSoFar() != null && context.getCursorPosition() != -1 && context.getTextSoFar().length() >= context.getCursorPosition() && (evaluationString = (textSoFar = context.getTextSoFar()).substring(0, context.getCursorPosition())).toLowerCase().startsWith(OCL_DISCRIMINANT) && context.getCurrentSelected() != null) {
            this.getOCLHelper().setContext((Object)context.getCurrentSelected().eClass());
            evaluationString = evaluationString.substring(OCL_DISCRIMINANT.length());
            List choices = this.getOCLHelper().getSyntaxHelp(ConstraintKind.INVARIANT, evaluationString);
            if (choices != null && !choices.isEmpty()) {
                ArrayList<ContentProposal> contentProposals = new ArrayList<ContentProposal>();
                for (Choice choice : choices) {
                    contentProposals.add(new ContentProposal(choice.getName(), choice.getName() + " (" + choice.getKind().name() + ")", choice.getDescription()));
                }
                Collections.sort(contentProposals);
                return contentProposals;
            }
        }
        return Collections.emptyList();
    }

    public Collection<String> getImports() {
        return Collections.emptyList();
    }

    public void removeImport(String dependency) {
    }

    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        return new LinkedHashSet<IInterpreterStatus>();
    }

    public boolean supportsValidation() {
        return false;
    }

    private static class OclConverter
    implements IConverter {
        private OclConverter() {
        }

        public OptionalInt toInt(Object rawValue) {
            Integer result = null;
            if (rawValue instanceof Integer) {
                result = (Integer)rawValue;
            } else if (rawValue instanceof String) {
                try {
                    result = new Integer((String)rawValue);
                }
                catch (NumberFormatException nfe) {
                    DslOclPlugin.getPlugin().error(Messages.OclInterpreter_OclNotANumber, nfe);
                }
            }
            if (result != null) {
                return OptionalInt.of(result);
            }
            return OptionalInt.empty();
        }

        public Optional<Boolean> toBoolean(Object rawValue) {
            boolean result = false;
            if (rawValue instanceof Boolean) {
                result = (Boolean)rawValue;
            } else if (rawValue instanceof String) {
                result = Boolean.parseBoolean((String)rawValue);
            }
            return Optional.of(result);
        }

        public Optional<String> toString(Object rawValue) {
            if (rawValue != null) {
                return Optional.of(rawValue.toString());
            }
            return Optional.empty();
        }

        public Optional<EObject> toEObject(Object rawValue) {
            if (rawValue instanceof EObject) {
                return Optional.of((EObject)rawValue);
            }
            return Optional.empty();
        }

        public Optional<Collection<EObject>> toEObjectCollection(Object rawValue) {
            List result;
            block4: {
                block5: {
                    block3: {
                        result = Collections.emptyList();
                        if (!(rawValue instanceof EObject)) break block3;
                        result = new ArrayList(1);
                        result.add((EObject)rawValue);
                        break block4;
                    }
                    if (!(rawValue instanceof Collection)) break block5;
                    result = new ArrayList(((Collection)rawValue).size());
                    for (Object object : (Collection)rawValue) {
                        if (!(object instanceof EObject)) continue;
                        result.add((EObject)object);
                    }
                    break block4;
                }
                if (rawValue == null || !rawValue.getClass().isArray()) break block4;
                result = new ArrayList(((Object[])rawValue).length);
                Object[] objectArray = (Object[])rawValue;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof EObject) {
                        result.add((EObject)object);
                    }
                    ++n2;
                }
            }
            return Optional.of(result);
        }
    }
}

