/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.business.internal.migration;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.AbsoluteBoundsFilter;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.GraphicalFilter;
import org.eclipse.sirius.diagram.IndirectlyCollapseFilter;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.ui.business.internal.diagramtype.SequenceCollapseUpdater;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class SequenceDiagramRepresentationsFileMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MESSAGE_FLAG_MIGRATION_VERSION = new Version("8.1.1");
    public static final Version GMF_BOUNDS_MIGRATION_VERSION = new Version("6.7.0.201302181200");
    private static final Version GMF_BOUNDS_ALREADY_MIGRATED_VERSION = new Version("6.5.3");
    private static final Version GMF_BOUNDS_NOT_MIGRATED_VERSION = new Version("6.6.0");
    private static final Version MIGRATION_VERSION = MESSAGE_FLAG_MIGRATION_VERSION;
    private Predicate<Node> isNode = new IsNode();
    private Predicate<Node> isCollapsedNode = new IsCollapsedNode();
    private Predicate<Node> isDirectlyCollapsedNode = new IsDirectlyCollapsedNode();

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    public void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        List<SequenceDDiagram> sequenceDDiagrams;
        List<Diagram> sequenceDiagrams;
        super.postLoad(dAnalysis, loadedVersion);
        if (!(loadedVersion.compareTo(GMF_BOUNDS_MIGRATION_VERSION) >= 0 || loadedVersion.compareTo(GMF_BOUNDS_ALREADY_MIGRATED_VERSION) >= 0 && loadedVersion.compareTo(GMF_BOUNDS_NOT_MIGRATED_VERSION) < 0 || (sequenceDiagrams = this.getGMFSequenceDiagrams(dAnalysis)).isEmpty())) {
            this.migrateGMFBoundsOfCollapsedBorderedNode(sequenceDiagrams);
        }
        if (loadedVersion.compareTo(MESSAGE_FLAG_MIGRATION_VERSION) < 0 && !(sequenceDDiagrams = this.getSequenceDDiagrams(dAnalysis)).isEmpty()) {
            for (SequenceDDiagram diagram : sequenceDDiagrams) {
                for (DEdge edge : diagram.getEdges()) {
                    for (AbsoluteBoundsFilter flag : Iterables.filter((Iterable)edge.getGraphicalFilters(), AbsoluteBoundsFilter.class)) {
                        flag.setX((Integer)DiagramPackage.eINSTANCE.getAbsoluteBoundsFilter_X().getDefaultValue());
                        flag.setWidth((Integer)DiagramPackage.eINSTANCE.getAbsoluteBoundsFilter_Width().getDefaultValue());
                    }
                }
            }
        }
    }

    protected List<Diagram> getGMFSequenceDiagrams(DAnalysis dAnalysis) {
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        for (SequenceDDiagram diagram : this.getSequenceDDiagrams(dAnalysis)) {
            DDiagramGraphicalQuery query = new DDiagramGraphicalQuery((DDiagram)diagram);
            Option option = query.getAssociatedGMFDiagram();
            if (!option.some()) continue;
            diagrams.add((Diagram)option.get());
        }
        return diagrams;
    }

    protected List<SequenceDDiagram> getSequenceDDiagrams(DAnalysis dAnalysis) {
        ArrayList<SequenceDDiagram> diagrams = new ArrayList<SequenceDDiagram>();
        for (DView view : dAnalysis.getOwnedViews()) {
            Iterables.addAll(diagrams, (Iterable)Iterables.filter((Iterable)new DViewQuery(view).getLoadedRepresentations(), SequenceDDiagram.class));
        }
        return diagrams;
    }

    private void migrateGMFBoundsOfCollapsedBorderedNode(List<Diagram> sequenceDiagrams) {
        for (Diagram diagram : sequenceDiagrams) {
            this.migrateChildrenOfCollapsedNode(diagram);
            UnmodifiableIterator viewIterator = Iterators.filter((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), Node.class), (Predicate)Predicates.and(this.isNode, this.isCollapsedNode));
            while (viewIterator.hasNext()) {
                Node node = (Node)viewIterator.next();
                DNode dNode = (DNode)node.getElement();
                LayoutConstraint layoutConstraint = node.getLayoutConstraint();
                if (!(layoutConstraint instanceof Bounds)) continue;
                Bounds bounds = (Bounds)layoutConstraint;
                for (GraphicalFilter graphicalFilter : dNode.getGraphicalFilters()) {
                    if (!(graphicalFilter instanceof CollapseFilter)) continue;
                    ((CollapseFilter)graphicalFilter).setWidth(bounds.getWidth());
                    ((CollapseFilter)graphicalFilter).setHeight(bounds.getHeight());
                }
                SequenceCollapseUpdater scbu = new SequenceCollapseUpdater();
                scbu.collapseBounds(node, (DDiagramElement)dNode);
            }
        }
    }

    private void migrateChildrenOfCollapsedNode(Diagram diagram) {
        ArrayList indirectlyCollaspedDDEs = new ArrayList();
        UnmodifiableIterator viewIterator = Iterators.filter((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), Node.class), this.isDirectlyCollapsedNode);
        while (viewIterator.hasNext()) {
            Node node = (Node)viewIterator.next();
            if (!(node.getElement() instanceof AbstractDNode)) continue;
            AbstractDNode abstractDNode = (AbstractDNode)node.getElement();
            indirectlyCollaspedDDEs.addAll(abstractDNode.getOwnedBorderedNodes());
            if (abstractDNode instanceof DNodeContainer) {
                DNodeContainer dDiagramElementContainer = (DNodeContainer)abstractDNode;
                indirectlyCollaspedDDEs.addAll(dDiagramElementContainer.getOwnedDiagramElements());
                continue;
            }
            if (!(abstractDNode instanceof DNodeList)) continue;
            DNodeList dNodeList = (DNodeList)abstractDNode;
            indirectlyCollaspedDDEs.addAll(dNodeList.getOwnedElements());
        }
        for (DDiagramElement indirectlyCollaspedDDE : indirectlyCollaspedDDEs) {
            if (Iterables.any((Iterable)indirectlyCollaspedDDE.getGraphicalFilters(), (Predicate)Predicates.instanceOf(IndirectlyCollapseFilter.class))) continue;
            IndirectlyCollapseFilter indirectlyCollapseFilter = DiagramFactory.eINSTANCE.createIndirectlyCollapseFilter();
            indirectlyCollaspedDDE.getGraphicalFilters().add((Object)indirectlyCollapseFilter);
        }
    }

    private static class IsCollapsedNode
    implements Predicate<Node> {
        private IsCollapsedNode() {
        }

        public boolean apply(Node input) {
            return new NodeQuery(input).isCollapsed();
        }
    }

    private static class IsDirectlyCollapsedNode
    implements Predicate<Node> {
        private IsDirectlyCollapsedNode() {
        }

        public boolean apply(Node input) {
            boolean apply = false;
            int type = SiriusVisualIDRegistry.getVisualID((String)input.getType());
            boolean result = type == 3001 || type == 3012;
            result = result || type == 2001 || type == 3007;
            result = result || type == 2002 || type == 3008;
            boolean bl = result = result || type == 2003 || type == 3009;
            if (result) {
                return new NodeQuery(input).isDirectlyCollapsed();
            }
            return apply;
        }
    }

    private static class IsNode
    implements Predicate<Node> {
        private IsNode() {
        }

        public boolean apply(Node input) {
            return new ViewQuery((View)input).isNode();
        }
    }
}

