/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.ImageIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.Print;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.SWTUtil;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ImagePrint
implements Print {
    ImageData imageData;
    Point dpi;
    Point size;

    public ImagePrint(ImageData imageData) {
        this(imageData, new Point(72, 72));
    }

    public ImagePrint(ImageData imageData, Point dpi) {
        Util.notNull(imageData, dpi);
        this.imageData = imageData;
        this.setDPI(dpi);
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImagePrint that = (ImagePrint)obj;
        return Util.equal(this.dpi, that.dpi) && Util.equal(this.size, that.size) && SWTUtil.equal(this.imageData, that.imageData);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.dpi.hashCode();
        result = prime * result + this.size.hashCode();
        result = prime * result + SWTUtil.hashCode(this.imageData);
        return result;
    }

    public void setSize(Point size) {
        Util.notNull(size);
        this.dpi = new Point((int)Math.ceil((double)this.imageData.width * 72.0 / (double)size.x), (int)Math.ceil((double)this.imageData.height * 72.0 / (double)size.y));
        this.size = size;
    }

    public void setSize(int width, int height) {
        this.setSize(new Point(width, height));
    }

    public Point getSize() {
        return this.size;
    }

    public void setDPI(Point dpi) {
        Util.notNull(dpi);
        this.dpi = dpi;
        this.size = new Point((int)Math.ceil((double)this.imageData.width * 72.0 / (double)dpi.x), (int)Math.ceil((double)this.imageData.height * 72.0 / (double)dpi.y));
    }

    public void setDPI(int dpiX, int dpiY) {
        this.setDPI(new Point(dpiX, dpiY));
    }

    public Point getDPI() {
        return this.dpi;
    }

    @Override
    public PrintIterator iterator(Device device, GC gc) {
        return new ImageIterator(this, device);
    }
}

