/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.eef.EefFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.properties.core.api.AbstractDescriptionConverter;
import org.eclipse.sirius.properties.core.api.TransformationCache;
import org.eclipse.sirius.properties.core.internal.Messages;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;

public class DefaultDescriptionConverter<SIRIUS extends EObject>
extends AbstractDescriptionConverter {
    private Class<SIRIUS> siriusClass;
    private EClass eefEClass;

    public DefaultDescriptionConverter(Class<SIRIUS> siriusClass, EClass eefEClass) {
        this.siriusClass = siriusClass;
        this.eefEClass = eefEClass;
    }

    @Override
    public boolean canHandle(EObject description) {
        return this.siriusClass.isAssignableFrom(description.getClass());
    }

    @Override
    public EObject convert(EObject description, Map<String, Object> parameters, TransformationCache cache) {
        if (this.siriusClass.isAssignableFrom(description.getClass())) {
            EObject siriusEObject = (EObject)this.siriusClass.cast(description);
            EObject eefEObject = this.getEFactory().create(this.eefEClass);
            for (EAttribute eAttribute : siriusEObject.eClass().getEAllAttributes()) {
                this.convertEAttribute(siriusEObject, eefEObject, eAttribute, parameters);
            }
            cache.put(description, eefEObject);
            for (EReference eReference : siriusEObject.eClass().getEAllReferences()) {
                this.convertEReference(siriusEObject, eefEObject, eReference, parameters, cache);
            }
            return eefEObject;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.IDescriptionConverter_InvalidDescriptionType, description.getClass().getName(), this.siriusClass.getName()));
    }

    protected EFactory getEFactory() {
        return EefFactory.eINSTANCE;
    }

    protected void convertEAttribute(SIRIUS siriusEObject, EObject eefEObject, EAttribute eAttribute, Map<String, Object> parameters) {
        EStructuralFeature eefEStructuralFeature = eefEObject.eClass().getEStructuralFeature(eAttribute.getName());
        if (eefEStructuralFeature instanceof EAttribute) {
            if (eefEStructuralFeature.getEType().getInstanceClass().equals(eAttribute.getEType().getInstanceClass())) {
                eefEObject.eSet(eefEStructuralFeature, siriusEObject.eGet((EStructuralFeature)eAttribute));
            } else if (eefEStructuralFeature.getEType().equals(EcorePackage.Literals.EINT) && eAttribute.getEType().equals(EcorePackage.Literals.ESTRING)) {
                Object value = siriusEObject.eGet((EStructuralFeature)eAttribute);
                eefEObject.eSet(eefEStructuralFeature, (Object)Integer.toString(Integer.valueOf(value.toString())));
            }
        } else {
            eefEStructuralFeature = eefEObject.eClass().getEStructuralFeature("identifier");
            if (eAttribute.equals(DescriptionPackage.Literals.IDENTIFIED_ELEMENT__NAME) && eefEStructuralFeature instanceof EAttribute) {
                eefEObject.eSet(eefEStructuralFeature, siriusEObject.eGet((EStructuralFeature)DescriptionPackage.Literals.IDENTIFIED_ELEMENT__NAME));
            }
        }
    }

    protected void convertEReference(SIRIUS siriusEObject, EObject eefEObject, EReference eReference, Map<String, Object> parameters, TransformationCache cache) {
        EStructuralFeature eefEStructuralFeature = eefEObject.eClass().getEStructuralFeature(eReference.getName());
        if (eefEStructuralFeature instanceof EReference) {
            Object siriusValue;
            if (eefEStructuralFeature.isMany() && eReference.isMany()) {
                Object siriusValue2 = siriusEObject.eGet((EStructuralFeature)eReference);
                Object eefValue = eefEObject.eGet(eefEStructuralFeature);
                if (siriusValue2 instanceof Collection && eefValue instanceof Collection) {
                    Collection siriusCollectionValue = (Collection)siriusValue2;
                    List convertedCollection = this.convertCollection(siriusCollectionValue, parameters, cache, eefEStructuralFeature.getEType().getInstanceClass());
                    Collection eefCollectionValue = (Collection)eefValue;
                    eefEObject.eSet(eefEStructuralFeature, this.addAll(this.addAll(new ArrayList<EObject>(), eefCollectionValue), convertedCollection));
                }
            } else if (!eefEStructuralFeature.isMany() && !eReference.isMany() && (siriusValue = siriusEObject.eGet((EStructuralFeature)eReference)) instanceof EObject) {
                Object convertedEObject = this.convertEObject((EObject)siriusValue, parameters, cache, eefEStructuralFeature.getEType().getInstanceClass());
                eefEObject.eSet(eefEStructuralFeature, convertedEObject);
            }
        }
    }

    protected List<EObject> addAll(List<EObject> eObjects, Collection<?> collection) {
        for (Object object : collection) {
            if (!(object instanceof EObject)) continue;
            eObjects.add((EObject)object);
        }
        return eObjects;
    }
}

