/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.business.api.helper.task.IModelOperationManager;
import org.eclipse.sirius.business.internal.helper.task.ModelOperationManagerDescriptor;
import org.eclipse.sirius.business.internal.helper.task.ModelOperationManagerRegistry;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;

public class ModelOperationManagerRegistryListener
implements IRegistryChangeListener {
    public static final String MODEL_OPERATION_MANAGER_EXTENSION_POINT = "org.eclipse.sirius.modelOperationManager";
    private static final String MODEL_OPERATION_MANAGER_TAG_EXTENSION = "modelOperationManager";

    public void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, MODEL_OPERATION_MANAGER_EXTENSION_POINT);
        this.parseInitialContributions();
    }

    public void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(MODEL_OPERATION_MANAGER_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    private void parseExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (MODEL_OPERATION_MANAGER_TAG_EXTENSION.equals(elem.getName())) {
                try {
                    String id = elem.getAttribute("id");
                    Object object = elem.createExecutableExtension("class");
                    if (object instanceof IModelOperationManager) {
                        IModelOperationManager manager = (IModelOperationManager)object;
                        ModelOperationManagerRegistry.addExtension(new ModelOperationManagerDescriptor(id, manager));
                    }
                }
                catch (CoreException e) {
                    SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", MessageFormat.format(Messages.EclipseDeleteHookDescriptor_extensionLoadingErrorMsg, elem.getDeclaringExtension().getUniqueIdentifier()), (Throwable)e));
                }
            }
            ++n2;
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        ArrayList<IExtension> addedExtensions = new ArrayList<IExtension>();
        ArrayList<IExtension> removedExtensions = new ArrayList<IExtension>();
        int i = 0;
        while (i < deltas.length) {
            if (MODEL_OPERATION_MANAGER_EXTENSION_POINT.equals(deltas[i].getExtensionPoint().getUniqueIdentifier())) {
                if (deltas[i].getKind() == 1) {
                    extension = deltas[i].getExtension();
                    addedExtensions.add(extension);
                } else if (deltas[i].getKind() == 2) {
                    extension = deltas[i].getExtension();
                    removedExtensions.add(extension);
                }
            }
            ++i;
        }
        this.added(addedExtensions.toArray(new IExtension[0]));
        this.removed(addedExtensions.toArray(new IExtension[0]));
    }

    private void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    private void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                if (MODEL_OPERATION_MANAGER_TAG_EXTENSION.equals(elem.getName())) {
                    String extensionClassName = elem.getAttribute("class");
                    ModelOperationManagerRegistry.removeExtension(extensionClassName);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void dispose() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeRegistryChangeListener((IRegistryChangeListener)this);
        ModelOperationManagerRegistry.clearRegistry();
    }
}

