/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.logger.InterpretationContext;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.internal.refresh.DTableStyleHelper;
import org.eclipse.sirius.table.business.internal.refresh.LabelUtils;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.description.CellUpdater;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.FeatureColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.IntersectionMapping;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class DTableElementSynchronizer {
    protected static final String SKIP_FEATURENAME_VALIDATION = "*";
    private final ModelAccessor accessor;
    private final RuntimeLoggerInterpreter interpreter;

    public DTableElementSynchronizer(ModelAccessor accessor, IInterpreter interpreter) {
        this.interpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
        this.accessor = accessor;
    }

    private String getHeaderLabel(DSemanticDecorator header, TableMapping mapping, EStructuralFeature labelExpression) {
        if (!StringUtil.isEmpty((String)((String)mapping.eGet(labelExpression)))) {
            return (String)InterpretationContext.with((RuntimeLoggerInterpreter)this.interpreter, it -> {
                it.setLogError(false);
                return this.interpreter.evaluateString(header.getTarget(), (EObject)mapping, labelExpression);
            });
        }
        return LabelUtils.getValueText(header.getTarget());
    }

    public void refresh(DLine line) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)line)) {
            String label = this.getHeaderLabel((DSemanticDecorator)line, (TableMapping)line.getOriginMapping(), (EStructuralFeature)DescriptionPackage.eINSTANCE.getLineMapping_HeaderLabelExpression());
            DTableElementSynchronizer.setLabelOnUpdate(line, label);
            new DTableStyleHelper(this.interpreter).refresh(line);
        }
    }

    public void refresh(DCell cell) {
        if (cell != null && this.accessor.getPermissionAuthority().canEditInstance((EObject)cell) && this.refreshTarget(cell) && this.refreshLabel(cell)) {
            new DTableStyleHelper(this.interpreter).refresh(cell);
            this.refreshSemanticElements(cell);
        }
    }

    public void refresh(DColumn column) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)column) && column instanceof DTargetColumn) {
            this.refresh((DTargetColumn)column);
        }
    }

    private void refresh(DTargetColumn column) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)column)) {
            String label = this.getHeaderLabel((DSemanticDecorator)column, (TableMapping)column.getOriginMapping(), (EStructuralFeature)DescriptionPackage.eINSTANCE.getColumnMapping_HeaderLabelExpression());
            DTableElementSynchronizer.setLabelOnUpdate((DColumn)column, label);
            new DTableStyleHelper(this.interpreter).refresh((DColumn)column);
        }
    }

    public void refresh(DFeatureColumn column) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)column)) {
            DTable dTable = TableHelper.getTable((EObject)column);
            String label = dTable != null ? this.getHeaderLabel((DSemanticDecorator)dTable, (TableMapping)column.getOriginMapping(), (EStructuralFeature)DescriptionPackage.eINSTANCE.getColumnMapping_HeaderLabelExpression()) : column.getOriginMapping().getHeaderLabelExpression();
            DTableElementSynchronizer.setLabelOnUpdate((DColumn)column, label);
            new DTableStyleHelper(this.interpreter).refresh((DColumn)column);
        }
    }

    public boolean refreshTarget(DCell cell) {
        if (cell.getLine() == null) {
            return true;
        }
        boolean deletedCell = false;
        EObject featureParent = cell.getLine().getTarget();
        if (cell.getColumn() instanceof DFeatureColumn) {
            FeatureColumnMapping featureColumnMapping = (FeatureColumnMapping)cell.getColumn().getMapping();
            String featureParentExpression = featureColumnMapping.getFeatureParentExpression();
            if (featureParentExpression != null && featureParentExpression.length() > 0) {
                DTable table = TableHelper.getTable((EObject)cell);
                featureParent = (EObject)InterpretationContext.with((RuntimeLoggerInterpreter)this.interpreter, it -> {
                    it.setVariable("container", (Object)cell.getLine().getTarget());
                    it.setVariable("line", (Object)cell.getLine());
                    it.setVariable("table", (Object)table);
                    if (table != null) {
                        it.setVariable("root", (Object)table.getTarget());
                    }
                    it.setLogError(TableHelper.hasTableDescriptionOnlyOneLineMapping((DTableElement)cell));
                    return this.interpreter.evaluateEObject(cell.getLine().getTarget(), (EObject)featureColumnMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getFeatureColumnMapping_FeatureParentExpression());
                });
            }
            if (featureParent == null) {
                this.removeUneededCell(cell);
                deletedCell = true;
            } else if (!featureParent.equals(cell.getTarget())) {
                if (this.isValidFeatureMapping(featureParent, featureColumnMapping)) {
                    cell.setTarget(featureParent);
                } else {
                    this.removeUneededCell(cell);
                    deletedCell = true;
                }
            }
        }
        return !deletedCell;
    }

    private boolean isValidFeatureMapping(EObject target, FeatureColumnMapping mapping) {
        String featureName = mapping.getFeatureName();
        return SKIP_FEATURENAME_VALIDATION.equals(featureName) || this.accessor.eValid(target, featureName);
    }

    public boolean refreshLabel(DCell cell) {
        boolean cellStillExists = false;
        DColumn column = cell.getColumn();
        if (column != null) {
            CellUpdater updater = cell.getUpdater();
            cellStillExists = updater instanceof IntersectionMapping && cell.getLabel() != null ? this.refreshValidIntersectionLabel(cell, (IntersectionMapping)updater) : this.updateCellLabel(cell);
        }
        if (!cellStillExists) {
            this.removeUneededCell(cell);
        }
        return cellStillExists;
    }

    protected void removeUneededCell(DCell cell) {
        Session session = SessionManager.INSTANCE.getSession(cell.getTarget());
        if (session == null) {
            DLine line = cell.getLine();
            DColumn column = cell.getColumn();
            EObject target = null;
            if (line != null) {
                target = line.getTarget();
            } else if (column instanceof DFeatureColumn && column.getTable() != null) {
                target = column.getTable().getTarget();
            } else if (column instanceof DTargetColumn) {
                target = column.getTarget();
            }
            if (target != null) {
                session = SessionManager.INSTANCE.getSession(target);
            }
        }
        if (this.accessor.getPermissionAuthority().canDeleteInstance((EObject)cell)) {
            if (session != null) {
                ECrossReferenceAdapter xref = session.getSemanticCrossReferencer();
                this.accessor.eDelete((EObject)cell, xref);
            } else {
                cell.setLine(null);
                cell.setColumn(null);
            }
        }
    }

    private boolean refreshValidIntersectionLabel(DCell cell, IntersectionMapping intersectionMapping) {
        Collection<EObject> foundColumnTargets;
        boolean cellNeeded = false;
        DLine line = cell.getLine();
        DColumn column = cell.getColumn();
        if (line != null && line.getTarget() != null && column != null && column.getTarget() != null && (foundColumnTargets = this.evaluateColumnFinderExpression(cell, intersectionMapping)).contains(column.getTarget()) && this.evaluateIntersectionPrecondition(column.getTarget(), line, column, intersectionMapping)) {
            cellNeeded = this.updateCellLabel(cell);
        }
        return cellNeeded;
    }

    private Collection<EObject> evaluateColumnFinderExpression(DCell cell, IntersectionMapping iMapping) {
        DLine container;
        DCell source;
        if (iMapping.isUseDomainClass()) {
            source = cell;
            container = TableHelper.getTable((EObject)cell.getLine());
        } else {
            container = cell.getLine();
            source = container;
        }
        return this.evaluateColumnFinderExpression(source.getTarget(), (LineContainer)container, iMapping, false);
    }

    Collection<EObject> evaluateColumnFinderExpression(EObject candidate, LineContainer container, IntersectionMapping iMapping, boolean logError) {
        return (Collection)InterpretationContext.with((RuntimeLoggerInterpreter)this.interpreter, it -> {
            DTable table;
            it.setLogError(logError);
            if (iMapping.isUseDomainClass()) {
                table = (DTable)container;
            } else {
                DLine line = (DLine)container;
                it.setVariable("line", (Object)line);
                it.setVariable("lineSemantic", (Object)line.getTarget());
                table = TableHelper.getTable((EObject)line);
            }
            it.setVariable("root", (Object)table.getTarget());
            it.setVariable("table", (Object)table);
            it.setVariable("viewpoint", (Object)table);
            return this.interpreter.evaluateCollection(candidate, (EObject)iMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getIntersectionMapping_ColumnFinderExpression());
        });
    }

    public Collection<EObject> evaluateLineFinderExpression(EObject candidate, DTable table, IntersectionMapping iMapping) {
        return (Collection)InterpretationContext.with((RuntimeLoggerInterpreter)this.interpreter, it -> {
            it.setVariable("root", (Object)table.getTarget());
            it.setVariable("viewpoint", (Object)table);
            it.setVariable("table", (Object)table);
            return this.interpreter.evaluateCollection(candidate, (EObject)iMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getIntersectionMapping_LineFinderExpression());
        });
    }

    public boolean evaluateIntersectionPrecondition(EObject semanticElement, DLine line, DColumn column, IntersectionMapping mapping) {
        String preconditionExpression = mapping.getPreconditionExpression();
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.CHECK_PRECONDITION_KEY);
        boolean result = true;
        if (!StringUtil.isEmpty((String)preconditionExpression)) {
            result = (Boolean)InterpretationContext.with((RuntimeLoggerInterpreter)this.interpreter, it -> {
                it.setLogError(false);
                it.setVariable("line", (Object)line);
                it.setVariable("lineSemantic", (Object)line.getTarget());
                it.setVariable("column", (Object)column);
                it.setVariable("columnSemantic", (Object)column.getTarget());
                it.setVariable("table", (Object)TableHelper.getTable((EObject)line));
                return this.interpreter.evaluateBoolean(semanticElement, (EObject)mapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getIntersectionMapping_PreconditionExpression());
            });
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.CHECK_PRECONDITION_KEY);
        return result;
    }

    private boolean updateCellLabel(DCell cell) {
        CellUpdater updater = cell.getUpdater();
        boolean cellNeeded = false;
        if (updater instanceof IntersectionMapping) {
            cellNeeded = this.updateCellLabel(cell, (IntersectionMapping)updater);
        } else if (updater instanceof FeatureColumnMapping) {
            cellNeeded = this.updateCellLabel(cell, (FeatureColumnMapping)updater);
        }
        return cellNeeded;
    }

    private boolean updateCellLabel(DCell cell, IntersectionMapping updater) {
        boolean cellNeeded = false;
        if (!StringUtil.isEmpty((String)updater.getLabelComputationExpression())) {
            cellNeeded = this.updateCellLabel(cell, (CellUpdater)updater, (EStructuralFeature)DescriptionPackage.eINSTANCE.getIntersectionMapping_LabelExpression());
        } else {
            cellNeeded = true;
            DTableElementSynchronizer.setLabelOnUpdate(cell, null);
        }
        return cellNeeded;
    }

    private boolean updateCellLabel(DCell cell, FeatureColumnMapping updater) {
        boolean cellNeeded = false;
        String featureName = updater.getFeatureName();
        if (this.isValidFeatureMapping(cell.getTarget(), updater)) {
            cellNeeded = !StringUtil.isEmpty((String)updater.getLabelComputationExpression()) ? this.updateCellLabel(cell, (CellUpdater)updater, (EStructuralFeature)DescriptionPackage.eINSTANCE.getFeatureColumnMapping_LabelExpression()) : this.updateCellLabel(cell, (ColumnMapping)updater, featureName);
        }
        return cellNeeded;
    }

    private boolean updateCellLabel(DCell cell, CellUpdater updater, EStructuralFeature labelFeature) {
        if (cell.getTarget() == null) {
            return false;
        }
        String label = (String)InterpretationContext.with((RuntimeLoggerInterpreter)this.interpreter, it -> {
            DTable table;
            it.setLogError(TableHelper.hasTableDescriptionOnlyOneLineMapping((DTableElement)cell));
            if (cell.getLine() != null) {
                it.setVariable("line", (Object)cell.getLine());
                it.setVariable("lineSemantic", (Object)cell.getLine().getTarget());
                it.setVariable("container", (Object)cell.getLine().getTarget());
            }
            if (cell.getColumn() != null) {
                it.setVariable("column", (Object)cell.getColumn());
                it.setVariable("columnSemantic", (Object)cell.getColumn().getTarget());
            }
            if ((table = TableHelper.getTable((EObject)cell)) != null) {
                it.setVariable("table", (Object)table);
                it.setVariable("root", (Object)table.getTarget());
            }
            return this.interpreter.evaluateString(cell.getTarget(), (EObject)cell.getUpdater(), labelFeature);
        });
        DTableElementSynchronizer.setLabelOnUpdate(cell, label);
        return true;
    }

    private boolean updateCellLabel(DCell cell, ColumnMapping columnMapping, String featureName) {
        String label = null;
        try {
            Object featureObject = this.accessor.eGet(cell.getTarget(), featureName);
            if (featureObject != null) {
                label = LabelUtils.getValueText(featureObject);
            } else if (cell.getTarget().eClass().getEStructuralFeature(featureName) != null) {
                label = "";
            }
            if (label != null) {
                DTableElementSynchronizer.setLabelOnUpdate(cell, label);
            }
        }
        catch (FeatureNotFoundException e) {
            RuntimeLoggerManager.INSTANCE.error((EObject)columnMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getFeatureColumnMapping_FeatureName(), (Throwable)e);
        }
        return label != null;
    }

    public void refreshSemanticElements(DCell newCell) {
        IntersectionMapping intersectionMapping = newCell.getIntersectionMapping();
        if (intersectionMapping != null) {
            this.refreshSemanticElements((DTableElement)newCell, (TableMapping)intersectionMapping);
        } else {
            ArrayList<EObject> newElements = new ArrayList<EObject>();
            if (newCell.getColumn().getOriginMapping() instanceof FeatureColumnMapping) {
                if (newCell.getTarget() != null) {
                    newElements.add(newCell.getTarget());
                }
                if (newCell.getLine() != null) {
                    newElements.addAll((Collection<EObject>)newCell.getLine().getSemanticElements());
                }
            } else if (newCell.getColumn() instanceof DTargetColumn) {
                if (newCell.getTarget() != null) {
                    newElements.add(newCell.getTarget());
                }
                if (newCell.getLine() != null) {
                    newElements.add(newCell.getLine().getTarget());
                    newElements.addAll((Collection<EObject>)newCell.getLine().getSemanticElements());
                    newElements.add(((DTargetColumn)newCell.getColumn()).getTarget());
                    newElements.addAll((Collection<EObject>)((DTargetColumn)newCell.getColumn()).getSemanticElements());
                }
            }
            this.synchronizeLists((EList<EObject>)newCell.getSemanticElements(), newElements);
        }
    }

    private void synchronizeLists(EList<EObject> semanticElements, Collection<EObject> newElements) {
        if (!semanticElements.containsAll(newElements) || !newElements.containsAll((Collection<?>)semanticElements)) {
            Iterator it = semanticElements.iterator();
            while (it.hasNext()) {
                EObject cur = (EObject)it.next();
                if (newElements.contains(cur)) continue;
                it.remove();
            }
            semanticElements.addAll(newElements);
        }
    }

    public void refreshSemanticElements(DTableElement tableElement, TableMapping mapping) {
        Collection<Object> elements = !StringUtil.isEmpty((String)mapping.getSemanticElements()) ? (Collection)InterpretationContext.with((RuntimeLoggerInterpreter)this.interpreter, it -> {
            EObject container = tableElement.eContainer();
            if (container != null) {
                it.setVariable("containerView", (Object)container);
                if (container instanceof DSemanticDecorator) {
                    it.setVariable("container", (Object)((DSemanticDecorator)container).getTarget());
                }
            }
            it.setVariable("view", (Object)tableElement);
            it.setLogError(mapping instanceof LineMapping || TableHelper.hasTableDescriptionOnlyOneLineMapping(mapping));
            EAttribute semElemFeature = DescriptionPackage.eINSTANCE.getTableMapping_SemanticElements();
            return this.interpreter.evaluateCollection(tableElement.getTarget(), (EObject)mapping, (EStructuralFeature)semElemFeature);
        }) : (tableElement.getTarget() != null ? Collections.singletonList(tableElement.getTarget()) : Collections.emptyList());
        this.synchronizeLists((EList<EObject>)tableElement.getSemanticElements(), elements);
    }

    ModelAccessor getAccessor() {
        return this.accessor;
    }

    RuntimeLoggerInterpreter getInterpreter() {
        return this.interpreter;
    }

    private static void setLabelOnUpdate(DLine line, String value) {
        if (!StringUtil.equals((CharSequence)line.getLabel(), (CharSequence)value)) {
            line.setLabel(value);
        }
    }

    private static void setLabelOnUpdate(DColumn column, String value) {
        if (!StringUtil.equals((CharSequence)column.getLabel(), (CharSequence)value)) {
            column.setLabel(value);
        }
    }

    private static void setLabelOnUpdate(DCell cell, String value) {
        if (!StringUtil.equals((CharSequence)cell.getLabel(), (CharSequence)value)) {
            cell.setLabel(value);
        }
    }
}

