/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.refresh;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IEditableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class RefreshRunnableWithProgress
implements IRunnableWithProgress {
    Collection<EditPart> editPartsToRefresh;

    public RefreshRunnableWithProgress(Collection<EditPart> editPartsToRefresh) {
        this.editPartsToRefresh = editPartsToRefresh;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(Messages.RefreshRunnableWithProgress_taskName, this.editPartsToRefresh.size());
            ArrayList<org.eclipse.gef.commands.Command> commandsToExecute = new ArrayList<org.eclipse.gef.commands.Command>();
            for (EditPart editPartToRefresh : this.editPartsToRefresh) {
                if (editPartToRefresh instanceof IDDiagramEditPart) {
                    this.refreshFromDiagramEditPart((IDDiagramEditPart)editPartToRefresh, monitor);
                    continue;
                }
                Option<org.eclipse.gef.commands.Command> refreshEditPartCommand = this.refreshFromEditPart(editPartToRefresh, monitor);
                if (!refreshEditPartCommand.some()) continue;
                commandsToExecute.add((org.eclipse.gef.commands.Command)refreshEditPartCommand.get());
            }
            this.executeInCompoundCommand(commandsToExecute, monitor);
        }
        finally {
            monitor.done();
        }
    }

    private IDiagramEditDomain getFirstEditingDomain() {
        for (EditPart editPart : this.editPartsToRefresh) {
            if (!(editPart instanceof IDiagramElementEditPart)) continue;
            return ((IDiagramElementEditPart)editPart).getDiagramEditDomain();
        }
        return null;
    }

    private void executeInCompoundCommand(Collection<org.eclipse.gef.commands.Command> commandsToExecute, IProgressMonitor monitor) {
        if (!commandsToExecute.isEmpty()) {
            IDiagramEditDomain domain = this.getFirstEditingDomain();
            CompoundCommand compoundCommand = new CompoundCommand(Messages.RefreshRunnableWithProgress_commandLabel);
            for (org.eclipse.gef.commands.Command command : commandsToExecute) {
                compoundCommand.add(command);
            }
            domain.getDiagramCommandStack().execute((org.eclipse.gef.commands.Command)compoundCommand);
            monitor.worked(commandsToExecute.size());
        }
    }

    private void refreshFromDiagramEditPart(IDDiagramEditPart dDiagramEditPart, IProgressMonitor progressMonitor) {
        dDiagramEditPart.enableEditMode();
        Option<DDiagram> dDiagramOption = dDiagramEditPart.resolveDDiagram();
        if (dDiagramOption.some()) {
            DDiagram dDiagram = (DDiagram)dDiagramOption.get();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)dDiagram);
            domain.getCommandStack().execute((Command)new RefreshRepresentationsCommand(domain, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), new DRepresentation[]{dDiagram}));
        }
    }

    private Option<org.eclipse.gef.commands.Command> refreshFromEditPart(EditPart editPart, IProgressMonitor progressMonitor) {
        GroupRequest refreshRequest;
        org.eclipse.gef.commands.Command refreshCmd;
        Option oldEditModeState = Options.newNone();
        if (editPart instanceof IEditableEditPart) {
            IEditableEditPart editableEditPart = (IEditableEditPart)editPart;
            oldEditModeState = Options.newSome((Object)editableEditPart.isEditModeEnabled());
            editableEditPart.enableEditMode();
        }
        if ((refreshCmd = editPart.getCommand((Request)(refreshRequest = new GroupRequest((Object)"refreshSirius")))) != null && refreshCmd.canExecute() && editPart instanceof IGraphicalEditPart) {
            return Options.newSome((Object)refreshCmd);
        }
        if (editPart instanceof IEditableEditPart && ((Boolean)oldEditModeState.get()).booleanValue() && !oldEditModeState.some()) {
            progressMonitor.worked(1);
            ((IEditableEditPart)editPart).disableEditMode();
        }
        return Options.newNone();
    }
}

