/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.view;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;
import org.eclipse.sirius.diagram.ui.tools.api.format.AbstractSiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.util.EditPartTools;

public class RootLayoutData
extends LayoutData {
    private EditPartViewer viewer;
    private Point moveDelta;

    public RootLayoutData(EditPart editPart, Point location, Dimension size) {
        this(EditPartTools.getParentOfType(editPart, IGraphicalEditPart.class).resolveSemanticElement(), location, size);
    }

    public RootLayoutData(AbstractDNode target, ShapeEditPart editPart, EditPartViewer viewer, Point location, Point moveDelta) {
        this.setViewer(viewer);
        this.moveDelta = moveDelta;
        this.init(target, (Node)editPart.getModel(), location);
    }

    public RootLayoutData(Object adaptObject, Point location, Dimension size) {
        if (adaptObject instanceof DDiagram || adaptObject instanceof AbstractDNode || adaptObject instanceof DEdge) {
            this.init((EObject)adaptObject, location, size);
        } else {
            AbstractSiriusFormatDataManager.logUnhandledDiagramElementKindMessage(adaptObject);
        }
    }

    protected void init(AbstractDNode nodeTarget, Node gmfNode, Point futureLocation) {
        super.init(nodeTarget, gmfNode);
        if (futureLocation != null) {
            this.setLocation(futureLocation);
        }
    }

    protected void init(EObject parentNodeTarget, Point futureLocation, Dimension futureSize) {
        this.setTarget(parentNodeTarget);
        this.setSize(futureSize);
        this.setLocation(futureLocation);
        this.setChildren(new ArrayList<LayoutData>());
    }

    @Override
    public RootLayoutData getRoot() {
        return this;
    }

    public LayoutData getData(DDiagram diagram, boolean ignoreConsumeState) {
        RootLayoutData result = (ignoreConsumeState || !this.isConsume()) && this.getTarget().equals(diagram) ? this : null;
        return result;
    }

    public Point getMoveDelta() {
        return this.moveDelta;
    }

    public EditPartViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(EditPartViewer viewer) {
        this.viewer = viewer;
    }
}

