/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.sample.scxml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BooleanDatatype implements Enumerator
{
    TRUE(0, "true", "true"),
    FALSE(1, "false", "false");

    public static final int TRUE_VALUE = 0;
    public static final int FALSE_VALUE = 1;
    private static final BooleanDatatype[] VALUES_ARRAY;
    public static final List<BooleanDatatype> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BooleanDatatype[]{TRUE, FALSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BooleanDatatype get(String literal) {
        BooleanDatatype[] booleanDatatypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanDatatype result = booleanDatatypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static BooleanDatatype getByName(String name) {
        BooleanDatatype[] booleanDatatypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanDatatype result = booleanDatatypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static BooleanDatatype get(int value) {
        switch (value) {
            case 0: {
                return TRUE;
            }
            case 1: {
                return FALSE;
            }
        }
        return null;
    }

    private BooleanDatatype(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

