/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQueryProvider;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.business.api.image.RichTextAttributeRegistry;
import org.eclipse.sirius.business.internal.dialect.description.InterpretedExpressionQueryProviderRegistry;
import org.eclipse.sirius.business.internal.helper.delete.DeleteHookDescriptorRegistryListener;
import org.eclipse.sirius.business.internal.helper.task.ModelOperationManagerRegistryListener;
import org.eclipse.sirius.business.internal.query.DRepresentationWithSessionInternalQueryHelper;
import org.eclipse.sirius.business.internal.query.LocalProjectDependencyProvider;
import org.eclipse.sirius.business.internal.query.ProjectDependencyProviderRegistry;
import org.eclipse.sirius.business.internal.representation.DRepresentationLocationRuleRegistryListener;
import org.eclipse.sirius.business.internal.resource.strategy.ResourceStrategyRegistryListener;
import org.eclipse.sirius.business.internal.session.factory.SessionFactoryRegistryListener;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessorsRegistry;
import org.eclipse.sirius.model.business.internal.migration.IMigrationHandler;
import org.eclipse.sirius.model.business.internal.query.DRepresentationInternalQueryHelper;
import org.eclipse.sirius.model.tools.internal.SiriusModelPlugin;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.tools.internal.ui.ExternalJavaActionRegistryListener;
import org.eclipse.sirius.tools.internal.validation.EValidatorAdapter;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.osgi.framework.BundleContext;

public final class SiriusPlugin
extends EMFPlugin {
    public static final boolean IS_ECLIPSE_RUNNING;
    public static final String ID = "org.eclipse.sirius";
    public static final SiriusPlugin INSTANCE;
    private static Implementation plugin;
    private static final ModelAccessorsRegistry REGISTRY;

    static {
        boolean result = false;
        try {
            result = Platform.isRunning();
        }
        catch (Throwable throwable) {}
        IS_ECLIPSE_RUNNING = result;
        INSTANCE = new SiriusPlugin();
        REGISTRY = new ModelAccessorsRegistry();
    }

    public SiriusPlugin() {
        super(new ResourceLocator[]{EcorePlugin.INSTANCE, INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getDefault() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        private InterpreterRegistry interRegistry;
        private SessionFactoryRegistryListener sessionFactoryRegistryListener;
        private DeleteHookDescriptorRegistryListener deleteHookDescriptorRegistryListener;
        private ExternalJavaActionRegistryListener javaActionRegistryListener;
        private ResourceStrategyRegistryListener resourceStrategyRegistryListener;
        private DRepresentationLocationRuleRegistryListener repLocationRuleRegistryListener;
        private ModelOperationManagerRegistryListener modelOperationManagerRegistryListener;
        private InterpretedExpressionQueryProviderRegistry expressionQueryProviderRegistry;
        private UICallBack uiCallback;
        private AtomicBoolean repairInProgress;

        public Implementation() {
            plugin = this;
            this.repairInProgress = new AtomicBoolean(false);
        }

        public boolean isRepairInProgress() {
            return this.repairInProgress.get();
        }

        public void setRepairInProgress(boolean repairInProgress) {
            this.repairInProgress.set(repairInProgress);
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            DefaultScope.INSTANCE.getNode(SiriusPlugin.ID);
            this.interRegistry = new InterpreterRegistry();
            EValidator.Registry.INSTANCE.put((Object)ViewpointPackage.eINSTANCE, (Object)new EValidatorAdapter());
            EValidator.Registry.INSTANCE.put((Object)DescriptionPackage.eINSTANCE, (Object)new EValidatorAdapter());
            EValidator.Registry.INSTANCE.put((Object)ToolPackage.eINSTANCE, (Object)new EValidatorAdapter());
            this.sessionFactoryRegistryListener = new SessionFactoryRegistryListener();
            this.sessionFactoryRegistryListener.init();
            this.deleteHookDescriptorRegistryListener = new DeleteHookDescriptorRegistryListener();
            this.deleteHookDescriptorRegistryListener.init();
            this.javaActionRegistryListener = new ExternalJavaActionRegistryListener();
            this.javaActionRegistryListener.init();
            this.resourceStrategyRegistryListener = new ResourceStrategyRegistryListener();
            this.resourceStrategyRegistryListener.init();
            this.repLocationRuleRegistryListener = new DRepresentationLocationRuleRegistryListener();
            this.repLocationRuleRegistryListener.init();
            this.modelOperationManagerRegistryListener = new ModelOperationManagerRegistryListener();
            this.modelOperationManagerRegistryListener.init();
            this.expressionQueryProviderRegistry = new InterpretedExpressionQueryProviderRegistry(Platform.getExtensionRegistry(), (Plugin)this);
            this.expressionQueryProviderRegistry.init();
            List migrationHandlers = EclipseUtil.getExtensionPlugins(org.eclipse.sirius.business.internal.migration.IMigrationHandler.class, (String)"org.eclipse.sirius.migrationHandler", (String)"class");
            if (migrationHandlers.size() > 0) {
                SiriusModelPlugin.getDefault().setMigrationHandler((IMigrationHandler)migrationHandlers.get(0));
            }
            DRepresentationInternalQueryHelper.setInstance((DRepresentationInternalQueryHelper)new DRepresentationWithSessionInternalQueryHelper());
            RichTextAttributeRegistry.INSTANCE.add(DescriptionPackage.eINSTANCE.getDocumentedElement_Documentation());
            ProjectDependencyProviderRegistry.getDefault().registerProjectDependencyProvider(new LocalProjectDependencyProvider());
        }

        public Collection<IInterpretedExpressionQueryProvider> getInterpretedExpressionQueryProviders() {
            return this.expressionQueryProviderRegistry.getEntries();
        }

        public void stop(BundleContext context) throws Exception {
            REGISTRY.dispose();
            this.sessionFactoryRegistryListener.dispose();
            this.sessionFactoryRegistryListener = null;
            this.deleteHookDescriptorRegistryListener.dispose();
            this.deleteHookDescriptorRegistryListener = null;
            this.javaActionRegistryListener.dispose();
            this.javaActionRegistryListener = null;
            this.resourceStrategyRegistryListener.dispose();
            this.resourceStrategyRegistryListener = null;
            this.repLocationRuleRegistryListener.dispose();
            this.repLocationRuleRegistryListener = null;
            this.modelOperationManagerRegistryListener.dispose();
            this.modelOperationManagerRegistryListener = null;
            this.expressionQueryProviderRegistry.dispose();
            this.expressionQueryProviderRegistry = null;
            ViewpointRegistry.getInstance().dispose();
            MultiLanguagesValidator.getInstance().dispose();
            InstanceScope.INSTANCE.getNode(SiriusPlugin.ID).flush();
            super.stop(context);
        }

        public ModelAccessorsRegistry getModelAccessorRegistry() {
            return REGISTRY;
        }

        public InterpreterRegistry getInterpreterRegistry() {
            return this.interRegistry;
        }

        public IMigrationHandler getMigrationHandler() {
            return SiriusModelPlugin.getDefault().getMigrationHandler();
        }

        public void error(String message, Throwable e) {
            this.log(message, e, 4);
        }

        public void warning(String message, Exception e) {
            this.log(message, e, 2);
        }

        public void info(String message, Throwable e) {
            this.log(message, e, 1);
        }

        private void log(String message, Throwable e, int severity) {
            String messageToDisplay = message;
            if (messageToDisplay == null && e != null) {
                messageToDisplay = e.getMessage();
            }
            if (e instanceof CoreException) {
                this.getLog().log(((CoreException)e).getStatus());
            } else {
                Status status = new Status(severity, SiriusPlugin.getDefault().getSymbolicName(), messageToDisplay, e);
                this.getLog().log((IStatus)status);
            }
        }

        public UICallBack getUiCallback() {
            return this.uiCallback;
        }

        public void setUiCallback(UICallBack uiCallback) {
            this.uiCallback = uiCallback;
        }
    }
}

