/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips.grid.internal;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.border.BorderPainter;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.grid.BasicGridLookPainter;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.grid.CellBackgroundProvider;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.grid.DefaultGridLook;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.grid.GridMargins;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.grid.internal.DefaultGridMargins;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.ResourcePool;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class DefaultGridLookPainter
extends BasicGridLookPainter {
    private final Rectangle cellPadding;
    private final BorderPainter border;
    private final CellBackgroundProvider headerBackground;
    private final CellBackgroundProvider bodyBackground;
    private final CellBackgroundProvider footerBackground;
    private final GridMargins margins;
    private final ResourcePool resources;

    public DefaultGridLookPainter(DefaultGridLook look, Device device, GC gc) {
        super(device);
        Point dpi = device.getDPI();
        this.border = look.getCellBorder().createPainter(device, gc);
        this.cellPadding = this.calculateCellPadding(look, dpi);
        this.margins = this.calculateGridMargins(look, dpi);
        this.bodyBackground = look.getBodyBackgroundProvider();
        this.headerBackground = look.getHeaderBackgroundProvider();
        this.footerBackground = look.getFooterBackgroundProvider();
        this.resources = ResourcePool.forDevice(device);
    }

    private Rectangle calculateCellPadding(DefaultGridLook look, Point dpi) {
        Rectangle cellPadding = new Rectangle(look.getCellPadding().x * dpi.x / 72, look.getCellPadding().y * dpi.y / 72, look.getCellPadding().width * dpi.x / 72, look.getCellPadding().height * dpi.y / 72);
        return cellPadding;
    }

    private GridMargins calculateGridMargins(DefaultGridLook look, Point dpi) {
        Point cellSpacing = new Point(this.border.getWidth() + (look.getCellSpacing().x == -1 ? -this.border.getOverlap().x : dpi.x * look.getCellSpacing().x / 72), this.border.getHeight(false, false) + (look.getCellSpacing().y == -1 ? -this.border.getOverlap().y : dpi.y * look.getCellSpacing().y / 72));
        int headerClosedSpacing = this.border.getHeight(false, false) + (look.getHeaderGap() == -1 ? -this.border.getOverlap().y : dpi.y * look.getHeaderGap() / 72);
        int headerOpenSpacing = this.border.getHeight(true, false) + (look.getHeaderGap() == -1 ? dpi.y / 72 : dpi.y * look.getHeaderGap() / 72);
        int footerClosedSpacing = this.border.getHeight(false, false) + (look.getFooterGap() == -1 ? -this.border.getOverlap().y : dpi.y * look.getFooterGap() / 72);
        int footerOpenSpacing = this.border.getHeight(false, true) + (look.getFooterGap() == -1 ? dpi.y / 72 : dpi.y * look.getFooterGap() / 72);
        return new DefaultGridMargins(this.border, cellSpacing, this.cellPadding, headerClosedSpacing, headerOpenSpacing, footerClosedSpacing, footerOpenSpacing);
    }

    @Override
    public GridMargins getMargins() {
        return this.margins;
    }

    @Override
    protected void paintHeaderCell(GC gc, Rectangle bounds, int row, int col, int colspan) {
        RGB background = this.headerBackground.getCellBackground(row, col, colspan);
        this.paintCell(gc, background, bounds, false, false);
    }

    @Override
    protected void paintBodyCell(GC gc, Rectangle bounds, int row, int col, int colspan, boolean topOpen, boolean bottomOpen) {
        RGB background = this.bodyBackground.getCellBackground(row, col, colspan);
        this.paintCell(gc, background, bounds, topOpen, bottomOpen);
    }

    @Override
    protected void paintFooterCell(GC gc, Rectangle bounds, int row, int col, int colspan) {
        RGB background = this.footerBackground.getCellBackground(row, col, colspan);
        this.paintCell(gc, background, bounds, false, false);
    }

    private void paintCell(GC gc, RGB background, Rectangle bounds, boolean topOpen, boolean bottomOpen) {
        int x = bounds.x - this.border.getLeft() - this.cellPadding.x;
        int y = bounds.y - this.border.getTop(topOpen) - (topOpen ? 0 : this.cellPadding.y);
        int width = bounds.width + this.border.getWidth() + this.cellPadding.x + this.cellPadding.width;
        int height = bounds.height + this.border.getHeight(topOpen, bottomOpen) + (bottomOpen ? 0 : this.cellPadding.y + this.cellPadding.height);
        Color backgroundColor = this.resources.getColor(background);
        if (backgroundColor != null) {
            Color oldBackground = gc.getBackground();
            gc.setBackground(backgroundColor);
            gc.fillRectangle(x, y, width, height);
            gc.setBackground(oldBackground);
        }
        this.border.paint(gc, x, y, width, height, topOpen, bottomOpen);
    }

    @Override
    public void dispose() {
        this.border.dispose();
    }
}

