/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.format;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.formatdata.AbstractFormatData;
import org.eclipse.sirius.diagram.formatdata.EdgeFormatData;
import org.eclipse.sirius.diagram.formatdata.FormatdataFactory;
import org.eclipse.sirius.diagram.formatdata.NodeFormatData;
import org.eclipse.sirius.diagram.formatdata.Point;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataHelper;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.AbstractSemanticFormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.SemanticEdgeFormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.SemanticNodeFormatDataKey;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.Style;

public class FormatDataHelperImpl
implements FormatDataHelper {
    private static final Predicate<EObject> ROOT_PREDICATE = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            return input.eContainer() == null;
        }
    };

    @Override
    public NodeFormatData createNodeFormatData(Node node, IGraphicalEditPart editPart, NodeFormatData parentFormatData) {
        NodeFormatData result = FormatdataFactory.eINSTANCE.createNodeFormatData();
        Dimension primarySize = new Dimension(0, 0);
        org.eclipse.draw2d.geometry.Point relativeLocation = editPart.getFigure().getBounds().getLocation().getCopy();
        FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)editPart.getFigure(), (org.eclipse.draw2d.geometry.Point)relativeLocation);
        boolean isCollapsed = false;
        if (new DDiagramElementQuery((DDiagramElement)node.getElement()).isIndirectlyCollapsed()) {
            isCollapsed = true;
        }
        if (isCollapsed) {
            NodeQuery nodeQuery;
            Option<Bounds> option;
            LayoutConstraint formatConstraint = node.getLayoutConstraint();
            if (formatConstraint instanceof Bounds && (option = (nodeQuery = new NodeQuery(node)).getExtendedBounds()).some()) {
                Bounds unCollapseBounds = (Bounds)option.get();
                int deltaX = ((Bounds)formatConstraint).getX() - unCollapseBounds.getX();
                int deltaY = ((Bounds)formatConstraint).getY() - unCollapseBounds.getY();
                relativeLocation.setLocation(relativeLocation.x - deltaX, relativeLocation.y - deltaY);
                primarySize = new Dimension(unCollapseBounds.getWidth(), unCollapseBounds.getHeight());
            }
        } else {
            Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            primarySize = new Dimension(width.intValue(), height.intValue());
            if (width == -1 || height == -1) {
                primarySize = editPart.getFigure().getSize().getCopy();
            }
        }
        if (parentFormatData != null) {
            Point parentAbsoluteLocation = FormatDataHelper.INSTANCE.getAbsoluteLocation(parentFormatData);
            relativeLocation.translate(-parentAbsoluteLocation.getX(), -parentAbsoluteLocation.getY());
        }
        result.setHeight(primarySize.height);
        result.setWidth(primarySize.width);
        Point location = FormatdataFactory.eINSTANCE.createPoint();
        location.setX(relativeLocation.x);
        location.setY(relativeLocation.y);
        result.setLocation(location);
        this.copyViewStyleInFormatData((AbstractFormatData)result, (View)node);
        return result;
    }

    private void copyViewStyleInFormatData(AbstractFormatData formatData, View view) {
        if (view.getElement() instanceof DStylizable) {
            formatData.setSiriusStyle((Style)SiriusCopierHelper.copyWithNoUidDuplication((EObject)((DStylizable)view.getElement()).getStyle()));
        }
        View viewCopy = (View)SiriusCopierHelper.copyAllWithNoUidDuplication(Arrays.asList(view), (boolean)false, (boolean)false, (boolean)false).get(view);
        formatData.setGmfView(viewCopy);
    }

    @Override
    public EdgeFormatData createEdgeFormatData(Edge gmfEdge, ConnectionEditPart connectionEditPart) {
        EdgeFormatData result = FormatdataFactory.eINSTANCE.createEdgeFormatData();
        ConnectorStyle connectorStyle = (ConnectorStyle)gmfEdge.getStyle(NotationPackage.eINSTANCE.getConnectorStyle());
        if (connectorStyle != null) {
            result.setRouting(connectorStyle.getRouting().getValue());
            result.setJumpLinkStatus(connectorStyle.getJumpLinkStatus().getValue());
            result.setJumpLinkType(connectorStyle.getJumpLinkType().getValue());
            result.setReverseJumpLink(connectorStyle.isJumpLinksReverse());
            result.setSmoothness(connectorStyle.getSmoothness().getValue());
        }
        if (connectionEditPart != null) {
            PolylineConnectionEx polylineConnectionEx = (PolylineConnectionEx)connectionEditPart.getFigure();
            polylineConnectionEx.getConnectionRouter().route((Connection)polylineConnectionEx);
            org.eclipse.draw2d.geometry.Point originialSourceRefPoint = polylineConnectionEx.getSourceAnchor().getReferencePoint().getCopy();
            polylineConnectionEx.translateToRelative((Translatable)originialSourceRefPoint);
            result.setSourceRefPoint(this.createPoint(originialSourceRefPoint));
            org.eclipse.draw2d.geometry.Point originialTargetRefPoint = polylineConnectionEx.getTargetAnchor().getReferencePoint().getCopy();
            polylineConnectionEx.translateToRelative((Translatable)originialTargetRefPoint);
            result.setTargetRefPoint(this.createPoint(originialTargetRefPoint));
            this.initPointList((EList<Point>)result.getPointList(), polylineConnectionEx.getPoints().getCopy());
        }
        if (gmfEdge.getSourceAnchor() instanceof IdentityAnchor) {
            result.setSourceTerminal(((IdentityAnchor)gmfEdge.getSourceAnchor()).getId());
        }
        if (gmfEdge.getTargetAnchor() instanceof IdentityAnchor) {
            result.setTargetTerminal(((IdentityAnchor)gmfEdge.getTargetAnchor()).getId());
        }
        this.copyViewStyleInFormatData((AbstractFormatData)result, (View)gmfEdge);
        return result;
    }

    @Override
    public NodeFormatData createLabelFormatData(Node labelNode) {
        NodeFormatData result = FormatdataFactory.eINSTANCE.createNodeFormatData();
        if (labelNode.getLayoutConstraint() instanceof Size) {
            Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)labelNode, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)labelNode, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            result.setWidth(width.intValue());
            result.setHeight(height.intValue());
        }
        Integer x = (Integer)ViewUtil.getStructuralFeatureValue((View)labelNode, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        Integer y = (Integer)ViewUtil.getStructuralFeatureValue((View)labelNode, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point location = FormatdataFactory.eINSTANCE.createPoint();
        location.setX(x.intValue());
        location.setY(y.intValue());
        result.setLocation(location);
        return result;
    }

    @Override
    public Point getAbsoluteLocation(NodeFormatData nodeFormatData) {
        Point result = this.getCopy(nodeFormatData.getLocation());
        if (nodeFormatData.eContainer() instanceof NodeFormatData) {
            result = this.getTranslated(result, this.getAbsoluteLocation((NodeFormatData)nodeFormatData.eContainer()));
        }
        return result;
    }

    @Override
    public Point getRelativeLocation(NodeFormatData formatData, IGraphicalEditPart editPart) {
        Point result = this.getAbsoluteLocation(formatData);
        org.eclipse.draw2d.geometry.Point p = new org.eclipse.draw2d.geometry.Point(result.getX(), result.getY());
        FigureUtilities.translateToRelativeByIgnoringScrollbar((IFigure)editPart.getFigure(), (org.eclipse.draw2d.geometry.Point)p);
        result.setX(p.x);
        result.setY(p.y);
        return result;
    }

    private Point createPoint(org.eclipse.draw2d.geometry.Point draw2dPoint) {
        Point newPoint = FormatdataFactory.eINSTANCE.createPoint();
        newPoint.setX(draw2dPoint.x);
        newPoint.setY(draw2dPoint.y);
        return newPoint;
    }

    private void initPointList(EList<Point> pointList, PointList draw2dPointsList) {
        int i = 0;
        while (i < draw2dPointsList.size()) {
            pointList.add((Object)this.createPoint(draw2dPointsList.getPoint(i)));
            ++i;
        }
    }

    private Point getCopy(Point point) {
        Point copy = FormatdataFactory.eINSTANCE.createPoint();
        copy.setX(point.getX());
        copy.setY(point.getY());
        return copy;
    }

    protected Point getTranslated(Point originalPoint, Point pt) {
        Point translatedPoint = FormatdataFactory.eINSTANCE.createPoint();
        translatedPoint.setX(originalPoint.getX() + pt.getX());
        translatedPoint.setY(originalPoint.getY() + pt.getY());
        return translatedPoint;
    }

    @Override
    public Point getTranslated(Point originalPoint, org.eclipse.draw2d.geometry.Point pt) {
        Point translatedPoint = FormatdataFactory.eINSTANCE.createPoint();
        translatedPoint.setX(originalPoint.getX() + pt.x);
        translatedPoint.setY(originalPoint.getY() + pt.y);
        return translatedPoint;
    }

    @Override
    public Map<? extends FormatDataKey, ? extends AbstractFormatData> getRootFormatData(Map<? extends FormatDataKey, ? extends AbstractFormatData> collection) {
        return Maps.filterValues(collection, ROOT_PREDICATE);
    }

    @Override
    public FormatDataKey createKey(AbstractFormatData formatData) {
        AbstractSemanticFormatDataKey result;
        if (formatData instanceof NodeFormatData) {
            result = new SemanticNodeFormatDataKey(formatData.getId());
        } else if (formatData instanceof EdgeFormatData) {
            result = new SemanticEdgeFormatDataKey(formatData.getId());
        } else {
            throw new IllegalArgumentException(MessageFormat.format(Messages.LayoutDataHelperImpl_unkownLayoutData, formatData.getClass()));
        }
        return result;
    }
}

