/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.junit.ComparisonFailure;

public class CheckBoundsCondition
extends DefaultCondition {
    private boolean checkWidth = true;
    private boolean checkHeight = true;
    private final IGraphicalEditPart editPartToWaitFor;
    private final Rectangle expectedBounds;

    public CheckBoundsCondition(IGraphicalEditPart editPartToWaitFor, Rectangle expectedAbsoluteBounds) {
        this.editPartToWaitFor = editPartToWaitFor;
        this.expectedBounds = expectedAbsoluteBounds;
    }

    public CheckBoundsCondition(IGraphicalEditPart editPartToWaitForSelection, Rectangle expectedAbsoluteBounds, boolean checkWidth, boolean checkHeight) {
        this.editPartToWaitFor = editPartToWaitForSelection;
        this.expectedBounds = expectedAbsoluteBounds;
        this.checkWidth = checkWidth;
        this.checkHeight = checkHeight;
    }

    public boolean test() throws Exception {
        boolean result = false;
        if (this.editPartToWaitFor != null) {
            if (this.checkHeight && this.checkWidth) {
                result = this.getCurrentAbsoluteBounds().equals((Object)this.expectedBounds);
            } else {
                Rectangle currentBounds = this.getCurrentAbsoluteBounds();
                result = this.checkWidth ? currentBounds.width == this.expectedBounds.width : (this.checkHeight ? currentBounds.height == this.expectedBounds.height : true);
                result = result && currentBounds.getLocation().equals((Object)this.expectedBounds.getLocation());
            }
        }
        return result;
    }

    public String getFailureMessage() {
        String result = null;
        result = this.checkHeight && this.checkWidth ? new ComparisonFailure("The expected bounds is not reached.", this.expectedBounds.toString(), this.getCurrentAbsoluteBounds().toString()).getMessage() : (this.checkWidth ? new ComparisonFailure("The expected width is not reached.", Integer.toString(this.expectedBounds.width), Integer.toString(this.getCurrentAbsoluteBounds().width)).getMessage() : (this.checkHeight ? new ComparisonFailure("The expected height is not reached.", Integer.toString(this.expectedBounds.height), Integer.toString(this.getCurrentAbsoluteBounds().height)).getMessage() : new ComparisonFailure("The expected location is not reached.", this.expectedBounds.getLocation().toString(), this.getCurrentAbsoluteBounds().getLocation().toString()).getMessage()));
        return result;
    }

    protected Rectangle getCurrentAbsoluteBounds() {
        Rectangle bounds = this.editPartToWaitFor.getFigure().getBounds().getCopy();
        this.editPartToWaitFor.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }
}

