/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.internal.accessor.ecore;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EMFUtil {
    private static final Map NAME_ATTRIBUTES = new WeakHashMap();
    private static final Map QNAME_ATTRIBUTES = new WeakHashMap();
    public static final String EMPTY_STRING = "";
    public static final char META_CLASS_BEGIN = '<';
    public static final char META_CLASS_END = '>';
    public static final String QUALIFIED_NAME_SEPARATOR = "::";

    public static EAttribute getNameAttribute(EClass eClass) {
        EAttribute nameAttribute = null;
        WeakReference ref = (WeakReference)NAME_ATTRIBUTES.get(eClass);
        if (ref != null) {
            nameAttribute = (EAttribute)ref.get();
        } else {
            EClassifier type;
            EStructuralFeature feature = eClass.getEStructuralFeature("name");
            if (feature != null && feature instanceof EAttribute && (type = feature.getEType()) != null && type.getInstanceClass() == String.class) {
                nameAttribute = (EAttribute)feature;
            }
            NAME_ATTRIBUTES.put(eClass, new WeakReference<EAttribute>(nameAttribute));
        }
        return nameAttribute;
    }

    public static EAttribute getQualifiedNameAttribute(EClass eClass) {
        EAttribute nameAttribute = null;
        WeakReference ref = (WeakReference)QNAME_ATTRIBUTES.get(eClass);
        if (ref != null) {
            nameAttribute = (EAttribute)ref.get();
        } else {
            EStructuralFeature feature = eClass.getEStructuralFeature("qualifiedName");
            if (feature != null && feature instanceof EAttribute && feature.getEType().getInstanceClass() == String.class) {
                nameAttribute = (EAttribute)feature;
            }
            QNAME_ATTRIBUTES.put(eClass, new WeakReference<EAttribute>(nameAttribute));
        }
        return nameAttribute;
    }

    public static String getQualifiedName(EObject eObject, boolean formatted) {
        EAttribute qNameAttribute;
        if (eObject.eIsProxy()) {
            return EMFUtil.getProxyQualifiedName(eObject);
        }
        if (!formatted && (qNameAttribute = EMFUtil.getQualifiedNameAttribute(eObject.eClass())) != null) {
            String qualifiedName = (String)eObject.eGet((EStructuralFeature)qNameAttribute);
            if (qualifiedName != null) {
                return qualifiedName;
            }
            return EMPTY_STRING;
        }
        String prefix = EMPTY_STRING;
        EObject eContainer = eObject.eContainer();
        while (eContainer instanceof EAnnotation) {
            eContainer = eContainer.eContainer();
        }
        if (eContainer != null) {
            prefix = EMFUtil.getQualifiedName(eContainer, formatted);
        }
        String name = EMFUtil.getName(eObject);
        if (formatted && name.equals(EMPTY_STRING)) {
            name = String.valueOf('<') + EMFUtil.getLocalizedName((ENamedElement)eObject.eClass()) + '>';
        }
        return prefix.length() == 0 ? name : String.valueOf(prefix) + (name.equals(EMPTY_STRING) ? EMPTY_STRING : QUALIFIED_NAME_SEPARATOR + name);
    }

    private static String getProxyQualifiedName(EObject proxy) {
        String result = EMPTY_STRING;
        return result;
    }

    public static String getLocalizedName(ENamedElement element) {
        return element.getName();
    }

    public static String getName(EObject eObject) {
        String name;
        if (eObject == null) {
            return EMPTY_STRING;
        }
        if (eObject.eIsProxy()) {
            return EMFUtil.getProxyName(eObject);
        }
        EAttribute nameAttribute = EMFUtil.getNameAttribute(eObject.eClass());
        if (nameAttribute != null && (name = (String)eObject.eGet((EStructuralFeature)nameAttribute)) != null) {
            return name;
        }
        return EMPTY_STRING;
    }

    private static String getProxyName(EObject proxy) {
        String result = EMPTY_STRING;
        return result;
    }

    public static <T extends EObject> Stream<T> getTreeStream(T root, final Function<T, Iterable<T>> childrenFunc) {
        AbstractTreeIterator iterator = new AbstractTreeIterator<T>(root, false){
            private static final long serialVersionUID = 1L;

            public Iterator<T> getChildren(Object parent) {
                return ((Iterable)childrenFunc.apply((EObject)parent)).iterator();
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }
}

