/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFLabelDescription;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.controllers.IEEFLabelController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFLabelController
extends AbstractEEFWidgetController
implements IEEFLabelController {
    private final EEFLabelDescription description;
    private Consumer<String> newValueConsumer;

    public EEFLabelController(EEFLabelDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    public void refresh() {
        super.refresh();
        String valueExpression = this.description.getValueExpression();
        Object valueExpressionResult = this.newEval().evaluate(valueExpression);
        String displayExpression = this.description.getDisplayExpression();
        Optional.ofNullable(this.newValueConsumer).ifPresent(consumer -> {
            if (!Util.isBlank((String)displayExpression)) {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.putAll(this.variableManager.getVariables());
                variables.put("value", valueExpressionResult);
                EvalFactory.of(this.interpreter, variables).logIfInvalidType(String.class).call(displayExpression, (Consumer<String>)consumer);
            } else if (valueExpressionResult != null) {
                this.newValueConsumer.accept(valueExpressionResult.toString());
            }
        });
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }

    @Override
    public void onNewValue(Consumer<String> consumer) {
        this.newValueConsumer = consumer;
    }

    @Override
    public void removeNewValueConsumer() {
        this.newValueConsumer = null;
    }

    @Override
    public IStatus action(EEFWidgetAction action) {
        return this.editingContextAdapter.performModelChange(() -> {
            String expression = action.getActionExpression();
            EAttribute eAttribute = EefPackage.Literals.EEF_WIDGET_ACTION__ACTION_EXPRESSION;
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.putAll(this.variableManager.getVariables());
            EvalFactory.of(this.interpreter, variables).logIfBlank(eAttribute).call(expression);
        });
    }
}

