/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.api.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.ui.business.api.helper.TableUIHelper;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.tests.support.api.SiriusDiagramTestCase;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.ui.business.api.helper.TreeUIHelper;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;

public class RefreshWhenSeveralEditorsOpenTest
extends SiriusDiagramTestCase {
    private static final String SEMANTIC_MODEL_PATH = "/org.eclipse.sirius.tests.junit/data/unit/refresh/refreshWhenSeveralEdiorsOpen/My.ecore";
    private static final String MODELER_PATH = "/org.eclipse.sirius.tests.junit/data/unit/refresh/refreshWhenSeveralEdiorsOpen/EcoreExtension.odesign";
    private static final String SESSION_PATH = "/org.eclipse.sirius.tests.junit/data/unit/refresh/refreshWhenSeveralEdiorsOpen/My.aird";
    private static final String VIEWPOINT_NAME = "Design";
    private static final String VIEWPOINT_NAME_EXTENSION = "EcoreForResfreshTest";
    private static final String REPRESENTATION_DESC_NAME_TREE = "Tree";
    private static final String REPRESENTATION_DESC_NAME_ENTITIES = "Entities";
    private static final String REPRESENTATION_DESC_NAME_CLASSES = "Classes";
    private static final String PACKAGE_12 = "new Package 12";
    private static final String PACKAGE_12A = "new Package 12A";
    private static final String ECLASS_12 = "new EClass 12";
    private static final String ECLASS_12A = "new EClass 12A";
    private static final String ECLASS_3 = "new EClass 3";
    private DDiagram diagramAnotherRootpackage;
    private DDiagram diagramPackage;
    private DDiagram diagramRootPackage;
    private DTable tableInNewPackage;
    private DTable tableRootPackage;
    private DTree tree;
    private IEditorPart editorPackage2Classes;
    private IEditorPart editorRootClasses;
    private IEditorPart editorRootTree;

    protected void setUp() throws Exception {
        super.setUp();
        this.genericSetUp(SEMANTIC_MODEL_PATH, MODELER_PATH, SESSION_PATH);
        this.initViewpoint(VIEWPOINT_NAME);
        this.initViewpoint(VIEWPOINT_NAME_EXTENSION);
        this.getDiagram();
        this.getTable();
        this.tree = (DTree)this.getRepresentations(REPRESENTATION_DESC_NAME_TREE).toArray()[0];
    }

    public void testInitialisation() {
        this.openedAllEditors();
        AbstractDTableEditor dTableEditorPackage2 = (AbstractDTableEditor)this.editorPackage2Classes;
        Tree treeTablePackage2 = dTableEditorPackage2.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTablePackage2 = TableUIHelper.toContentHTMl((Tree)treeTablePackage2);
        String expectedHtmlTablePackage2 = this.getExpectedTablePackage2();
        Assert.assertEquals((String)"The table doesn't correspond to attempt", (Object)expectedHtmlTablePackage2, (Object)currentHtmlTablePackage2);
        AbstractDTableEditor dTableEditorRoot = (AbstractDTableEditor)this.editorRootClasses;
        Tree treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTableRoot = TableUIHelper.toContentHTMl((Tree)treeTableRoot);
        String expectedHtmlTableRoot = this.getExpectedTableRoot();
        Assert.assertEquals((String)"The table doesn't correspond to attempt", (Object)expectedHtmlTableRoot, (Object)currentHtmlTableRoot);
        AbstractDTreeEditor dTreeEditor = (AbstractDTreeEditor)this.editorRootTree;
        Tree treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTreeRoot = TreeUIHelper.toContentHTMl((Tree)treeTreeRoot);
        String expectedHtmlTreeRoot = this.getExpectedTree();
        Assert.assertEquals((String)"The tree doesn't correspond to attempt", (Object)expectedHtmlTreeRoot, (Object)currentHtmlTreeRoot);
        List<String> currentAnotherRootPackage = this.getElementsDiagrams(this.diagramAnotherRootpackage);
        List<String> expectedAnotherRootPackage = this.getExpectedAnotherRootPackage();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);
        List<String> currentNewPackageEntities = this.getElementsDiagrams(this.diagramPackage);
        List<String> expectedNewPackageEntities = this.getExpectedNewPackageEntities();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);
        List<String> currentRootPackageEntities = this.getElementsDiagrams(this.diagramRootPackage);
        List<String> expectedRootPackageEntities = this.getExpectedRootPackage();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
    }

    public void testRenamePackageOnDiagram() {
        this.changeSiriusPreference(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), true);
        this.openedAllEditors();
        Assert.assertEquals((String)"The semantic model is not correct", (Object)true, (Object)this.isSemanticModelUpdated(PACKAGE_12, ""));
        DNodeContainer diagramPackageToRename = this.getPackageElementInDiagram(this.diagramAnotherRootpackage, PACKAGE_12);
        this.applyNodeCreationTool("Rename+A", this.diagramAnotherRootpackage, (EObject)diagramPackageToRename);
        TestsUtil.synchronizationWithUIThread();
        Assert.assertNotNull((Object)this.getPackageElementInDiagram(this.diagramAnotherRootpackage, PACKAGE_12A));
        Assert.assertEquals((String)"The semantic model is not correct", (Object)true, (Object)this.isSemanticModelUpdated(PACKAGE_12A, ""));
        AbstractDTableEditor dTableEditorRoot = (AbstractDTableEditor)this.editorRootClasses;
        Tree treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTableRoot = TableUIHelper.toContentHTMl((Tree)treeTableRoot);
        String expectedHtmlTableRoot = this.getExpectedTableRootAfterRenamePackage();
        Assert.assertEquals((String)"The table doesn't correspond to attempt", (Object)expectedHtmlTableRoot, (Object)currentHtmlTableRoot);
        AbstractDTreeEditor dTreeEditor = (AbstractDTreeEditor)this.editorRootTree;
        Tree treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTreeRoot = TreeUIHelper.toContentHTMl((Tree)treeTreeRoot);
        String expectedHtmlTreeRoot = this.getExpectedTreeAfterRenamePackage();
        Assert.assertEquals((String)"The tree doesn't correspond to attempt", (Object)expectedHtmlTreeRoot, (Object)currentHtmlTreeRoot);
        List<String> currentAnotherRootPackage = this.getElementsDiagrams(this.diagramAnotherRootpackage);
        List<String> expectedAnotherRootPackage = this.getExpectedAnotherRootPackageAfterRenamePackage();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);
        List<String> currentNewPackageEntities = this.getElementsDiagrams(this.diagramPackage);
        List<String> expectedNewPackageEntities = this.getExpectedNewPackageEntities();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);
        List<String> currentRootPackageEntities = this.getElementsDiagrams(this.diagramRootPackage);
        List<String> expectedRootPackageEntities = this.getExpectedRootPackageAfterRenamePackage();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
        try {
            this.undo();
        }
        catch (Exception exception) {
            Assert.fail();
        }
        TestsUtil.synchronizationWithUIThread();
        Assert.assertEquals((String)"The semantic model is not correct", (Object)true, (Object)this.isSemanticModelUpdated(PACKAGE_12, ""));
        dTableEditorRoot = (AbstractDTableEditor)this.editorRootClasses;
        treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        currentHtmlTableRoot = TableUIHelper.toContentHTMl((Tree)treeTableRoot);
        expectedHtmlTableRoot = this.getExpectedTableRoot();
        Assert.assertEquals((String)"The table doesn't correspond to attempt", (Object)expectedHtmlTableRoot, (Object)currentHtmlTableRoot);
        dTreeEditor = (AbstractDTreeEditor)this.editorRootTree;
        treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        currentHtmlTreeRoot = TreeUIHelper.toContentHTMl((Tree)treeTreeRoot);
        expectedHtmlTreeRoot = this.getExpectedTree();
        Assert.assertEquals((String)"The tree doesn't correspond to attempt", (Object)expectedHtmlTreeRoot, (Object)currentHtmlTreeRoot);
        currentAnotherRootPackage = this.getElementsDiagrams(this.diagramAnotherRootpackage);
        expectedAnotherRootPackage = this.getExpectedAnotherRootPackage();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);
        currentNewPackageEntities = this.getElementsDiagrams(this.diagramPackage);
        expectedNewPackageEntities = this.getExpectedNewPackageEntities();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);
        currentRootPackageEntities = this.getElementsDiagrams(this.diagramRootPackage);
        expectedRootPackageEntities = this.getExpectedRootPackage();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
        try {
            this.redo();
        }
        catch (Exception exception) {
            Assert.fail();
        }
        TestsUtil.synchronizationWithUIThread();
        Assert.assertEquals((String)"The semantic model is not correct", (Object)true, (Object)this.isSemanticModelUpdated(PACKAGE_12A, ""));
        dTableEditorRoot = (AbstractDTableEditor)this.editorRootClasses;
        treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        currentHtmlTableRoot = TableUIHelper.toContentHTMl((Tree)treeTableRoot);
        expectedHtmlTableRoot = this.getExpectedTableRootAfterRenamePackage();
        Assert.assertEquals((String)"The table doesn't correspond to attempt", (Object)expectedHtmlTableRoot, (Object)currentHtmlTableRoot);
        dTreeEditor = (AbstractDTreeEditor)this.editorRootTree;
        treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        currentHtmlTreeRoot = TreeUIHelper.toContentHTMl((Tree)treeTreeRoot);
        expectedHtmlTreeRoot = this.getExpectedTreeAfterRenamePackage();
        Assert.assertEquals((String)"The tree doesn't correspond to attempt", (Object)expectedHtmlTreeRoot, (Object)currentHtmlTreeRoot);
        currentAnotherRootPackage = this.getElementsDiagrams(this.diagramAnotherRootpackage);
        expectedAnotherRootPackage = this.getExpectedAnotherRootPackageAfterRenamePackage();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);
        currentNewPackageEntities = this.getElementsDiagrams(this.diagramPackage);
        expectedNewPackageEntities = this.getExpectedNewPackageEntities();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);
        currentRootPackageEntities = this.getElementsDiagrams(this.diagramRootPackage);
        expectedRootPackageEntities = this.getExpectedRootPackageAfterRenamePackage();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
    }

    public void testRenameClassOnDiagram() {
        this.changeSiriusPreference(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), true);
        this.openedAllEditors();
        Assert.assertEquals((String)"The semantic model is not correct", (Object)true, (Object)this.isSemanticModelUpdated(PACKAGE_12, ECLASS_12));
        DNodeList diagramClassToRename = this.getClassElementInDiagram(this.diagramAnotherRootpackage, ECLASS_12);
        this.applyNodeCreationTool("Rename+A", this.diagramAnotherRootpackage, (EObject)diagramClassToRename);
        TestsUtil.synchronizationWithUIThread();
        Assert.assertNotNull((Object)this.getClassElementInDiagram(this.diagramAnotherRootpackage, ECLASS_12A));
        Assert.assertEquals((String)"The semantic model is not correct", (Object)true, (Object)this.isSemanticModelUpdated(PACKAGE_12, ECLASS_12A));
        AbstractDTableEditor dTableEditorRoot = (AbstractDTableEditor)this.editorRootClasses;
        Tree treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTableRoot = TableUIHelper.toContentHTMl((Tree)treeTableRoot);
        String expectedHtmlTableRoot = this.getExpectedTableRootAfterRenameClass();
        Assert.assertEquals((String)"The table doesn't correspond to attempt", (Object)expectedHtmlTableRoot, (Object)currentHtmlTableRoot);
        AbstractDTreeEditor dTreeEditor = (AbstractDTreeEditor)this.editorRootTree;
        Tree treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTreeRoot = TreeUIHelper.toContentHTMl((Tree)treeTreeRoot);
        String expectedHtmlTreeRoot = this.getExpectedTreeAfterRenameClass();
        Assert.assertEquals((String)"The tree doesn't correspond to attempt", (Object)expectedHtmlTreeRoot, (Object)currentHtmlTreeRoot);
        List<String> currentAnotherRootPackage = this.getElementsDiagrams(this.diagramAnotherRootpackage);
        List<String> expectedAnotherRootPackage = this.getExpectedAnotherRootPackageAfterRenameClass();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);
        List<String> currentNewPackageEntities = this.getElementsDiagrams(this.diagramPackage);
        List<String> expectedNewPackageEntities = this.getExpectedNewPackageEntitiesAfterRenameClass();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);
        List<String> currentRootPackageEntities = this.getElementsDiagrams(this.diagramRootPackage);
        List<String> expectedRootPackageEntities = this.getExpectedRootPackageAfterRenameClass();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
        try {
            this.undo();
        }
        catch (Exception exception) {
            Assert.fail();
        }
        TestsUtil.synchronizationWithUIThread();
        Assert.assertEquals((String)"The semantic model is not correct", (Object)true, (Object)this.isSemanticModelUpdated(PACKAGE_12, ECLASS_12));
        dTableEditorRoot = (AbstractDTableEditor)this.editorRootClasses;
        treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        currentHtmlTableRoot = TableUIHelper.toContentHTMl((Tree)treeTableRoot);
        expectedHtmlTableRoot = this.getExpectedTableRoot();
        Assert.assertEquals((String)"The table doesn't correspond to attempt", (Object)expectedHtmlTableRoot, (Object)currentHtmlTableRoot);
        dTreeEditor = (AbstractDTreeEditor)this.editorRootTree;
        treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        currentHtmlTreeRoot = TreeUIHelper.toContentHTMl((Tree)treeTreeRoot);
        expectedHtmlTreeRoot = this.getExpectedTree();
        Assert.assertEquals((String)"The tree doesn't correspond to attempt", (Object)expectedHtmlTreeRoot, (Object)currentHtmlTreeRoot);
        currentAnotherRootPackage = this.getElementsDiagrams(this.diagramAnotherRootpackage);
        expectedAnotherRootPackage = this.getExpectedAnotherRootPackage();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);
        currentNewPackageEntities = this.getElementsDiagrams(this.diagramPackage);
        expectedNewPackageEntities = this.getExpectedNewPackageEntities();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);
        currentRootPackageEntities = this.getElementsDiagrams(this.diagramRootPackage);
        expectedRootPackageEntities = this.getExpectedRootPackage();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
        try {
            this.redo();
        }
        catch (Exception exception) {
            Assert.fail();
        }
        TestsUtil.synchronizationWithUIThread();
        Assert.assertEquals((String)"The semantic model is not correct", (Object)true, (Object)this.isSemanticModelUpdated(PACKAGE_12, ECLASS_12A));
        dTableEditorRoot = (AbstractDTableEditor)this.editorRootClasses;
        treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        currentHtmlTableRoot = TableUIHelper.toContentHTMl((Tree)treeTableRoot);
        expectedHtmlTableRoot = this.getExpectedTableRootAfterRenameClass();
        Assert.assertEquals((String)"The table doesn't correspond to attempt", (Object)expectedHtmlTableRoot, (Object)currentHtmlTableRoot);
        dTreeEditor = (AbstractDTreeEditor)this.editorRootTree;
        treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        currentHtmlTreeRoot = TreeUIHelper.toContentHTMl((Tree)treeTreeRoot);
        expectedHtmlTreeRoot = this.getExpectedTreeAfterRenameClass();
        Assert.assertEquals((String)"The tree doesn't correspond to attempt", (Object)expectedHtmlTreeRoot, (Object)currentHtmlTreeRoot);
        currentAnotherRootPackage = this.getElementsDiagrams(this.diagramAnotherRootpackage);
        expectedAnotherRootPackage = this.getExpectedAnotherRootPackageAfterRenameClass();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);
        currentNewPackageEntities = this.getElementsDiagrams(this.diagramPackage);
        expectedNewPackageEntities = this.getExpectedNewPackageEntitiesAfterRenameClass();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);
        currentRootPackageEntities = this.getElementsDiagrams(this.diagramRootPackage);
        expectedRootPackageEntities = this.getExpectedRootPackageAfterRenameClass();
        Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
    }

    public void testAddClassOnDiagram() {
        this.changeSiriusPreference(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), true);
        DslCommonPlugin.PROFILER.setActive(true);
        try {
            DslCommonPlugin.PROFILER.init();
            this.openedAllEditors();
            int refreshDiagramNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_DIAGRAM_KEY);
            int refreshTableNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TABLE_KEY);
            int refreshTreeNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TREE_KEY);
            Assert.assertEquals((String)"Number of diagram refresh is inconrrect", (long)3L, (long)refreshDiagramNumberCount);
            Assert.assertEquals((String)"Number of table refresh is inconrrect", (long)2L, (long)refreshTableNumberCount);
            Assert.assertEquals((String)"Number of tree refresh is inconrrect", (long)1L, (long)refreshTreeNumberCount);
            Assert.assertEquals((String)"The semantic model is not correct", (Object)false, (Object)this.isSemanticModelUpdated(PACKAGE_12, ECLASS_3));
            DslCommonPlugin.PROFILER.init();
            DNodeContainer diagramPackageToAddClass = this.getPackageElementInDiagram(this.diagramAnotherRootpackage, PACKAGE_12);
            this.applyNodeCreationTool("Class", this.diagramAnotherRootpackage, (EObject)diagramPackageToAddClass);
            TestsUtil.synchronizationWithUIThread();
            refreshDiagramNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_DIAGRAM_KEY);
            refreshTableNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TABLE_KEY);
            refreshTreeNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TREE_KEY);
            Assert.assertEquals((String)"Number of diagram refresh is incorrect", (long)3L, (long)refreshDiagramNumberCount);
            Assert.assertEquals((String)"Number of table refresh is incorrect", (long)2L, (long)refreshTableNumberCount);
            Assert.assertEquals((String)"Number of tree refresh is incorrect", (long)1L, (long)refreshTreeNumberCount);
            Assert.assertEquals((String)"The semantic model is not correct", (Object)true, (Object)this.isSemanticModelUpdated(PACKAGE_12, "NewEClass3"));
            AbstractDTableEditor dTableEditorRoot = (AbstractDTableEditor)this.editorRootClasses;
            Tree treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
            String currentHtmlTableRoot = TableUIHelper.toContentHTMl((Tree)treeTableRoot);
            String expectedHtmlTableRoot = this.getExpectedTableRootAfterAddClass();
            Assert.assertEquals((String)"The table doesn't correspond to attempt", (Object)expectedHtmlTableRoot, (Object)currentHtmlTableRoot);
            AbstractDTreeEditor dTreeEditor = (AbstractDTreeEditor)this.editorRootTree;
            Tree treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
            String currentHtmlTreeRoot = TreeUIHelper.toContentHTMl((Tree)treeTreeRoot);
            String expectedHtmlTreeRoot = this.getExpectedTreeAfterAddClass();
            Assert.assertEquals((String)"The tree doesn't correspond to attempt", (Object)expectedHtmlTreeRoot, (Object)currentHtmlTreeRoot);
            List<String> currentAnotherRootPackage = this.getElementsDiagrams(this.diagramAnotherRootpackage);
            List<String> expectedAnotherRootPackage = this.getExpectedAnotherRootPackageAfterAddClass();
            Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);
            List<String> currentNewPackageEntities = this.getElementsDiagrams(this.diagramPackage);
            List<String> expectedNewPackageEntities = this.getExpectedNewPackageEntitiesAfterAddClass();
            Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);
            List<String> currentRootPackageEntities = this.getElementsDiagrams(this.diagramRootPackage);
            List<String> expectedRootPackageEntities = this.getExpectedRootPackageAfterAddClass();
            Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
            DslCommonPlugin.PROFILER.init();
            try {
                this.undo();
            }
            catch (Exception exception) {
                Assert.fail();
            }
            refreshDiagramNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_DIAGRAM_KEY);
            refreshTableNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TABLE_KEY);
            refreshTreeNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TREE_KEY);
            Assert.assertEquals((String)"Number of diagram refresh is inconrrect", (long)0L, (long)refreshDiagramNumberCount);
            Assert.assertEquals((String)"Number of table refresh is inconrrect", (long)0L, (long)refreshTableNumberCount);
            Assert.assertEquals((String)"Number of tree refresh is inconrrect", (long)0L, (long)refreshTreeNumberCount);
            TestsUtil.synchronizationWithUIThread();
            Assert.assertEquals((String)"The semantic model is not correct", (Object)false, (Object)this.isSemanticModelUpdated(PACKAGE_12, "NewEClass3"));
            currentAnotherRootPackage = this.getElementsDiagrams(this.diagramAnotherRootpackage);
            expectedAnotherRootPackage = this.getExpectedAnotherRootPackage();
            Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);
            dTableEditorRoot = (AbstractDTableEditor)this.editorRootClasses;
            treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
            currentHtmlTableRoot = TableUIHelper.toContentHTMl((Tree)treeTableRoot);
            expectedHtmlTableRoot = this.getExpectedTableRoot();
            Assert.assertEquals((String)"The table doesn't correspond to attempt", (Object)expectedHtmlTableRoot, (Object)currentHtmlTableRoot);
            dTreeEditor = (AbstractDTreeEditor)this.editorRootTree;
            treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
            currentHtmlTreeRoot = TreeUIHelper.toContentHTMl((Tree)treeTreeRoot);
            expectedHtmlTreeRoot = this.getExpectedTree();
            Assert.assertEquals((String)"The tree doesn't correspond to attempt", (Object)expectedHtmlTreeRoot, (Object)currentHtmlTreeRoot);
            currentAnotherRootPackage = this.getElementsDiagrams(this.diagramAnotherRootpackage);
            expectedAnotherRootPackage = this.getExpectedAnotherRootPackage();
            Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);
            currentNewPackageEntities = this.getElementsDiagrams(this.diagramPackage);
            expectedNewPackageEntities = this.getExpectedNewPackageEntities();
            Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);
            currentRootPackageEntities = this.getElementsDiagrams(this.diagramRootPackage);
            expectedRootPackageEntities = this.getExpectedRootPackage();
            Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
            DslCommonPlugin.PROFILER.init();
            try {
                this.redo();
            }
            catch (Exception exception) {
                Assert.fail();
            }
            refreshDiagramNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_DIAGRAM_KEY);
            refreshTableNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TABLE_KEY);
            refreshTreeNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TREE_KEY);
            Assert.assertEquals((String)"Number of diagram refresh is inconrrect", (long)0L, (long)refreshDiagramNumberCount);
            Assert.assertEquals((String)"Number of table refresh is inconrrect", (long)0L, (long)refreshTableNumberCount);
            Assert.assertEquals((String)"Number of tree refresh is inconrrect", (long)0L, (long)refreshTreeNumberCount);
            TestsUtil.synchronizationWithUIThread();
            Assert.assertEquals((String)"The semantic model is not correct", (Object)true, (Object)this.isSemanticModelUpdated(PACKAGE_12, "NewEClass3"));
            dTableEditorRoot = (AbstractDTableEditor)this.editorRootClasses;
            treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
            currentHtmlTableRoot = TableUIHelper.toContentHTMl((Tree)treeTableRoot);
            expectedHtmlTableRoot = this.getExpectedTableRootAfterAddClass();
            Assert.assertEquals((String)"The table doesn't correspond to attempt", (Object)expectedHtmlTableRoot, (Object)currentHtmlTableRoot);
            dTreeEditor = (AbstractDTreeEditor)this.editorRootTree;
            treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
            currentHtmlTreeRoot = TreeUIHelper.toContentHTMl((Tree)treeTreeRoot);
            expectedHtmlTreeRoot = this.getExpectedTreeAfterAddClass();
            Assert.assertEquals((String)"The tree doesn't correspond to attempt", (Object)expectedHtmlTreeRoot, (Object)currentHtmlTreeRoot);
            currentAnotherRootPackage = this.getElementsDiagrams(this.diagramAnotherRootpackage);
            expectedAnotherRootPackage = this.getExpectedAnotherRootPackageAfterAddClass();
            Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);
            currentNewPackageEntities = this.getElementsDiagrams(this.diagramPackage);
            expectedNewPackageEntities = this.getExpectedNewPackageEntitiesAfterAddClass();
            Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);
            currentRootPackageEntities = this.getElementsDiagrams(this.diagramRootPackage);
            expectedRootPackageEntities = this.getExpectedRootPackageAfterAddClass();
            Assert.assertEquals((String)"The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
        }
        finally {
            DslCommonPlugin.PROFILER.setActive(false);
        }
    }

    public void testEditorRename() {
        this.openedAllEditors();
        String originalTitle = this.editorRootClasses.getTitle();
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                new DRepresentationQuery((DRepresentation)RefreshWhenSeveralEditorsOpenTest.this.tableRootPackage).getRepresentationDescriptor().setName("new name");
            }
        });
        TestsUtil.synchronizationWithUIThread();
        String newTitle = this.editorRootClasses.getTitle();
        Assert.assertFalse((boolean)originalTitle.equals(newTitle));
        Assert.assertTrue((boolean)newTitle.contains("new name"));
        Assert.assertEquals((String)"Editor name is not correct", (Object)"Classes in new Package 2 package", (Object)this.editorPackage2Classes.getTitle());
        Assert.assertEquals((String)"Editor name is not correct", (Object)"new Tree", (Object)this.editorRootTree.getTitle());
    }

    private DNodeContainer getPackageElementInDiagram(DDiagram diagram, String packageName) {
        for (DDiagramElement diagramElement : diagram.getOwnedDiagramElements()) {
            if (!(diagramElement instanceof DNodeContainer) || !packageName.equals(diagramElement.getName())) continue;
            return (DNodeContainer)diagramElement;
        }
        return null;
    }

    private DNodeList getClassElementInDiagram(DDiagram diagram, String className) {
        for (DDiagramElement diagramElement : diagram.getOwnedDiagramElements()) {
            if (!(diagramElement instanceof DNodeContainer)) continue;
            for (DDiagramElement nodeListSpec : ((DNodeContainer)diagramElement).getOwnedDiagramElements()) {
                if (!(nodeListSpec instanceof DNodeList) || !className.equals(nodeListSpec.getName())) continue;
                return (DNodeList)nodeListSpec;
            }
        }
        return null;
    }

    private void getDiagram() {
        Collection representations = this.getRepresentationDescriptors(REPRESENTATION_DESC_NAME_ENTITIES);
        for (DRepresentationDescriptor representationDescriptor : representations) {
            if (!(representationDescriptor.getRepresentation() instanceof DDiagram)) continue;
            if ("another root package entities".equals(representationDescriptor.getName())) {
                this.diagramAnotherRootpackage = (DDiagram)representationDescriptor.getRepresentation();
                continue;
            }
            if ("new Package 1 package entities".equals(representationDescriptor.getName())) {
                this.diagramPackage = (DDiagram)representationDescriptor.getRepresentation();
                continue;
            }
            if (!"root package entities".equals(representationDescriptor.getName())) continue;
            this.diagramRootPackage = (DDiagram)representationDescriptor.getRepresentation();
        }
    }

    private void getTable() {
        Collection representations = this.getRepresentationDescriptors(REPRESENTATION_DESC_NAME_CLASSES);
        for (DRepresentationDescriptor representationDescriptor : representations) {
            if (!(representationDescriptor.getRepresentation() instanceof DTable)) continue;
            if ("Classes in new Package 2 package".equals(representationDescriptor.getName())) {
                this.tableInNewPackage = (DTable)representationDescriptor.getRepresentation();
                continue;
            }
            if (!"Classes in root package".equals(representationDescriptor.getName())) continue;
            this.tableRootPackage = (DTable)representationDescriptor.getRepresentation();
        }
    }

    private List<String> getElementsDiagrams(DDiagram diagram) {
        EList allDiagramElements = diagram.getOwnedDiagramElements();
        ArrayList<String> allElementsInDiagram = new ArrayList<String>();
        for (DDiagramElement nodeContainer : allDiagramElements) {
            if (nodeContainer instanceof DNodeContainer) {
                allElementsInDiagram.add("Package : " + nodeContainer);
                EList allClassesInDiagram = ((DNodeContainer)nodeContainer).getOwnedDiagramElements();
                for (DDiagramElement nodeListSpec : allClassesInDiagram) {
                    if (!(nodeListSpec instanceof DNodeList)) continue;
                    allElementsInDiagram.add("Class : " + nodeListSpec.getName());
                    EList allAttributsInDiagram = ((DNodeList)nodeListSpec).getOwnedElements();
                    for (DNodeListElement nodeListElement : allAttributsInDiagram) {
                        if (!(nodeListElement instanceof DNodeListElement)) continue;
                        allElementsInDiagram.add("Attribute : " + nodeListElement.getName());
                    }
                }
                continue;
            }
            if (!(nodeContainer instanceof DNodeList)) continue;
            allElementsInDiagram.add("Class : " + nodeContainer.getName());
            EList allAttributsInDiagram = ((DNodeList)nodeContainer).getOwnedElements();
            for (DNodeListElement nodeListElement : allAttributsInDiagram) {
                if (!(nodeListElement instanceof DNodeListElement)) continue;
                allElementsInDiagram.add("Attribute : " + nodeListElement.getName());
            }
        }
        return allElementsInDiagram;
    }

    private void openedAllEditors() {
        DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.diagramPackage, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        this.editorPackage2Classes = DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.tableInNewPackage, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        this.editorRootClasses = DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.tableRootPackage, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.diagramAnotherRootpackage, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        this.editorRootTree = DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.tree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.diagramRootPackage, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
    }

    private boolean isSemanticModelUpdated(String packageToFind, String classToFind) {
        EPackage ePackageRoot = (EPackage)this.semanticModel;
        EList packages = ePackageRoot.getESubpackages();
        for (EPackage pack : packages) {
            if (!pack.getName().equals(packageToFind)) continue;
            if (classToFind == "") {
                return true;
            }
            EClass classFind = (EClass)pack.getEClassifier(classToFind);
            if (classFind == null) continue;
            return true;
        }
        return false;
    }

    private String getExpectedTablePackage2() {
        ArrayList expected = new ArrayList();
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"", "Name"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 2", "new EClass 2"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{ECLASS_3, ECLASS_3});
        return TableUIHelper.toHTML(expected);
    }

    private String getExpectedTableRoot() {
        ArrayList expected = new ArrayList();
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"", "Name"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{PACKAGE_12, PACKAGE_12});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{ECLASS_12, ECLASS_12});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"attribut1", "attribut1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 2A", "new EClass 2A"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 2", "new Package 2"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 2", "new EClass 2"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{ECLASS_3, ECLASS_3});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 3", "new Package 3"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 4", "new Package 4"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        return TableUIHelper.toHTML(expected);
    }

    private String getExpectedTableRootAfterRenamePackage() {
        ArrayList expected = new ArrayList();
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"", "Name"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{PACKAGE_12A, PACKAGE_12A});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{ECLASS_12, ECLASS_12});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"attribut1", "attribut1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 2A", "new EClass 2A"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 2", "new Package 2"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 2", "new EClass 2"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{ECLASS_3, ECLASS_3});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 3", "new Package 3"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 4", "new Package 4"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        return TableUIHelper.toHTML(expected);
    }

    private String getExpectedTableRootAfterRenameClass() {
        ArrayList expected = new ArrayList();
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"", "Name"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{PACKAGE_12, PACKAGE_12});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{ECLASS_12A, ECLASS_12A});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"attribut1", "attribut1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 2A", "new EClass 2A"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 2", "new Package 2"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 2", "new EClass 2"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{ECLASS_3, ECLASS_3});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 3", "new Package 3"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 4", "new Package 4"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        return TableUIHelper.toHTML(expected);
    }

    private String getExpectedTableRootAfterAddClass() {
        ArrayList expected = new ArrayList();
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"", "Name"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{PACKAGE_12, PACKAGE_12});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{ECLASS_12, ECLASS_12});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"attribut1", "attribut1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 2A", "new EClass 2A"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"NewEClass3", "NewEClass3"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 2", "new Package 2"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 2", "new EClass 2"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{ECLASS_3, ECLASS_3});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 3", "new Package 3"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new Package 4", "new Package 4"});
        TableUIHelper.addLineToTable(expected, (String[])new String[]{"new EClass 1", "new EClass 1"});
        return TableUIHelper.toHTML(expected);
    }

    private String getExpectedTree() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(PACKAGE_12));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(ECLASS_12));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("attribut1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 2A"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(ECLASS_3));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 4"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        return TreeUIHelper.toHTML(expected);
    }

    private String getExpectedTreeAfterRenamePackage() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(PACKAGE_12A));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(ECLASS_12));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("attribut1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 2A"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(ECLASS_3));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 4"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        return TreeUIHelper.toHTML(expected);
    }

    private String getExpectedTreeAfterRenameClass() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(PACKAGE_12));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(ECLASS_12A));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("attribut1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 2A"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(ECLASS_3));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 4"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        return TreeUIHelper.toHTML(expected);
    }

    private String getExpectedTreeAfterAddClass() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(PACKAGE_12));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(ECLASS_12));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("attribut1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 2A"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(ECLASS_3));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new Package 4"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("new EClass 1"));
        return TreeUIHelper.toHTML(expected);
    }

    private List<String> getExpectedAnotherRootPackage() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Package : new Package 12");
        expected.add("Class : new EClass 12");
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : new EClass 3");
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedAnotherRootPackageAfterRenamePackage() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Package : new Package 12A");
        expected.add("Class : new EClass 12");
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : new EClass 3");
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedAnotherRootPackageAfterRenameClass() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Package : new Package 12");
        expected.add("Class : new EClass 12A");
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : new EClass 3");
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedAnotherRootPackageAfterAddClass() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Package : new Package 12");
        expected.add("Class : new EClass 12");
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Class : NewEClass3");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : new EClass 3");
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedNewPackageEntities() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Class : new EClass 12");
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        return expected;
    }

    private List<String> getExpectedNewPackageEntitiesAfterRenameClass() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Class : new EClass 12A");
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        return expected;
    }

    private List<String> getExpectedNewPackageEntitiesAfterAddClass() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Class : new EClass 12");
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Class : NewEClass3");
        return expected;
    }

    private List<String> getExpectedRootPackage() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Package : new Package 12");
        expected.add("Class : new EClass 12");
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : new EClass 3");
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedRootPackageAfterRenamePackage() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Package : new Package 12A");
        expected.add("Class : new EClass 12");
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : new EClass 3");
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedRootPackageAfterRenameClass() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Package : new Package 12");
        expected.add("Class : new EClass 12A");
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : new EClass 3");
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedRootPackageAfterAddClass() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Package : new Package 12");
        expected.add("Class : new EClass 12");
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Class : NewEClass3");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : new EClass 3");
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    protected void tearDown() throws Exception {
        TestsUtil.synchronizationWithUIThread();
        this.diagramAnotherRootpackage = null;
        this.diagramPackage = null;
        this.diagramRootPackage = null;
        this.tableInNewPackage = null;
        this.tableRootPackage = null;
        this.tree = null;
        this.editorPackage2Classes = null;
        this.editorRootClasses = null;
        this.editorRootTree = null;
        super.tearDown();
    }
}

