/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout;

import com.google.common.collect.Iterables;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.ExtendableLayoutProvider;

public class LayoutExtender {
    private final Map<IGraphicalEditPart, Rectangle> updatedLocations = new WeakHashMap<IGraphicalEditPart, Rectangle>();
    private final ExtendableLayoutProvider layouter;

    public LayoutExtender(ExtendableLayoutProvider layouter) {
        this.layouter = layouter;
    }

    public Map<IGraphicalEditPart, Rectangle> getUpdatedBounds() {
        return this.updatedLocations;
    }

    public void startLayouting() {
        this.updatedLocations.clear();
    }

    public List getRelevantConnections(Hashtable editPartToNodeDict, List list) {
        Iterator iterConnections = list.iterator();
        boolean shouldHandleListItems = this.layouter.handleConnectableListItems();
        while (iterConnections.hasNext()) {
            Object next = iterConnections.next();
            if (!(next instanceof ConnectionEditPart)) continue;
            ConnectionEditPart poly = (ConnectionEditPart)next;
            EditPart from = poly.getSource();
            EditPart to = poly.getTarget();
            if (from instanceof IBorderItemEditPart) {
                from = from.getParent();
            } else if (shouldHandleListItems && from instanceof ListItemEditPart) {
                from = this.getFirstAnscestorinNodesMap(from, editPartToNodeDict);
            }
            if (to instanceof IBorderItemEditPart) {
                to = to.getParent();
            } else if (shouldHandleListItems && to instanceof ListItemEditPart) {
                to = this.getFirstAnscestorinNodesMap(to, editPartToNodeDict);
            }
            if (from != null && to != null) continue;
            iterConnections.remove();
        }
        return list;
    }

    public void keepLocationChanges(List nodes, Point diff) {
        for (Node node : Iterables.filter((Iterable)nodes, Node.class)) {
            if (!(node.data instanceof ShapeEditPart)) continue;
            IGraphicalEditPart gep = (IGraphicalEditPart)node.data;
            Rectangle intrinsicBounds = gep.getFigure().getBounds();
            Rectangle nodeExt = this.layouter.provideNodeMetrics(node);
            Rectangle newBounds = new Rectangle(nodeExt.x + diff.x, nodeExt.y + diff.y, intrinsicBounds.width, intrinsicBounds.height);
            this.updatedLocations.put(gep, newBounds);
        }
    }

    public List filterEdges(List selectedObjects, Map editPartToNodeDict) {
        LinkedList tmp = new LinkedList(selectedObjects);
        Iterator iterConnections = tmp.iterator();
        boolean shouldHandleListItems = this.layouter.handleConnectableListItems();
        while (iterConnections.hasNext()) {
            Object next = iterConnections.next();
            if (!(next instanceof ConnectionEditPart)) continue;
            ConnectionEditPart poly = (ConnectionEditPart)next;
            EditPart from = poly.getSource();
            EditPart to = poly.getTarget();
            if (from instanceof IBorderItemEditPart) {
                from = from.getParent();
            } else if (shouldHandleListItems && from instanceof ListItemEditPart) {
                from = this.getFirstAnscestorinNodesMap(from, editPartToNodeDict);
            }
            if (to instanceof IBorderItemEditPart) {
                to = to.getParent();
            } else if (shouldHandleListItems && to instanceof ListItemEditPart) {
                to = this.getFirstAnscestorinNodesMap(to, editPartToNodeDict);
            }
            if (from != null && to != null) continue;
            iterConnections.remove();
        }
        return tmp;
    }

    private EditPart getFirstAnscestorinNodesMap(EditPart editPart, Map editPartToNodeDict) {
        EditPart ancestor = editPart;
        while (ancestor != null) {
            if (editPartToNodeDict.get(ancestor) != null) {
                return ancestor;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }
}

