/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionFinder;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.SemanticRegionMatcher;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringRegion;

public class StringSemanticRegion
extends StringRegion
implements ISemanticRegion {
    private final AbstractEObjectRegion eObjectRegion;
    private final EObject grammarElement;
    protected int indexInFeature = -2;
    private IHiddenRegion leading;
    private IHiddenRegion trailing;

    protected StringSemanticRegion(StringBasedRegionAccess regionAccess, AbstractEObjectRegion semanticElement, EObject grammarElement, int offset, int length) {
        super(regionAccess, offset, length);
        this.eObjectRegion = semanticElement;
        this.grammarElement = grammarElement;
    }

    @Override
    public EStructuralFeature getContainingFeature() {
        Assignment assignment = GrammarUtil.containingAssignment(this.getGrammarElement());
        if (assignment != null) {
            return this.getSemanticElement().eClass().getEStructuralFeature(assignment.getFeature());
        }
        return null;
    }

    @Override
    public IEObjectRegion getContainingRegion() {
        return this.eObjectRegion;
    }

    @Override
    public IEObjectRegion getEObjectRegion() {
        return this.eObjectRegion;
    }

    @Override
    public EObject getGrammarElement() {
        return this.grammarElement;
    }

    @Override
    public int getIndexInContainingFeature() {
        if (this.indexInFeature < -1) {
            EStructuralFeature feature = this.getContainingFeature();
            if (feature != null && feature.isMany()) {
                this.eObjectRegion.initChildrenFeatureIndexes();
            } else {
                this.indexInFeature = -1;
            }
        }
        return this.indexInFeature;
    }

    @Override
    public IHiddenRegion getNextHiddenRegion() {
        return this.trailing;
    }

    @Override
    public ISemanticRegion getNextSemanticRegion() {
        return this.trailing != null ? this.trailing.getNextSemanticRegion() : null;
    }

    @Override
    public ISequentialRegion getNextSequentialRegion() {
        return this.trailing;
    }

    @Override
    public IHiddenRegion getPreviousHiddenRegion() {
        return this.leading;
    }

    @Override
    public ISemanticRegion getPreviousSemanticRegion() {
        return this.leading != null ? this.leading.getPreviousSemanticRegion() : null;
    }

    @Override
    public ISequentialRegion getPreviousSequentialRegion() {
        return this.leading;
    }

    @Override
    public EObject getSemanticElement() {
        return this.eObjectRegion.getSemanticElement();
    }

    @Override
    public ISemanticRegionFinder immediatelyFollowing() {
        return new SemanticRegionMatcher(this.getNextSemanticRegion());
    }

    @Override
    public ISemanticRegionFinder immediatelyPreceding() {
        return new SemanticRegionMatcher(this.getPreviousSemanticRegion());
    }

    protected void setLeadingHiddenRegion(IHiddenRegion leading) {
        this.leading = leading;
    }

    protected void setTrailingHiddenRegion(IHiddenRegion trailing) {
        this.trailing = trailing;
    }
}

