/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.table.business.api.query.DLineQuery;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.description.DeleteLineTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteTool;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.provider.Messages;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;

public class DeleteLinesAction
extends Action {
    private final TransactionalEditingDomain editingDomain;
    private final ITableCommandFactory tableCommandFactory;
    private final Collection<DLine> lines = new ArrayList<DLine>();

    public DeleteLinesAction(TransactionalEditingDomain editingDomain, ITableCommandFactory tableCommandFactory) {
        super(Messages.DeleteLinesAction_label, DTableViewerManager.getImageRegistry().getDescriptor("table/delete"));
        this.editingDomain = editingDomain;
        this.tableCommandFactory = tableCommandFactory;
    }

    public void run() {
        super.run();
        CompoundCommand cc = new CompoundCommand(this.getText());
        for (DLine line : this.lines) {
            cc.append(this.tableCommandFactory.buildDeleteTableElement((DTableElement)line));
        }
        this.getEditingDomain().getCommandStack().execute((Command)cc);
        this.lines.clear();
    }

    private TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setLines(Collection<DLine> linesToDelete) {
        this.lines.clear();
        if (linesToDelete != null) {
            this.lines.addAll(linesToDelete);
            if (linesToDelete.size() == 1) {
                this.setText(Messages.DeleteLinesAction_label);
                this.setToolTipText(Messages.DeleteLinesAction_tooltip);
                DeleteTool deleteTool = this.getDeleteTool(linesToDelete.iterator().next());
                if (deleteTool != null) {
                    this.setText(new IdentifiedElementQuery((IdentifiedElement)deleteTool).getLabel());
                    this.setToolTipText(MessageTranslator.INSTANCE.getMessage((EObject)deleteTool, deleteTool.getDocumentation()));
                }
            } else if (linesToDelete.size() > 1) {
                this.setText(Messages.DeleteLinesAction_labelMany);
                this.setToolTipText(Messages.DeleteLinesAction_tooltipMany);
            }
        }
    }

    public boolean canExecute() {
        boolean canExecute = !this.lines.isEmpty();
        for (DLine lineToDelete : this.lines) {
            boolean bl = canExecute = canExecute && new DLineQuery(lineToDelete).canBeDeleted();
            if (!canExecute) break;
        }
        return canExecute;
    }

    private DeleteTool getDeleteTool(DLine line) {
        LineMapping originMapping;
        DeleteLineTool tool = null;
        if (line != null && (originMapping = line.getOriginMapping()) != null) {
            tool = originMapping.getDelete();
        }
        return tool;
    }
}

