/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.query.IllegalStateExceptionQuery;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class DRepresentationDescriptorQuery {
    private DRepresentationDescriptor repDescriptor;

    public DRepresentationDescriptorQuery(DRepresentationDescriptor repDescriptor) {
        this.repDescriptor = repDescriptor;
    }

    public boolean isDangling() {
        return this.repDescriptor.getTarget() == null || SessionManager.INSTANCE.getSession(this.repDescriptor.getTarget()) == null;
    }

    public boolean isRepresentationReachable() {
        return this.isRepresentationReachable(false);
    }

    public boolean isRepresentationReachable(boolean forceLoadResource) {
        boolean isRepresentationReachable = this.repDescriptor.isLoadedRepresentation();
        if (!isRepresentationReachable && this.repDescriptor.getRepPath() != null) {
            String extention = this.repDescriptor.getRepPath().getResourceURI().fileExtension();
            if ("aird".equals(extention)) {
                return this.repDescriptor.getRepresentation() != null;
            }
            Resource eResource = this.repDescriptor.eResource();
            if (eResource != null) {
                ResourceSet resourceSet = eResource.getResourceSet();
                try {
                    if (!forceLoadResource) {
                        isRepresentationReachable = resourceSet.getURIConverter().exists(this.repDescriptor.getRepPath().getResourceURI(), null);
                    } else if (resourceSet.getURIConverter().exists(this.repDescriptor.getRepPath().getResourceURI(), null)) {
                        Resource resource = resourceSet.getResource(this.repDescriptor.getRepPath().getResourceURI().trimFragment(), true);
                        EObject eObject = resource.getEObject(this.repDescriptor.getRepPath().getResourceURI().fragment());
                        if (eObject == null) {
                            SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", MessageFormat.format(Messages.DRepresentationDescriptorQuery_representationError_broken_fragment_path, this.repDescriptor.getName(), resource.getURI().path(), this.repDescriptor.getRepPath().getResourceURI().fragment())));
                        }
                    } else {
                        SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", MessageFormat.format(Messages.DRepresentationDescriptorQuery_representationError_broken_srm_path, this.repDescriptor.getName(), this.repDescriptor.getRepPath().getResourceURI().trimFragment())));
                    }
                }
                catch (RuntimeException e) {
                    SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DRepresentationDescriptorQuery_representationError, this.repDescriptor.getName(), this.repDescriptor.getRepPath(), this.repDescriptor.getUid()), e);
                }
            }
        }
        return isRepresentationReachable;
    }

    public boolean isRepresentationValid() {
        return this.isRepresentationValid(false);
    }

    public boolean isRepresentationValid(boolean forceLoadRepresentation) {
        DRepresentationDescriptorValidityAdapter dRepDescriptorValidityAdapter = (DRepresentationDescriptorValidityAdapter)this.repDescriptor.eAdapters().stream().filter(DRepresentationDescriptorValidityAdapter.class::isInstance).findFirst().orElseGet(() -> new DRepresentationDescriptorValidityAdapter(this.repDescriptor));
        if (forceLoadRepresentation) {
            dRepDescriptorValidityAdapter.triggerRepresentationValidation(forceLoadRepresentation);
        }
        return dRepDescriptorValidityAdapter.isValid();
    }

    private boolean computeRepresentationValid(boolean forceLoadRepresentation) {
        try {
            boolean isValid;
            boolean bl = isValid = !this.isDangling() && this.isRepresentationReachable(forceLoadRepresentation);
            if (isValid && this.repDescriptor.isLoadedRepresentation()) {
                isValid = !new DRepresentationQuery(this.repDescriptor.getRepresentation()).isDanglingRepresentation();
            }
            return isValid;
        }
        catch (IllegalStateException e) {
            if (new IllegalStateExceptionQuery(e).isAConnectionLostException()) {
                return false;
            }
            throw e;
        }
    }

    public class DRepresentationDescriptorValidityAdapter
    extends AdapterImpl
    implements Adapter {
        private boolean validity;

        public DRepresentationDescriptorValidityAdapter(DRepresentationDescriptor representationDescriptor) {
            representationDescriptor.eAdapters().add((Object)this);
            this.validity = DRepresentationDescriptorQuery.this.computeRepresentationValid(false);
        }

        public void triggerRepresentationValidation() {
            this.validity = DRepresentationDescriptorQuery.this.computeRepresentationValid(false);
        }

        public void triggerRepresentationValidation(boolean forceLoadRepresentation) {
            this.validity = DRepresentationDescriptorQuery.this.computeRepresentationValid(forceLoadRepresentation);
        }

        public boolean isValid() {
            return this.validity;
        }

        public void notifyChanged(Notification notification) {
        }
    }
}

