/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.sample.scxml.design;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.sirius.tests.sample.scxml.ScxmlDataType;
import org.eclipse.sirius.tests.sample.scxml.ScxmlTransitionType;

public class LabelParser {
    private static Pattern REGEX1 = Pattern.compile("^(\\s*\\[\\s*\\w+\\s*\\])?\\s*[\\w\\.]*\\s*$");
    private static Pattern REGEX2 = Pattern.compile("^\\s*\\w+\\s*=\\s*\\w+\\s*$");

    public String getTransitionEvent(ScxmlTransitionType transition, String label) {
        String ret = transition.getEvent();
        Matcher m = REGEX1.matcher(label);
        if (m.matches()) {
            String event = label.substring(label.indexOf("]") + 1);
            ret = event.trim();
        }
        return ret;
    }

    public String getTransitionCondition(ScxmlTransitionType transition, String label) {
        String ret = transition.getCond();
        Matcher m = REGEX1.matcher(label);
        if (m.matches()) {
            if (label.indexOf("[") < 0) {
                ret = "";
            } else {
                String cond = label.substring(label.indexOf("[") + 1, label.indexOf("]"));
                ret = cond.trim();
            }
        }
        return ret;
    }

    public String getDataID(ScxmlDataType data, String label) {
        String ret = data.getId();
        Matcher m = REGEX2.matcher(label);
        if (m.matches()) {
            String id = label.substring(0, label.indexOf("="));
            ret = id.trim();
        }
        return ret;
    }

    public String getDataExpression(ScxmlDataType data, String label) {
        String ret = data.getExpr();
        Matcher m = REGEX2.matcher(label);
        if (m.matches()) {
            String expr = label.substring(label.indexOf("=") + 1);
            ret = expr.trim();
        }
        return ret;
    }
}

