/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.layout;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.swt.widgets.Display;

public class SiriusCanonicalLayoutCommand
extends RecordingCommand
implements AbstractCommand.NonDirtying {
    private IGraphicalEditPart parentEditPart;
    private List<IAdaptable> childViewsAdapters;
    private List<IAdaptable> centeredChildViewsAdapters;
    boolean useSpecificLayoutType;

    public SiriusCanonicalLayoutCommand(TransactionalEditingDomain domain, DiagramEditPart diagramEditPart) {
        this(domain, (IGraphicalEditPart)diagramEditPart, null, null);
    }

    public SiriusCanonicalLayoutCommand(TransactionalEditingDomain domain, IGraphicalEditPart parentEditPart, List<IAdaptable> childViewsAdapters, List<IAdaptable> centeredChildViewsAdapters) {
        this(domain, parentEditPart, childViewsAdapters, centeredChildViewsAdapters, false);
    }

    public SiriusCanonicalLayoutCommand(TransactionalEditingDomain domain, IGraphicalEditPart parentEditPart, List<IAdaptable> childViewsAdapters, List<IAdaptable> centeredChildViewsAdapters, boolean useSpecificLayoutType) {
        super(domain, Messages.SiriusCanonicalLayoutCommand_label);
        this.parentEditPart = parentEditPart;
        this.childViewsAdapters = childViewsAdapters;
        this.centeredChildViewsAdapters = centeredChildViewsAdapters;
        this.useSpecificLayoutType = useSpecificLayoutType;
    }

    protected void doExecute() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SiriusCanonicalLayoutCommand.this.childViewsAdapters == null && SiriusCanonicalLayoutCommand.this.centeredChildViewsAdapters == null) {
                    SiriusCanonicalLayoutCommand.this.executeLayoutOnDiagramOpening();
                } else {
                    SiriusCanonicalLayoutCommand.this.executeLayoutDueToExternalChanges();
                }
            }
        });
    }

    private void executeLayoutOnDiagramOpening() {
        Command arrangeCmd = SiriusLayoutDataManager.INSTANCE.getArrangeCreatedViewsOnOpeningCommand(this.parentEditPart);
        if (arrangeCmd != null && arrangeCmd.canExecute()) {
            arrangeCmd.execute();
        }
    }

    private void executeLayoutDueToExternalChanges() {
        Command arrangeCmd = SiriusLayoutDataManager.INSTANCE.getArrangeCreatedViewsCommand(this.childViewsAdapters, this.centeredChildViewsAdapters, this.parentEditPart, this.useSpecificLayoutType);
        if (arrangeCmd != null && arrangeCmd.canExecute()) {
            arrangeCmd.execute();
        }
    }
}

