/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.internal;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.sirius.ext.ide.api.AbstractRegistryEventListener;
import org.eclipse.sirius.ext.ide.api.DescriptorRegistryEventListener;
import org.eclipse.sirius.ext.ide.api.IItemDescriptor;
import org.eclipse.sirius.ext.ide.api.IItemRegistry;
import org.eclipse.sirius.ext.ide.api.ItemRegistry;
import org.eclipse.sirius.server.api.ISiriusServerConfigurator;
import org.eclipse.sirius.server.api.ISiriusServerEndpointConfigurationProvider;
import org.eclipse.sirius.server.api.ISiriusServerService;
import org.eclipse.sirius.server.internal.SiriusServerManager;
import org.osgi.framework.BundleContext;

public class SiriusServerPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.sirius.server";
    public static final SiriusServerPlugin INSTANCE = new SiriusServerPlugin();
    private static Implementation plugin;

    public SiriusServerPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        private static final String SIRIUS_SERVER_CONFIGURATOR = "siriusServerConfigurator";
        private static final String SIRIUS_SERVER_SERVICE = "siriusServerService";
        private static final String SIRIUS_SERVER_ENDPOINT_CONFIGURATION_PROVIDER = "siriusServerEndpointConfigurationProvider";
        private IItemRegistry<ISiriusServerConfigurator> configuratorRegistry;
        private AbstractRegistryEventListener configuratorListener;
        private IItemRegistry<ISiriusServerService> serviceRegistry;
        private AbstractRegistryEventListener serviceListener;
        private IItemRegistry<ISiriusServerEndpointConfigurationProvider> endpointConfigurationProviderRegistry;
        private AbstractRegistryEventListener endpointConfigurationProviderListener;
        private SiriusServerManager serverManager = new SiriusServerManager();

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            this.configuratorRegistry = new ItemRegistry();
            this.configuratorListener = new DescriptorRegistryEventListener(SiriusServerPlugin.PLUGIN_ID, SIRIUS_SERVER_CONFIGURATOR, this.configuratorRegistry);
            extensionRegistry.addListener((IRegistryEventListener)this.configuratorListener, "org.eclipse.sirius.server.siriusServerConfigurator");
            this.configuratorListener.readRegistry(extensionRegistry);
            this.serviceRegistry = new ItemRegistry();
            this.serviceListener = new DescriptorRegistryEventListener(SiriusServerPlugin.PLUGIN_ID, SIRIUS_SERVER_SERVICE, this.serviceRegistry);
            extensionRegistry.addListener((IRegistryEventListener)this.serviceListener, "org.eclipse.sirius.server.siriusServerService");
            this.serviceListener.readRegistry(extensionRegistry);
            this.endpointConfigurationProviderRegistry = new ItemRegistry();
            this.endpointConfigurationProviderListener = new DescriptorRegistryEventListener(SiriusServerPlugin.PLUGIN_ID, SIRIUS_SERVER_ENDPOINT_CONFIGURATION_PROVIDER, this.endpointConfigurationProviderRegistry);
            extensionRegistry.addListener((IRegistryEventListener)this.endpointConfigurationProviderListener, "org.eclipse.sirius.server.siriusServerEndpointConfigurationProvider");
            this.endpointConfigurationProviderListener.readRegistry(extensionRegistry);
            this.serverManager.start();
        }

        public void stop(BundleContext context) throws Exception {
            this.serverManager.stop();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            extensionRegistry.removeListener((IRegistryEventListener)this.configuratorListener);
            extensionRegistry.removeListener((IRegistryEventListener)this.serviceListener);
            extensionRegistry.removeListener((IRegistryEventListener)this.endpointConfigurationProviderListener);
            this.serviceListener = null;
            this.serviceRegistry = null;
            this.configuratorListener = null;
            this.configuratorRegistry = null;
            this.endpointConfigurationProviderListener = null;
            this.endpointConfigurationProviderRegistry = null;
            super.stop(context);
        }

        public List<ISiriusServerConfigurator> getSiriusServerConfigurators() {
            return this.configuratorRegistry.getItemDescriptors().stream().map(IItemDescriptor::getItem).collect(Collectors.toList());
        }

        public List<ISiriusServerService> getSiriusServerServices() {
            return this.serviceRegistry.getItemDescriptors().stream().map(IItemDescriptor::getItem).collect(Collectors.toList());
        }

        public List<ISiriusServerEndpointConfigurationProvider> getEndpointConfigurationProviders() {
            return this.endpointConfigurationProviderRegistry.getItemDescriptors().stream().map(IItemDescriptor::getItem).collect(Collectors.toList());
        }

        public URI getServerURI() {
            return this.serverManager.getURI();
        }
    }
}

