/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.diagram.internal;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.eclipse.sirius.server.diagram.internal.SiriusServerDiagramMessageHandler;
import org.eclipse.sirius.server.diagram.internal.SiriusServerDiagramServiceManager;
import org.eclipse.sirius.services.diagram.api.SiriusDiagramMessage;
import org.eclipse.sirius.services.diagram.api.SiriusDiagramService;

public class SiriusServerDiagramEndpoint
extends Endpoint {
    private static final String PROJECT_NAME = "projectName";
    private static final String REPRESENTATION_NAME = "representationName";
    private SiriusServerDiagramServiceManager diagramServiceManager;

    public SiriusServerDiagramEndpoint(SiriusServerDiagramServiceManager diagramServiceManager) {
        this.diagramServiceManager = diagramServiceManager;
    }

    public void onOpen(Session session, EndpointConfig config) {
        Map parameters = session.getRequestParameterMap();
        List projectNameValues = (List)parameters.get(PROJECT_NAME);
        List representatioNameValues = (List)parameters.get(REPRESENTATION_NAME);
        if (projectNameValues.size() == 1 && representatioNameValues.size() == 1) {
            String projectName = (String)projectNameValues.get(0);
            String representationName = (String)representatioNameValues.get(0);
            Consumer<SiriusDiagramMessage> callback = message -> {
                String json = new Gson().toJson(message);
                session.getAsyncRemote().sendText(json);
            };
            SiriusDiagramService diagramService = this.diagramServiceManager.acquire(session.getId(), projectName, representationName, callback);
            session.addMessageHandler((MessageHandler)new SiriusServerDiagramMessageHandler(diagramService));
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.diagramServiceManager.release(session.getId());
        super.onClose(session, closeReason);
    }
}

