/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;

public final class CacheHelper {
    private static boolean structuralCacheEnabled;
    private static boolean verticalRangeCacheEnabled;
    private static Map<AbstractFrame, Collection<Lifeline>> coverageCache;
    private static ConcurrentHashMap<ISequenceEvent, Collection<ISequenceEvent>> subEventsCache;
    private static ConcurrentHashMap<View, Range> viewToRangeCache;
    private static ConcurrentHashMap<ISequenceEvent, Message> startCompoundMessageCache;
    private static ConcurrentHashMap<ISequenceEvent, Message> endCompoundMessageCache;
    private static ConcurrentHashMap<AbstractNodeEvent, ISequenceEvent> nodeEventToHierarchicalParentCache;
    private static ConcurrentHashMap<ISequenceEvent, Option<Operand>> eventToParentOperandCache;
    private static ConcurrentHashMap<ISequenceEvent, ISequenceEvent> eventToParentEventCache;
    private static ConcurrentHashMap<SingleEventEnd, Optional<ISequenceEvent>> eventEndToISequenceEventCache;
    private static ConcurrentHashMap<CombinedFragment, List<Operand>> combinedFragmentToOperandsCache;
    private static ConcurrentHashMap<Operand, CombinedFragment> operandToCombinedFragmentCache;

    static {
        coverageCache = new ConcurrentHashMap<AbstractFrame, Collection<Lifeline>>();
        subEventsCache = new ConcurrentHashMap();
        viewToRangeCache = new ConcurrentHashMap();
        startCompoundMessageCache = new ConcurrentHashMap();
        endCompoundMessageCache = new ConcurrentHashMap();
        nodeEventToHierarchicalParentCache = new ConcurrentHashMap();
        eventToParentOperandCache = new ConcurrentHashMap();
        eventToParentEventCache = new ConcurrentHashMap();
        eventEndToISequenceEventCache = new ConcurrentHashMap();
        combinedFragmentToOperandsCache = new ConcurrentHashMap();
        operandToCombinedFragmentCache = new ConcurrentHashMap();
    }

    private CacheHelper() {
    }

    public static boolean isStructuralCacheEnabled() {
        return structuralCacheEnabled;
    }

    public static void setStructuralCacheEnabled(boolean enabled) {
        structuralCacheEnabled = enabled;
    }

    public static boolean isVerticalRangeCacheEnabled() {
        return verticalRangeCacheEnabled;
    }

    public static void setVerticalRangeCacheEnabled(boolean enabled) {
        verticalRangeCacheEnabled = enabled;
    }

    public static void clearCaches() {
        coverageCache.clear();
        startCompoundMessageCache.clear();
        endCompoundMessageCache.clear();
        nodeEventToHierarchicalParentCache.clear();
        eventEndToISequenceEventCache.clear();
        combinedFragmentToOperandsCache.clear();
        operandToCombinedFragmentCache.clear();
        CacheHelper.clearRangeDependantCaches();
    }

    public static void clearRangeDependantCaches() {
        subEventsCache.clear();
        eventToParentOperandCache.clear();
        eventToParentEventCache.clear();
        viewToRangeCache.clear();
    }

    public static Map<AbstractFrame, Collection<Lifeline>> getCoverageCache() {
        return coverageCache;
    }

    public static ConcurrentHashMap<ISequenceEvent, Collection<ISequenceEvent>> getSubEventsCache() {
        return subEventsCache;
    }

    public static Map<View, Range> getViewToRangeCache() {
        return viewToRangeCache;
    }

    public static ConcurrentHashMap<ISequenceEvent, Message> getStartCompoundMessageCache() {
        return startCompoundMessageCache;
    }

    public static ConcurrentHashMap<ISequenceEvent, Message> getEndCompoundMessageCache() {
        return endCompoundMessageCache;
    }

    public static ConcurrentHashMap<AbstractNodeEvent, ISequenceEvent> getAbstractNodeEventToHierarchicalParentCache() {
        return nodeEventToHierarchicalParentCache;
    }

    public static ConcurrentHashMap<ISequenceEvent, Option<Operand>> getEventToParentOperandCache() {
        return eventToParentOperandCache;
    }

    public static ConcurrentHashMap<ISequenceEvent, ISequenceEvent> getEventToParentEventCache() {
        return eventToParentEventCache;
    }

    public static ConcurrentHashMap<SingleEventEnd, Optional<ISequenceEvent>> getEventEndToISequenceEventCache() {
        return eventEndToISequenceEventCache;
    }

    public static ConcurrentHashMap<CombinedFragment, List<Operand>> getCombinedFragmentToOperandsCache() {
        return combinedFragmentToOperandsCache;
    }

    public static ConcurrentHashMap<Operand, CombinedFragment> getOperandToCombinedFragmentCache() {
        return operandToCombinedFragmentCache;
    }
}

