/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.business.internal.session.SessionFactoryService;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryService;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetFactory;
import org.eclipse.sirius.tools.internal.resource.InMemoryResourceImpl;
import org.eclipse.sirius.tools.internal.resource.ResourceSetUtil;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.ViewpointFactory;

public class SessionFactoryImpl
implements SessionFactory {
    public static SessionFactory init() {
        SessionFactory sessionFactory = SessionFactoryService.INSTANCE.getSessionFactory();
        if (sessionFactory == null) {
            sessionFactory = new SessionFactoryImpl();
        }
        return sessionFactory;
    }

    public final Session createSession(URI sessionResourceURI) throws CoreException {
        return this.createSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public Session createSession(URI sessionResourceURI, IProgressMonitor monitor) throws CoreException {
        TransactionalEditingDomain ted = this.prepareEditingDomain(sessionResourceURI);
        boolean alreadyExistingResource = ted.getResourceSet().getURIConverter().exists(sessionResourceURI, null);
        Session session = null;
        session = alreadyExistingResource ? this.loadSessionModelResource(sessionResourceURI, ted, monitor) : this.createSessionResource(sessionResourceURI, ted, true, monitor);
        return session;
    }

    @Override
    public Session createDefaultSession(URI sessionResourceURI) throws CoreException {
        return this.createSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
    }

    protected final TransactionalEditingDomain prepareEditingDomain(URI sessionResourceURI) {
        ResourceSet set = ResourceSetFactory.createFactory().createResourceSet(sessionResourceURI);
        TransactionalEditingDomain transactionalEditingDomain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain(set);
        set = transactionalEditingDomain.getResourceSet();
        set.getLoadOptions().put("SIRIUS_USE_URI_FRAGMENT_AS_ID", true);
        this.configureDomain(transactionalEditingDomain, sessionResourceURI);
        return transactionalEditingDomain;
    }

    protected void configureDomain(TransactionalEditingDomain transactionalEditingDomain, URI sessionResourceUri) {
        ResourceSet set = transactionalEditingDomain.getResourceSet();
        if (set instanceof ResourceSetImpl) {
            ResourceSetImpl resourceSetImpl = (ResourceSetImpl)set;
            new ResourceSetImpl.MappedResourceLocator(resourceSetImpl);
        }
    }

    protected Session loadSessionModelResource(URI sessionResourceURI, TransactionalEditingDomain transactionalEditingDomain, IProgressMonitor monitor) throws CoreException {
        ResourceSet resourceSet = transactionalEditingDomain.getResourceSet();
        ResourceSetUtil.setProgressMonitor(resourceSet, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        Session session = null;
        try {
            try {
                monitor.beginTask(Messages.SessionFactoryImpl_sessionLoadingMsg, 4);
                Resource sessionModelResource = resourceSet.getResource(sessionResourceURI, true);
                this.checkResource(sessionResourceURI, resourceSet);
                if (sessionModelResource != null) {
                    DAnalysis analysis = null;
                    if (!sessionModelResource.getContents().isEmpty() && sessionModelResource.getContents().get(0) instanceof DAnalysis) {
                        analysis = (DAnalysis)sessionModelResource.getContents().get(0);
                        session = this.createSession(analysis, transactionalEditingDomain);
                        monitor.worked(2);
                    } else {
                        session = this.createSessionResource(sessionResourceURI, transactionalEditingDomain, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                }
            }
            catch (WrappedException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", Messages.SessionFactoryImpl_loadingError, (Throwable)e));
            }
        }
        finally {
            monitor.done();
            ResourceSetUtil.resetProgressMonitor(resourceSet);
        }
        return session;
    }

    protected void checkResource(URI sessionResourceURI, ResourceSet resourceSet) {
    }

    protected Session createSessionResource(URI sessionResourceURI, TransactionalEditingDomain transactionalEditingDomain, boolean additionalTasks, IProgressMonitor monitor) throws CoreException {
        Session session = null;
        try {
            monitor.beginTask(Messages.SessionFactoryImpl_sessionCreation, 2);
            Resource sessionModelResource = new ResourceSetImpl().createResource(sessionResourceURI);
            ResourceQuery resourceQuery = new ResourceQuery(sessionModelResource);
            if (!resourceQuery.isRepresentationsResource() && !(sessionModelResource instanceof InMemoryResourceImpl)) {
                throw new IllegalArgumentException(Messages.SessionFactoryImpl_ResourceTypeErrorMsg);
            }
            ArrayList<Resource> additionalResources = new ArrayList<Resource>();
            if (additionalTasks) {
                this.createAdditionalResources(additionalResources, transactionalEditingDomain, sessionResourceURI, monitor);
            }
            DAnalysis analysis = this.prepareDAnalysis(sessionResourceURI, transactionalEditingDomain, monitor, sessionModelResource, "org.eclipse.sirius");
            session = this.createSession(analysis, transactionalEditingDomain);
            if (additionalTasks) {
                this.completeSessionCreation(session, additionalResources, monitor);
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return session;
    }

    protected void createAdditionalResources(Collection<Resource> additionalResources, TransactionalEditingDomain transactionalEditingDomain, URI sessionResourceURI, IProgressMonitor monitor) {
    }

    private DAnalysis prepareDAnalysis(URI sessionResourceURI, TransactionalEditingDomain transactionalEditingDomain, IProgressMonitor monitor, Resource sessionModelResource, String pluginID) throws CoreException {
        Resource sessionResource = sessionModelResource;
        DAnalysis analysis = ViewpointFactory.eINSTANCE.createDAnalysis();
        sessionModelResource.getContents().add((Object)analysis);
        try {
            sessionModelResource.save(Collections.emptyMap());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, pluginID, Messages.SessionFactoryImpl_creationFailedErrorMsg, (Throwable)e));
        }
        monitor.worked(1);
        sessionResource = transactionalEditingDomain.getResourceSet().getResource(sessionResourceURI, true);
        if (sessionResource.getContents().isEmpty()) {
            throw new CoreException((IStatus)new Status(4, pluginID, Messages.SessionFactoryImpl_EmptyContentErrorMsg));
        }
        analysis = (DAnalysis)sessionResource.getContents().get(0);
        return analysis;
    }

    protected Session createSession(DAnalysis analysis, TransactionalEditingDomain transactionalEditingDomain) {
        return new DAnalysisSessionImpl(analysis);
    }

    protected void completeSessionCreation(Session session, Collection<Resource> additionalResources, IProgressMonitor monitor) {
    }
}

