/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect.command;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class CreateRepresentationCommand
extends RecordingCommand {
    private RepresentationDescription description;
    private Session session;
    private EObject semantic;
    private String name;
    private DRepresentation representation;
    private boolean isInitialOperation;
    private RepresentationCreationDescription creationDescription;
    private IProgressMonitor monitor;

    public CreateRepresentationCommand(Session session, RepresentationDescription description, EObject eObject, String name, IProgressMonitor monitor) {
        super(session.getTransactionalEditingDomain(), Messages.CreateRepresentationCommand_label);
        this.session = session;
        this.description = description;
        this.semantic = eObject;
        this.name = name;
        this.monitor = monitor;
    }

    public void setInitialOperation(RepresentationCreationDescription creationDesc) {
        this.creationDescription = creationDesc;
        this.isInitialOperation = creationDesc.getInitialOperation() != null && creationDesc.getInitialOperation().getFirstModelOperations() != null;
    }

    public boolean canExecute() {
        if (this.isInitialOperation) {
            return super.canExecute();
        }
        EObject root = CreateRepresentationCommand.computeRepresentationRoot(this.session.getInterpreter(), this.creationDescription, this.semantic);
        return DialectManager.INSTANCE.canCreate(root, this.description);
    }

    protected void doExecute() {
        EObject root = CreateRepresentationCommand.computeRepresentationRoot(this.session.getInterpreter(), this.creationDescription, this.semantic);
        this.representation = DialectManager.INSTANCE.createRepresentation(this.name, root, this.description, this.session, this.monitor);
        if (this.representation != null) {
            new DRepresentationQuery(this.representation).getRepresentationDescriptor().setName(this.name);
        }
    }

    public Collection<?> getResult() {
        HashSet<DRepresentation> result = new HashSet<DRepresentation>();
        result.add(this.representation);
        this.clearData();
        return result;
    }

    public DRepresentation getCreatedRepresentation() {
        return (DRepresentation)this.getResult().iterator().next();
    }

    public void dispose() {
        super.dispose();
        this.clearData();
    }

    private void clearData() {
        this.representation = null;
        this.session = null;
        this.description = null;
        this.semantic = null;
        this.name = null;
        this.creationDescription = null;
        this.label = null;
        this.monitor = null;
    }

    private static EObject computeRepresentationRoot(IInterpreter interpreter, RepresentationCreationDescription desc, EObject initialRoot) {
        EObject newRepresentationRoot = initialRoot;
        if (desc != null && !StringUtil.isEmpty((String)desc.getBrowseExpression())) {
            try {
                newRepresentationRoot = interpreter.evaluateEObject(newRepresentationRoot, desc.getBrowseExpression());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.warning(newRepresentationRoot, (EStructuralFeature)ToolPackage.eINSTANCE.getRepresentationCreationDescription_BrowseExpression(), e);
            }
            if (newRepresentationRoot == null) {
                RuntimeLoggerManager.INSTANCE.warning(initialRoot, (EStructuralFeature)ToolPackage.eINSTANCE.getRepresentationCreationDescription_BrowseExpression(), MessageFormat.format(Messages.CreateRepresentationCommand_nullExpresionWarningMsg, desc.getBrowseExpression()));
            }
        }
        return newRepresentationRoot;
    }
}

