/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RetargetAction;

public class LaunchBehaviorToolAction
extends RetargetAction {
    private ISelection selection;

    public LaunchBehaviorToolAction(String actionID, ImageDescriptor imageDescriptor) {
        super(actionID, Messages.LaunchBehaviorToolAction_label, 1);
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        this.selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
            Collection<EditPart> minimizedSelection = LaunchBehaviorToolAction.minimizeSelection(new LinkedList<Object>(Arrays.asList(structuredSelection.toArray())));
            for (EditPart nextSelected : minimizedSelection) {
                if (!(nextSelected instanceof EditPart)) continue;
                GroupRequest refreshRequest = new GroupRequest((Object)"launchRuleTools");
                nextSelected.performRequest((Request)refreshRequest);
            }
        }
    }

    public void runWithEvent(Event event) {
        super.runWithEvent(event);
        this.run();
    }

    private static Collection<EditPart> minimizeSelection(List<EditPart> selection) {
        ArrayList<EditPart> result = new ArrayList<EditPart>(selection.size());
        Iterator<EditPart> iterSelection = selection.iterator();
        while (iterSelection.hasNext()) {
            EditPart next = iterSelection.next();
            if (next instanceof EditPart) {
                EditPart editPart = next;
                if (LaunchBehaviorToolAction.isNotAChild(editPart, selection)) {
                    result.add(editPart);
                    continue;
                }
                iterSelection.remove();
                continue;
            }
            iterSelection.remove();
        }
        return result;
    }

    private static boolean isNotAChild(EditPart editPart, Collection<EditPart> selection) {
        boolean result = true;
        Iterator<EditPart> iterEditParts = selection.iterator();
        while (iterEditParts.hasNext() && result) {
            EditPart currentEditPart = iterEditParts.next();
            if (currentEditPart == editPart || !iterEditParts.hasNext()) continue;
            boolean bl = result = !LaunchBehaviorToolAction.isAChild(editPart, iterEditParts.next());
        }
        return result;
    }

    private static boolean isAChild(EditPart mayBeChild, EditPart editPart) {
        boolean res = false;
        if (editPart.getChildren().contains(mayBeChild)) {
            res = true;
        }
        Iterator iterChildren = editPart.getChildren().iterator();
        while (iterChildren.hasNext() && !res) {
            EditPart currentEditPart = (EditPart)iterChildren.next();
            res = LaunchBehaviorToolAction.isAChild(mayBeChild, currentEditPart);
        }
        return res;
    }

    public boolean isEnabled() {
        return true;
    }
}

