/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.api.entities;

import java.util.Objects;
import org.eclipse.sirius.services.diagram.api.entities.AbstractSiriusDiagramNode;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramLabel;

public class SiriusDiagramListElementNode
extends AbstractSiriusDiagramNode {
    private static final String TYPE = "node:listelement";
    private SiriusDiagramLabel label;
    private String imagePath;

    public SiriusDiagramListElementNode(String identifier, String semanticElementIdentifier) {
        super(identifier, semanticElementIdentifier, TYPE);
    }

    public String getImagePath() {
        return this.imagePath;
    }

    private void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public SiriusDiagramLabel getLabel() {
        return this.label;
    }

    private void setLabel(SiriusDiagramLabel label) {
        this.label = label;
    }

    public static Builder newListElementNode(String identifier, String semanticElementIdentifier) {
        return new Builder(identifier, semanticElementIdentifier);
    }

    public static final class Builder {
        private String identifier;
        private String semanticElementIdentifier;
        private SiriusDiagramLabel label;
        private String imagePath;

        private Builder(String identifier, String semanticElementIdentifier) {
            this.identifier = Objects.requireNonNull(identifier);
            this.semanticElementIdentifier = Objects.requireNonNull(semanticElementIdentifier);
        }

        public Builder label(SiriusDiagramLabel label) {
            this.label = label;
            return this;
        }

        public Builder imagePath(String imagePath) {
            this.imagePath = imagePath;
            return this;
        }

        public SiriusDiagramListElementNode build() {
            SiriusDiagramListElementNode listNode = new SiriusDiagramListElementNode(this.identifier, this.semanticElementIdentifier);
            listNode.setImagePath(this.imagePath);
            listNode.setLabel(this.label);
            return listNode;
        }
    }
}

