/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.action;

import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Translation;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.TranslationNewDialog;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableController;
import org.eclipse.swt.widgets.Shell;

public class TranslationNewAction
extends Action {
    private final ITranslation m_initialEntry;
    private final TranslationManager m_manager;
    private final Shell m_shell;
    private final NlsTableController m_controller;
    private ITranslation m_createdTranslation;

    public TranslationNewAction(Shell shell, TranslationManager manager, NlsTableController controller) {
        this(shell, manager, null, controller);
    }

    public TranslationNewAction(Shell shell, TranslationManager manager, ITranslation entry) {
        this(shell, manager, entry, null);
    }

    protected TranslationNewAction(Shell shell, TranslationManager manager, ITranslation entry, NlsTableController controller) {
        super("New Translation...");
        this.m_controller = controller;
        this.m_shell = (Shell)Ensure.notNull((Object)shell);
        this.m_manager = (TranslationManager)Ensure.notNull((Object)manager);
        this.m_initialEntry = Optional.ofNullable(entry).orElseGet(() -> new Translation(""));
        this.setImageDescriptor(S2ESdkUiActivator.getImageDescriptor("text_add.png"));
        this.setEnabled(manager.isEditable());
    }

    public void run() {
        TranslationNewDialog dialog = new TranslationNewDialog(this.m_shell, this.m_manager, this.m_initialEntry);
        dialog.show().ifPresent(entry -> {
            this.m_createdTranslation = entry;
            this.m_manager.setTranslationToStore(entry, (ITranslationStore)dialog.getSelectedStore().orElse(null));
            if (this.m_controller == null) {
                EclipseEnvironment.runInEclipseEnvironment((arg_0, arg_1) -> ((TranslationManager)this.m_manager).flush(arg_0, arg_1));
            } else {
                this.m_controller.reveal(entry.key());
            }
        });
    }

    public Optional<ITranslation> getCreatedTranslation() {
        return Optional.ofNullable(this.m_createdTranslation);
    }
}

