/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.code;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.s.apidef.IScoutAbstractApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutInterfaceApi;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.code.CodeTypeNewWizard;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractCompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class CodeTypeNewWizardPage
extends AbstractCompilationUnitNewWizardPage {
    private final ProposalTextField[] m_typeArgFields;
    private static final int NUM_ARG_FIELDS = 3;
    private EclipseEnvironment m_provider;

    public CodeTypeNewWizardPage(PackageContainer packageContainer) {
        super(CodeTypeNewWizardPage.class.getName(), packageContainer, "CodeType", ScoutTier.Shared);
        this.setTitle("Create a new CodeType");
        this.setDescription(this.getTitle());
        this.setIcuGroupName("New CodeType Details");
        this.m_typeArgFields = new ProposalTextField[3];
    }

    @Override
    protected Optional<ITypeNameSupplier> calcSuperTypeDefaultFqn() {
        return this.scoutApi().map(IScoutAbstractApi::AbstractCodeType);
    }

    @Override
    protected Optional<ITypeNameSupplier> calcSuperTypeDefaultBaseFqn() {
        return this.scoutApi().map(IScoutInterfaceApi::ICodeType);
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.m_provider = EclipseEnvironment.createUnsafe(env -> this.getControl().addDisposeListener(e -> env.close()));
        this.createArgumentsGroup(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_code-type_page_context");
    }

    protected void createArgumentsGroup(Composite p) {
        Group parent = FieldToolkit.createGroupBox(p, "Type Arguments");
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).applyTo((Control)parent);
        GridLayoutFactory.swtDefaults().applyTo((Composite)parent);
        for (int i = 0; i < 3; ++i) {
            this.m_typeArgFields[i] = FieldToolkit.createTypeProposalField((Composite)parent, CodeTypeNewWizardPage.getTypeArgLabel(i), this.getJavaProject(), this.getLabelWidth());
            this.m_typeArgFields[i].addProposalListener(proposal -> this.pingStateChanging());
            GridDataFactory.defaultsFor((Control)this.m_typeArgFields[i]).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_typeArgFields[i]);
        }
        this.syncTypeArgFieldsToSuperType();
    }

    protected static String getTypeArgLabel(int index) {
        switch (index) {
            case 0: {
                return "First Argument";
            }
            case 1: {
                return "Second Argument";
            }
            case 2: {
                return "Third Argument";
            }
        }
        throw new SdkException((CharSequence)("unsupported index: " + index), new Object[0]);
    }

    @Override
    protected void handleJavaProjectChanged() {
        super.handleJavaProjectChanged();
        if (!this.isControlCreated()) {
            return;
        }
        for (ProposalTextField field : this.m_typeArgFields) {
            ((StrictHierarchyTypeContentProvider)field.getContentProvider()).setJavaProject(this.getJavaProject());
        }
    }

    @Override
    protected void handleSuperTypeChanged() {
        super.handleSuperTypeChanged();
        if (this.isControlCreated()) {
            this.syncTypeArgFieldsToSuperType();
        }
    }

    protected void syncTypeArgFieldsToSuperType() {
        IType superType = this.getSuperType();
        if (!JdtUtils.exists((IJavaElement)superType)) {
            for (ProposalTextField field : this.m_typeArgFields) {
                field.setEnabled(false);
            }
        } else {
            List typeParameters = this.m_provider.toScoutType(superType).typeParameters().collect(Collectors.toList());
            for (int i = 0; i < 3; ++i) {
                boolean typeParamAvailable = typeParameters.size() > i;
                this.m_typeArgFields[i].setEnabled(typeParamAvailable);
                if (!typeParamAvailable) continue;
                List bounds = ((ITypeParameter)typeParameters.get(i)).bounds().collect(Collectors.toList());
                StrictHierarchyTypeContentProvider typeContentProvider = (StrictHierarchyTypeContentProvider)this.m_typeArgFields[i].getContentProvider();
                if (bounds.isEmpty()) {
                    typeContentProvider.setBaseClassFqn(null);
                    continue;
                }
                typeContentProvider.setBaseClassFqn(((org.eclipse.scout.sdk.core.model.api.IType)bounds.get(0)).name());
            }
        }
    }

    public String getSuperClassReference(EclipseEnvironment environment) {
        IType superType = this.getSuperType();
        StringBuilder superTypeBuilder = new StringBuilder(superType.getFullyQualifiedName());
        try {
            int numParams = superType.getTypeParameters().length;
            if (numParams > 0) {
                superTypeBuilder.append('<');
                for (int i = 0; i < numParams; ++i) {
                    String param;
                    if (i != 0) {
                        superTypeBuilder.append(',');
                    }
                    boolean appendCodeGeneric = false;
                    if (i < 3) {
                        IType selectedProposal = (IType)this.m_typeArgFields[i].getSelectedProposal();
                        Optional<IScoutApi> scoutApi = this.scoutApi();
                        appendCodeGeneric = selectedProposal.getTypeParameters().length > 0 && scoutApi.isPresent() && JdtUtils.hierarchyContains((ITypeHierarchy)selectedProposal.newSupertypeHierarchy(null), (String)scoutApi.orElseThrow().ICode().fqn());
                        param = selectedProposal.getFullyQualifiedName();
                    } else {
                        param = Object.class.getName();
                    }
                    superTypeBuilder.append(param);
                    if (!appendCodeGeneric) continue;
                    superTypeBuilder.append('<');
                    superTypeBuilder.append(this.getCodeIdDataType(environment));
                    superTypeBuilder.append('>');
                }
                superTypeBuilder.append('>');
            }
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
        return superTypeBuilder.toString();
    }

    public String getCodeIdDataType(EclipseEnvironment environment) {
        IScoutInterfaceApi.ICodeType iCodeTypeApi = this.scoutApi().orElseThrow().ICodeType();
        return this.getCodeTypeTypeArgDatatype(iCodeTypeApi.codeIdTypeParamIndex(), (ITypeNameSupplier)iCodeTypeApi, environment);
    }

    public String getCodeTypeIdDataType(EclipseEnvironment environment) {
        IScoutInterfaceApi.ICodeType iCodeTypeApi = this.scoutApi().orElseThrow().ICodeType();
        return this.getCodeTypeTypeArgDatatype(iCodeTypeApi.codeTypeIdTypeParamIndex(), (ITypeNameSupplier)iCodeTypeApi, environment);
    }

    protected String getCodeTypeTypeArgDatatype(int typeParamIndex, ITypeNameSupplier iCodeTypeApi, EclipseEnvironment environment) {
        org.eclipse.scout.sdk.core.model.api.IType superType = environment.toScoutType(this.getSuperType());
        org.eclipse.scout.sdk.core.model.api.IType codeTypeIdArg = (org.eclipse.scout.sdk.core.model.api.IType)((org.eclipse.scout.sdk.core.model.api.IType)superType.superTypes().withSelf(false).withName((CharSequence)iCodeTypeApi.fqn()).first().orElseThrow()).typeArguments().skip(typeParamIndex).findAny().orElseThrow();
        if (codeTypeIdArg.isParameterType()) {
            List typeParameters = superType.typeParameters().collect(Collectors.toList());
            int index = IntStream.range(0, typeParameters.size()).filter(i -> ((ITypeParameter)typeParameters.get(i)).elementName().equals(codeTypeIdArg.elementName())).findFirst().orElse(-1);
            IType result = null;
            if (index >= 0 && index < 3) {
                result = (IType)this.m_typeArgFields[index].getSelectedProposal();
            }
            if (result != null) {
                return result.getFullyQualifiedName();
            }
        } else {
            return codeTypeIdArg.reference();
        }
        return Object.class.getName();
    }

    public CodeTypeNewWizard getWizard() {
        return (CodeTypeNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        super.validatePage(multiStatus);
        multiStatus.add(this.getStatusTypeArgFields());
    }

    protected IStatus getStatusTypeArgFields() {
        boolean missing;
        if (this.isControlCreated() && (missing = Arrays.stream(this.m_typeArgFields).filter(ProposalTextField::isEnabled).map(field -> (IJavaElement)field.getSelectedProposal()).anyMatch(selected -> !JdtUtils.exists((IJavaElement)selected)))) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose the type arguments.");
        }
        return Status.OK_STATUS;
    }
}

