/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.util.search.FileQueryInput;
import org.eclipse.scout.sdk.core.s.util.search.IFileQuery;
import org.eclipse.scout.sdk.core.s.util.search.IFileQueryResult;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class EclipseWorkspaceWalker {
    private final String m_taskName;
    private final Collection<String> m_fileExtensions;
    private boolean m_skipOutputLocation;
    private boolean m_skipHiddenPaths;
    private boolean m_skipNodeModules;
    private BiPredicate<Path, BasicFileAttributes> m_fileFilter;

    public EclipseWorkspaceWalker(String taskName) {
        this.m_taskName = (String)Ensure.notNull((Object)taskName);
        this.m_fileExtensions = new ArrayList<String>();
        this.m_skipOutputLocation = true;
        this.m_skipHiddenPaths = true;
        this.m_skipNodeModules = true;
    }

    public static IFileQueryResult executeQuerySync(IFileQuery query, IProgressMonitor monitor) {
        return (IFileQueryResult)EclipseEnvironment.callInEclipseEnvironmentSync((e, p) -> EclipseWorkspaceWalker.executeQueryInWorkspace(query, e, p), monitor);
    }

    public static IFuture<IFileQueryResult> executeQuery(IFileQuery query) {
        return EclipseEnvironment.callInEclipseEnvironment((e, p) -> EclipseWorkspaceWalker.executeQueryInWorkspace(query, e, p), null, query.name());
    }

    protected static IFileQuery executeQueryInWorkspace(IFileQuery query, IEnvironment e, EclipseProgress p) {
        try {
            new EclipseWorkspaceWalker(query.name()).walk((file, progress) -> EclipseWorkspaceWalker.executeQueryInFile(query, file, e, progress), (IProgressMonitor)p.monitor());
            return query;
        }
        catch (CoreException ex) {
            throw new SdkException((Throwable)ex);
        }
    }

    protected static void executeQueryInFile(IFileQuery query, WorkspaceFile file, IEnvironment env, IProgress progress) {
        if (!file.inWorkspace().isPresent()) {
            SdkLog.warning((CharSequence)"File '{}' could not be found in the current Eclipse Workspace.", (Object[])new Object[]{file.path()});
            return;
        }
        Path modulePath = file.inWorkspace().get().getProject().getLocation().toFile().toPath();
        FileQueryInput candidate = new FileQueryInput(file.path(), modulePath, file::content);
        query.searchIn(candidate, env, progress);
    }

    public void walk(BiConsumer<WorkspaceFile, IProgress> visitor, IProgressMonitor monitor) throws CoreException {
        Ensure.notNull(visitor);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.taskName(), (int)(projects.length * 2));
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            Path projectPath;
            IProject root = iProjectArray[n2];
            Set<Path> outputLocations = Collections.emptySet();
            subMonitor.subTask(root.getName());
            if (this.isSkipOutputLocation()) {
                IJavaProject jp = JavaCore.create((IProject)root);
                outputLocations = EclipseWorkspaceWalker.getOutputLocations(jp);
            }
            if (Files.exists(projectPath = root.getLocation().toFile().toPath(), new LinkOption[0])) {
                this.searchInFolder(visitor, projectPath, Charset.forName(root.getDefaultCharset()), outputLocations, (IProgressMonitor)subMonitor.newChild(1));
            }
            if (subMonitor.isCanceled()) {
                return;
            }
            subMonitor.worked(1);
            ++n2;
        }
    }

    protected static Set<Path> getOutputLocations(IJavaProject jp) throws JavaModelException {
        if (!JdtUtils.exists((IJavaElement)jp)) {
            return Collections.emptySet();
        }
        String projectDir = jp.getProject().getLocation().toOSString();
        IClasspathEntry[] rawClasspath = jp.getRawClasspath();
        return Stream.of(rawClasspath).map(IClasspathEntry::getOutputLocation).filter(Objects::nonNull).map(location -> location.removeFirstSegments(1).toOSString()).map(location -> Paths.get(projectDir, location)).collect(Collectors.toSet());
    }

    protected void searchInFolder(final BiConsumer<WorkspaceFile, IProgress> visitor, Path folder, final Charset charset, final Collection<Path> outputFolders, final IProgressMonitor monitor) {
        try {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (monitor.isCanceled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    if (outputFolders.contains(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (!EclipseWorkspaceWalker.this.directoryFiltersAccepted(dir, attrs)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (monitor.isCanceled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    if (EclipseWorkspaceWalker.this.allFiltersAccepted(file, attrs)) {
                        visitor.accept(new WorkspaceFile(file, charset), EclipseEnvironment.toScoutProgress(monitor));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected boolean directoryFiltersAccepted(Path file, BasicFileAttributes attrs) {
        if (this.isSkipHiddenPaths() && EclipseWorkspaceWalker.isHidden(file)) {
            return false;
        }
        Path fileName = file.getFileName();
        if (this.isSkipNodeModules() && fileName != null && "node_modules".equals(fileName.toString())) {
            return false;
        }
        return this.fileFilter().map(filter -> filter.test(file, attrs)).orElse(Boolean.TRUE);
    }

    protected boolean allFiltersAccepted(Path file, BasicFileAttributes attrs) {
        if (!this.acceptFileExtension(file)) {
            return false;
        }
        return this.directoryFiltersAccepted(file, attrs);
    }

    protected boolean acceptFileExtension(Path file) {
        if (this.extensionsAccepted().isEmpty()) {
            return true;
        }
        Path path = file.getFileName();
        if (path == null) {
            return false;
        }
        String fileName = path.toString().toLowerCase(Locale.ENGLISH);
        for (String extension : this.extensionsAccepted()) {
            if (!fileName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isHidden(Path path) {
        Path fileName = path.getFileName();
        return fileName != null && fileName.toString().startsWith(".");
    }

    public String taskName() {
        return this.m_taskName;
    }

    public boolean isSkipOutputLocation() {
        return this.m_skipOutputLocation;
    }

    public EclipseWorkspaceWalker withSkipOutputLocation(boolean skipOutputLocation) {
        this.m_skipOutputLocation = skipOutputLocation;
        return this;
    }

    public boolean isSkipHiddenPaths() {
        return this.m_skipHiddenPaths;
    }

    public EclipseWorkspaceWalker withSkipHiddenPaths(boolean skipHiddenPaths) {
        this.m_skipHiddenPaths = skipHiddenPaths;
        return this;
    }

    public boolean isSkipNodeModules() {
        return this.m_skipNodeModules;
    }

    public EclipseWorkspaceWalker withSkipNodeModules(boolean skipNodeModules) {
        this.m_skipNodeModules = skipNodeModules;
        return this;
    }

    public Optional<BiPredicate<Path, BasicFileAttributes>> fileFilter() {
        return Optional.ofNullable(this.m_fileFilter);
    }

    public EclipseWorkspaceWalker withFilter(BiPredicate<Path, BasicFileAttributes> fileFilter) {
        this.m_fileFilter = fileFilter;
        return this;
    }

    public Collection<String> extensionsAccepted() {
        return Collections.unmodifiableCollection(this.m_fileExtensions);
    }

    public EclipseWorkspaceWalker withExtensionsAccepted(String ... extensions) {
        List<String> l = extensions == null ? null : Arrays.asList(extensions);
        return this.withExtensionsAccepted(l);
    }

    public EclipseWorkspaceWalker withExtensionsAccepted(Collection<String> extensions) {
        this.m_fileExtensions.clear();
        if (extensions != null && !extensions.isEmpty()) {
            for (String e : extensions) {
                if (!Strings.hasText((CharSequence)e)) continue;
                this.m_fileExtensions.add(e);
            }
        }
        return this;
    }

    public static class WorkspaceFile {
        private final Path m_file;
        private final Charset m_charset;
        private final FinalValue<IFile> m_workspaceFile;
        private char[] m_content;

        public WorkspaceFile(Path file, Charset charset) {
            this.m_file = (Path)Ensure.notNull((Object)file);
            this.m_charset = (Charset)Ensure.notNull((Object)charset);
            this.m_workspaceFile = new FinalValue();
        }

        public Charset charset() {
            return this.m_charset;
        }

        public Path path() {
            return this.m_file;
        }

        public Optional<IFile> inWorkspace() {
            return Optional.ofNullable((IFile)this.m_workspaceFile.computeIfAbsentAndGet(() -> WorkspaceFile.resolveInWorkspace(this.path())));
        }

        protected static IFile resolveInWorkspace(Path file) {
            IFile[] workspaceFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toUri());
            if (workspaceFiles.length < 1) {
                return null;
            }
            IFile workspaceFile = workspaceFiles[0];
            if (!workspaceFile.exists()) {
                return null;
            }
            return workspaceFile;
        }

        public char[] content() {
            if (this.m_content == null) {
                try {
                    this.m_content = Strings.fromFileAsChars((Path)this.path(), (Charset)this.charset());
                }
                catch (IOException e) {
                    throw new SdkException((CharSequence)"Unable to read content of file '{}'.", new Object[]{this.path(), e});
                }
            }
            return this.m_content;
        }

        public String toString() {
            return String.valueOf(WorkspaceFile.class.getSimpleName()) + ": " + this.path();
        }

        public int hashCode() {
            return this.m_file.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            WorkspaceFile other = (WorkspaceFile)obj;
            return this.m_file.equals(other.m_file);
        }
    }
}

