/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.proposal.content;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.AbstractContentProviderAdapter;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class StrictHierarchyTypeContentProvider
extends AbstractContentProviderAdapter {
    private String m_baseClassFqn;
    private IJavaProject m_javaProject;
    private Predicate<IType> m_typeProposalFilter;

    public StrictHierarchyTypeContentProvider(IJavaProject javaProject, String baseClassFqn) {
        this.setJavaProject(javaProject);
        this.setBaseClassFqn(baseClassFqn);
    }

    @Override
    protected Collection<?> loadProposals(IProgressMonitor monitor) {
        IJavaProject javaProject = this.getJavaProject();
        if (!JdtUtils.exists((IJavaElement)javaProject)) {
            return Collections.emptyList();
        }
        try {
            return JdtUtils.findClassesInStrictHierarchy((IJavaProject)javaProject, (String)this.getBaseClassFqn(), (IProgressMonitor)monitor, this.getTypeProposalFilter());
        }
        catch (RuntimeException e) {
            SdkLog.error((String)"Error loading super type proposals in project {} for base class {}", (Object[])new Object[]{javaProject.getElementName(), this.getBaseClassFqn(), e});
            return Collections.emptyList();
        }
    }

    public String getText(Object element) {
        return ((IJavaElement)element).getElementName();
    }

    @Override
    public String getTextSelected(Object element) {
        IType t = (IType)element;
        StringBuilder sb = new StringBuilder(t.getElementName());
        String elementName = t.getPackageFragment().getElementName();
        if (Strings.hasText((CharSequence)elementName)) {
            sb.append(" - ").append(elementName);
        }
        return sb.toString();
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public void setJavaProject(IJavaProject javaProject) {
        if (Objects.equals(javaProject, this.getJavaProject())) {
            return;
        }
        this.m_javaProject = javaProject;
        this.clearCache();
    }

    public String getBaseClassFqn() {
        return this.m_baseClassFqn;
    }

    public void setBaseClassFqn(String baseClassFqn) {
        if (Objects.equals(baseClassFqn, this.getBaseClassFqn())) {
            return;
        }
        this.m_baseClassFqn = baseClassFqn;
        this.clearCache();
    }

    public Predicate<IType> getTypeProposalFilter() {
        return this.m_typeProposalFilter;
    }

    public void setTypeProposalFilter(Predicate<IType> typeProposalFilter) {
        if (Objects.equals(typeProposalFilter, this.getTypeProposalFilter())) {
            return;
        }
        this.m_typeProposalFilter = typeProposalFilter;
        this.clearCache();
    }
}

