/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.proposal;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.Translation;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.action.TranslationNewAction;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.proposal.AbstractTranslationProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TranslationNewProposal
extends AbstractTranslationProposal {
    private final Image m_image;
    private final TranslationStoreStack m_stack;

    public TranslationNewProposal(TranslationStoreStack project, String prefix, int initialOffset) {
        super(prefix, initialOffset);
        this.m_stack = project;
        this.m_image = S2ESdkUiActivator.getImage("text_add.png");
    }

    @Override
    public int getRelevance() {
        return 0;
    }

    @Override
    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument(), trigger, offset);
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        String searchText = null;
        int initalOffset = this.getInitialOffset();
        try {
            searchText = document.get(initalOffset - this.getPrefix().length(), this.getPrefix().length() + offset - initalOffset);
        }
        catch (BadLocationException e1) {
            SdkLog.warning((Object[])new Object[]{e1});
        }
        String proposalFieldText = Strings.isBlank(searchText) ? "" : Strings.fromStringLiteral((String)(String.valueOf('\"') + searchText + '\"'));
        String key = this.m_stack.generateNewKey(proposalFieldText);
        Translation entry = new Translation(key);
        entry.putText(Language.LANGUAGE_DEFAULT, proposalFieldText);
        TranslationNewAction action = new TranslationNewAction(Display.getDefault().getActiveShell(), this.m_stack, (ITranslation)entry);
        action.run();
        action.getCreatedTranslation().ifPresent(createdEntry -> {
            try {
                this.replaceWith(document, offset, createdEntry.key());
            }
            catch (BadLocationException e) {
                SdkLog.warning((Object[])new Object[]{e});
            }
        });
    }

    public String getDisplayString() {
        return "New text...";
    }

    public Image getImage() {
        return this.m_image;
    }
}

