/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.tab;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;
import org.eclipse.rap.tools.launch.rwt.internal.tab.ApplicationTypeSelectionDialog;
import org.eclipse.rap.tools.launch.rwt.internal.tab.HelpContextIds;
import org.eclipse.rap.tools.launch.rwt.internal.tab.RWTLaunchTab;
import org.eclipse.rap.tools.launch.rwt.internal.tab.SearchText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class ApplicationSection
extends RWTLaunchTab {
    private static final int MARGIN = 20;
    private Button rbEntryPoint;
    private SearchText stEntryPoint;
    private Button rbAppConfig;
    private SearchText stAppConfig;
    private Button rbWebXml;
    private SearchText stWebXmlLocation;

    public String getName() {
        return "RWT Application";
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Application");
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        this.rbEntryPoint = this.createLaunchTargetRadioButton((Composite)group, "Run &entry point");
        this.stEntryPoint = new SearchText((Composite)group, "Class name:", "Search...", 20);
        this.stEntryPoint.addModifyListener(new TextModifyListener());
        this.stEntryPoint.addSelectionListener((SelectionListener)new EntryPointClassSelectionListener());
        this.rbAppConfig = this.createLaunchTargetRadioButton((Composite)group, "Run &application configuration");
        this.stAppConfig = new SearchText((Composite)group, "Class name:", "Search...", 20);
        this.stAppConfig.addModifyListener(new TextModifyListener());
        this.stAppConfig.addSelectionListener((SelectionListener)new AppConfigClassSelectionListener());
        this.rbWebXml = this.createLaunchTargetRadioButton((Composite)group, "Run from &web.xml");
        this.stWebXmlLocation = new SearchText((Composite)group, "Location:", "Search...", 20);
        this.stWebXmlLocation.addModifyListener(new TextModifyListener());
        this.stWebXmlLocation.addSelectionListener((SelectionListener)new WebXmlSelectionListener());
        Dialog.applyDialogFont((Control)group);
        this.setControl((Control)group);
        HelpContextIds.assign(this.getControl(), HelpContextIds.MAIN_TAB);
        this.updateEnablement();
    }

    public void initializeFrom(RWTLaunchConfig launchConfig) {
        this.rbEntryPoint.setSelection(RWTLaunchConfig.LaunchTarget.ENTRY_POINT.equals((Object)launchConfig.getLaunchTarget()));
        this.rbAppConfig.setSelection(RWTLaunchConfig.LaunchTarget.APP_CONFIG.equals((Object)launchConfig.getLaunchTarget()));
        this.rbWebXml.setSelection(RWTLaunchConfig.LaunchTarget.WEB_XML.equals((Object)launchConfig.getLaunchTarget()));
        this.stEntryPoint.setText(launchConfig.getEntryPoint());
        this.stAppConfig.setText(launchConfig.getAppConfig());
        this.stWebXmlLocation.setText(launchConfig.getWebXmlLocation());
        this.updateEnablement();
    }

    public void performApply(RWTLaunchConfig launchConfig) {
        if (this.rbEntryPoint.getSelection()) {
            launchConfig.setLaunchTarget(RWTLaunchConfig.LaunchTarget.ENTRY_POINT);
        } else if (this.rbAppConfig.getSelection()) {
            launchConfig.setLaunchTarget(RWTLaunchConfig.LaunchTarget.APP_CONFIG);
        } else if (this.rbWebXml.getSelection()) {
            launchConfig.setLaunchTarget(RWTLaunchConfig.LaunchTarget.WEB_XML);
        }
        launchConfig.setEntryPoint(this.stEntryPoint.getText());
        launchConfig.setAppConfig(this.stAppConfig.getText());
        launchConfig.setWebXmlLocation(this.stWebXmlLocation.getText());
    }

    private void updateEnablement() {
        this.stEntryPoint.setEnabled(this.rbEntryPoint.getSelection());
        this.stAppConfig.setEnabled(this.rbAppConfig.getSelection());
        this.stWebXmlLocation.setEnabled(this.rbWebXml.getSelection());
    }

    private void selectWebXml() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int file = 1;
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)root, file);
        dialog.setTitle("Web.xml Selection");
        if (dialog.open() == 0 && dialog.getResult().length > 0) {
            IResource selection = (IResource)dialog.getResult()[0];
            this.stWebXmlLocation.setText(selection.getFullPath().toPortableString());
        }
    }

    private void selectEntryPointClass() {
        ApplicationTypeSelectionDialog dialog = new ApplicationTypeSelectionDialog(this.getShell());
        if (dialog.open()) {
            this.stEntryPoint.setText(dialog.getSelection().getFullyQualifiedName());
        }
    }

    private void selectAppConfigClass() {
        ApplicationTypeSelectionDialog dialog = new ApplicationTypeSelectionDialog(this.getShell());
        if (dialog.open()) {
            this.stAppConfig.setText(dialog.getSelection().getFullyQualifiedName());
        }
    }

    private Button createLaunchTargetRadioButton(Composite parent, String label) {
        Button result = this.createRadioButton(parent, label);
        result.setLayoutData((Object)ApplicationSection.newGridData(3, 0));
        result.addSelectionListener((SelectionListener)new LaunchTargetSelectionListener());
        return result;
    }

    private static GridData newGridData(int horizontalSpan, int horizontalIndent) {
        GridData result = new GridData();
        result.horizontalSpan = horizontalSpan;
        result.horizontalIndent = horizontalIndent;
        return result;
    }

    private class AppConfigClassSelectionListener
    extends SelectionAdapter {
        private AppConfigClassSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ApplicationSection.this.selectAppConfigClass();
            ApplicationSection.this.updateLaunchConfigurationDialog();
        }
    }

    private class EntryPointClassSelectionListener
    extends SelectionAdapter {
        private EntryPointClassSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ApplicationSection.this.selectEntryPointClass();
            ApplicationSection.this.updateLaunchConfigurationDialog();
        }
    }

    private class LaunchTargetSelectionListener
    extends SelectionAdapter {
        private LaunchTargetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ApplicationSection.this.updateEnablement();
            ApplicationSection.this.updateLaunchConfigurationDialog();
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            ApplicationSection.this.updateLaunchConfigurationDialog();
        }
    }

    private class WebXmlSelectionListener
    extends SelectionAdapter {
        private WebXmlSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ApplicationSection.this.selectWebXml();
            ApplicationSection.this.updateLaunchConfigurationDialog();
        }
    }
}

